/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.pea;

import de.uni_freiburg.informatik.ultimate.lib.pea.CDD;
import de.uni_freiburg.informatik.ultimate.lib.pea.InitialTransition;
import de.uni_freiburg.informatik.ultimate.lib.pea.PhaseBits;
import de.uni_freiburg.informatik.ultimate.lib.pea.RangeDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.Transition;
import de.uni_freiburg.informatik.ultimate.lib.pea.util.SimpleSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class Phase
implements Comparable<Phase> {
    private final boolean mIsKernel;
    private boolean mIsInit;
    private final boolean mIsEntry;
    private final boolean mIsExit;
    private final List<Transition> mIncomming;
    private String mName;
    private CDD mStateInv;
    private CDD mClockInv;
    private final Set<String> mStoppedClocks;
    private final List<Transition> mTransitions;
    private boolean mIsTerminal;
    private final boolean mIsStrict;
    private InitialTransition mInitialTransition;
    private final List<RangeDecision> mModifiedConstraints;
    PhaseBits phaseBits;

    public Phase(String string, CDD cDD, CDD cDD2, Set<String> set) {
        this.mName = string;
        this.setStateInv(cDD);
        this.setClockInv(cDD2);
        this.mTransitions = new ArrayList<Transition>();
        this.mStoppedClocks = set;
        this.mIsKernel = false;
        this.mIsInit = false;
        this.mIsEntry = false;
        this.mIsExit = false;
        this.mIncomming = new Vector<Transition>();
        this.mIsTerminal = true;
        this.mInitialTransition = null;
        this.mIsStrict = RangeDecision.isStrictLess(cDD2);
        this.mModifiedConstraints = new ArrayList<RangeDecision>();
    }

    public Phase(String string, CDD cDD, CDD cDD2) {
        this(string, cDD, cDD2, new SimpleSet<String>(0));
    }

    public Phase(String string, CDD cDD) {
        this(string, cDD, CDD.TRUE);
    }

    public Phase(String string) {
        this(string, CDD.TRUE, CDD.TRUE);
    }

    public boolean isInit() {
        return this.mIsInit;
    }

    public void setInit(boolean bl) {
        this.mIsInit = bl;
    }

    public PhaseBits getPhaseBits() {
        return this.phaseBits;
    }

    public CDD getStateInvariant() {
        return this.getStateInv();
    }

    public void setStateInvariant(CDD cDD) {
        this.setStateInv(cDD);
    }

    public CDD getClockInvariant() {
        return this.getClockInv();
    }

    public Set<String> getStoppedClocks() {
        return this.mStoppedClocks;
    }

    public boolean isStopped(String string) {
        return this.getStoppedClocks().contains(string);
    }

    public List<Transition> getTransitions() {
        return this.mTransitions;
    }

    public Transition getOutgoingTransition(Phase phase) {
        Transition transition = null;
        for (Transition transition2 : this.getTransitions()) {
            if (!transition2.getDest().equals(phase)) continue;
            transition = transition2;
            break;
        }
        return transition;
    }

    public Transition addTransition(Phase phase, CDD cDD, String[] stringArray) {
        Transition transition2;
        for (Transition transition2 : this.getTransitions()) {
            if (transition2.getDest() != phase || !Arrays.equals(transition2.getResets(), stringArray)) continue;
            transition2.setGuard(transition2.getGuard().or(cDD));
            return transition2;
        }
        transition2 = new Transition(this, cDD, stringArray, phase);
        this.getTransitions().add(transition2);
        return transition2;
    }

    public String toString() {
        return this.mName;
    }

    public String getName() {
        return this.mName;
    }

    public void dump() {
        System.err.println("  state " + String.valueOf(this) + " { ");
        if (this.getStateInv() != CDD.TRUE) {
            System.err.println("    predicate      " + String.valueOf(this.getStateInv()));
        }
        if (this.getClockInv() != CDD.TRUE) {
            System.err.println("    clockinvariant " + String.valueOf(this.getClockInv()));
        }
        for (String object2 : this.getStoppedClocks()) {
            System.err.println("    stopped " + object2);
        }
        System.err.println("    transitions {");
        Iterator<Transition> iterator = this.getTransitions().iterator();
        while (iterator.hasNext()) {
            System.err.println("       " + String.valueOf(iterator.next()));
        }
        System.err.println("    }");
        System.err.println("  }");
    }

    public void dumpDot() {
        System.out.println("  " + this.mName + " [ label = \"" + String.valueOf(this.getStateInv()) + "\\n" + String.valueOf(this.getClockInv()) + "\" shape=ellipse ]");
        for (Transition transition : this.getTransitions()) {
            System.out.println("  " + transition.getSrc().mName + " -> " + transition.getDest().mName + " [ label = \"" + String.valueOf(transition.getGuard()) + "\" ]");
        }
    }

    public String getFlags() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.mIsInit) {
            stringBuilder.append(" Init ");
        }
        if (this.mIsKernel) {
            stringBuilder.append(" Kernel ");
        }
        if (this.mIsEntry) {
            stringBuilder.append(" Entry ");
        }
        if (this.mIsExit) {
            stringBuilder.append(" Exit ");
        }
        return stringBuilder.toString();
    }

    public void setName(String string) {
        this.mName = string;
    }

    @Override
    public int compareTo(Phase phase) {
        return this.mName.compareTo(phase.mName);
    }

    public void addIncomming(Transition transition) {
        this.mIncomming.add(transition);
    }

    public void removeIncomming(Transition transition) {
        this.mIncomming.remove(transition);
    }

    public boolean getTerminal() {
        return this.mIsTerminal;
    }

    public void setTerminal(boolean bl) {
        this.mIsTerminal = bl;
    }

    public void setInitialTransition(InitialTransition initialTransition) {
        this.mInitialTransition = initialTransition;
        this.mIsInit = true;
    }

    public void setModifiedConstraints(List<RangeDecision> list) {
        this.mModifiedConstraints.addAll(list);
    }

    public List<RangeDecision> getModifiedConstraints() {
        return this.mModifiedConstraints;
    }

    public boolean isStrict() {
        return this.mIsStrict;
    }

    public CDD getStateInv() {
        return this.mStateInv;
    }

    public void setStateInv(CDD cDD) {
        this.mStateInv = cDD;
    }

    public CDD getClockInv() {
        return this.mClockInv;
    }

    public void setClockInv(CDD cDD) {
        this.mClockInv = cDD;
    }

    public InitialTransition getInitialTransition() {
        return this.mInitialTransition;
    }
}

