/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin.services;

import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.KeyValueUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class PreferenceLayer
implements IPreferenceProvider {
    private final IPreferenceProvider mBacking;
    private final Map<String, Object> mPreferenceOverlay;
    private final Class<?> mCreator;

    public PreferenceLayer(IPreferenceProvider iPreferenceProvider, Class<?> clazz) {
        this.mBacking = Objects.requireNonNull(iPreferenceProvider);
        this.mPreferenceOverlay = new HashMap<String, Object>();
        this.mCreator = Objects.requireNonNull(clazz);
    }

    public boolean getBoolean(String string) {
        return this.getFromOverlay(string, Boolean::parseBoolean, arg_0 -> ((IPreferenceProvider)this.mBacking).getBoolean(arg_0));
    }

    public boolean getBoolean(String string2, boolean bl) {
        return this.getFromOverlay(string2, Boolean::parseBoolean, string -> this.mBacking.getBoolean(string, bl));
    }

    public String getString(String string2) {
        return this.getFromOverlay(string2, string -> string, arg_0 -> ((IPreferenceProvider)this.mBacking).getString(arg_0));
    }

    public String getString(String string3, String string4) {
        return this.getFromOverlay(string3, string -> string, string2 -> this.mBacking.getString(string2, string4));
    }

    public <T extends Enum<T>> T getEnum(String string2, Class<T> clazz) {
        return (T)this.getFromOverlay(string2, string -> Enum.valueOf(clazz, string), string -> this.mBacking.getEnum(string, clazz));
    }

    public <T extends Enum<T>> T getEnum(String string2, T t, Class<T> clazz) {
        return (T)this.getFromOverlay(string2, string -> Enum.valueOf(clazz, string), string -> this.mBacking.getEnum(string, t, clazz));
    }

    public byte[] getByteArray(String string) {
        return this.getFromOverlay(string, String::getBytes, arg_0 -> ((IPreferenceProvider)this.mBacking).getByteArray(arg_0));
    }

    public byte[] getByteArray(String string2, byte[] byArray) {
        return this.getFromOverlay(string2, String::getBytes, string -> this.mBacking.getByteArray(string, byArray));
    }

    public double getDouble(String string) {
        return this.getFromOverlay(string, Double::parseDouble, arg_0 -> ((IPreferenceProvider)this.mBacking).getDouble(arg_0));
    }

    public double getDouble(String string2, double d) {
        return this.getFromOverlay(string2, Double::parseDouble, string -> this.mBacking.getDouble(string, d));
    }

    public float getFloat(String string) {
        return this.getFromOverlay(string, Float::parseFloat, arg_0 -> ((IPreferenceProvider)this.mBacking).getFloat(arg_0)).floatValue();
    }

    public float getFloat(String string2, float f) {
        return this.getFromOverlay(string2, Float::parseFloat, string -> Float.valueOf(this.mBacking.getFloat(string, f))).floatValue();
    }

    public int getInt(String string) {
        return this.getFromOverlay(string, Integer::parseInt, arg_0 -> ((IPreferenceProvider)this.mBacking).getInt(arg_0));
    }

    public int getInt(String string2, int n) {
        return this.getFromOverlay(string2, Integer::parseInt, string -> this.mBacking.getInt(string, n));
    }

    public long getLong(String string) {
        return this.getFromOverlay(string, Long::parseLong, arg_0 -> ((IPreferenceProvider)this.mBacking).getLong(arg_0));
    }

    public long getLong(String string2, long l) {
        return this.getFromOverlay(string2, Long::parseLong, string -> this.mBacking.getLong(string, l));
    }

    public Map<String, String> getKeyValueMap(String string) {
        return this.getFromOverlay(string, KeyValueUtil::toMap, arg_0 -> ((IPreferenceProvider)this.mBacking).getKeyValueMap(arg_0));
    }

    public void put(String string, String string2) {
        this.put(string, (Object)string2);
    }

    public void put(String string, Object object) {
        this.mPreferenceOverlay.put(string, object);
    }

    private <T> T getFromOverlay(String string, Function<String, T> function, Function<String, T> function2) {
        Object object = this.mPreferenceOverlay.get(string);
        if (object != null) {
            if (object instanceof String) {
                return function.apply((String)object);
            }
            return (T)object;
        }
        return function2.apply(string);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " created by " + this.mCreator.getName() + " with " + this.mPreferenceOverlay.size() + " entries";
    }

    IPreferenceProvider getBacking() {
        return this.mBacking;
    }

    public String getSingleLinePreferenceString() {
        throw new UnsupportedOperationException("Overlays do not support showing all available settings");
    }

    public Map<String, Object> getDefaultPreferences() {
        return this.mBacking.getDefaultPreferences();
    }

    public Map<String, Object> getPreferences() {
        Map map = this.mBacking.getPreferences();
        map.putAll(this.mPreferenceOverlay);
        return map;
    }
}

