/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin.services;

import de.uni_freiburg.informatik.ultimate.core.coreplugin.services.BacktranslationService;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.services.GenericServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.services.Log4JLoggingService;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.services.PreferenceLayer;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.services.ProgressMonitorService;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.services.ResultService;
import de.uni_freiburg.informatik.ultimate.core.model.IServiceFactory;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILoggingService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressMonitorService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IResultService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IStorable;
import de.uni_freiburg.informatik.ultimate.core.model.services.IToolchainStorage;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.preferences.RcpPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ToolchainStorage
implements IToolchainStorage,
IUltimateServiceProvider {
    private final Deque<Pair<Object, Set<String>>> mMarker;
    private final Map<String, IStorable> mToolchainStorage;
    private final Map<String, PreferenceLayer> mPreferenceLayers;
    private final Object mLock;

    public ToolchainStorage() {
        this(new LinkedHashMap<String, IStorable>(), new HashMap<String, PreferenceLayer>(), new ArrayDeque<Pair<Object, Set<String>>>(), new Object());
        this.pushMarker(this);
    }

    private ToolchainStorage(Map<String, IStorable> map, Map<String, PreferenceLayer> map2, Deque<Pair<Object, Set<String>>> deque, Object object) {
        this.mLock = Objects.requireNonNull(object);
        this.mToolchainStorage = Objects.requireNonNull(map);
        this.mPreferenceLayers = Objects.requireNonNull(map2);
        this.mMarker = Objects.requireNonNull(deque);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStorable getStorable(String string) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mToolchainStorage.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStorable putStorable(String string, IStorable iStorable) {
        if (iStorable == null || string == null) {
            throw new IllegalArgumentException("Cannot store nothing");
        }
        Object object = this.mLock;
        synchronized (object) {
            Pair<Object, Set<String>> pair = this.mMarker.peek();
            ((Set)pair.getSecond()).add(string);
            return this.mToolchainStorage.put(string, iStorable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStorable removeStorable(String string) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mToolchainStorage.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mLock;
        synchronized (object) {
            Collection<IStorable> collection = this.mToolchainStorage.values();
            if (collection.isEmpty()) {
                return;
            }
            ArrayList<IStorable> arrayList = new ArrayList<IStorable>(collection);
            if (arrayList.isEmpty()) {
                return;
            }
            Collections.reverse(arrayList);
            ILogger iLogger = this.getLoggingService().getLogger("de.uni_freiburg.informatik.ultimate.core");
            if (iLogger.isDebugEnabled()) {
                iLogger.debug((Object)("Clearing " + arrayList.size() + " storables from " + this.getClass().getSimpleName()));
            }
            for (IStorable iStorable : arrayList) {
                if (iStorable == null) {
                    iLogger.warn((Object)"Found NULL storable, ignoring");
                    continue;
                }
                try {
                    iStorable.destroy();
                }
                catch (Throwable throwable) {
                    iLogger.fatal((Object)("There was an exception during clearing of toolchain storage while destroying " + iStorable.getClass().toString() + ": " + throwable.getMessage()));
                }
            }
            this.mToolchainStorage.clear();
            this.mMarker.clear();
            this.pushMarker(this);
        }
    }

    public boolean destroyStorable(String string) {
        IStorable iStorable = this.removeStorable(string);
        if (iStorable != null) {
            iStorable.destroy();
            return true;
        }
        return false;
    }

    public String toString() {
        return this.mToolchainStorage.toString();
    }

    public IBacktranslationService getBacktranslationService() {
        return BacktranslationService.getService(this);
    }

    public ILoggingService getLoggingService() {
        return Log4JLoggingService.getService(this);
    }

    public IResultService getResultService() {
        return ResultService.getService(this);
    }

    public IProgressMonitorService getProgressMonitorService() {
        return ProgressMonitorService.getService(this);
    }

    public <T extends IService, K extends IServiceFactory<T>> T getServiceInstance(Class<K> clazz) {
        return GenericServiceProvider.getServiceInstance(this, clazz);
    }

    public IPreferenceProvider getPreferenceProvider(String string) {
        PreferenceLayer preferenceLayer = this.mPreferenceLayers.get(string);
        if (preferenceLayer != null) {
            return preferenceLayer;
        }
        return new RcpPreferenceProvider(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IUltimateServiceProvider registerPreferenceLayer(Class<?> clazz, String ... stringArray) {
        Object object = this.mLock;
        synchronized (object) {
            if (stringArray == null || stringArray.length == 0) {
                return this;
            }
            HashMap<String, PreferenceLayer> hashMap = new HashMap<String, PreferenceLayer>(this.mPreferenceLayers);
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                PreferenceLayer preferenceLayer = (PreferenceLayer)hashMap.get(string);
                PreferenceLayer preferenceLayer2 = preferenceLayer != null ? new PreferenceLayer(preferenceLayer, clazz) : new PreferenceLayer(this.getPreferenceProvider(string), clazz);
                hashMap.put(string, preferenceLayer2);
                ++n2;
            }
            return new ToolchainStorage(this.mToolchainStorage, hashMap, this.mMarker, this.mLock);
        }
    }

    public IUltimateServiceProvider registerDefaultPreferenceLayer(Class<?> clazz, String ... stringArray) {
        IUltimateServiceProvider iUltimateServiceProvider = this.registerPreferenceLayer(clazz, stringArray);
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            RcpPreferenceProvider rcpPreferenceProvider = new RcpPreferenceProvider(string);
            IPreferenceProvider iPreferenceProvider = iUltimateServiceProvider.getPreferenceProvider(string);
            for (Map.Entry<String, Object> entry : rcpPreferenceProvider.getDefaultPreferences().entrySet()) {
                iPreferenceProvider.put(entry.getKey(), entry.getValue());
            }
            ++n2;
        }
        return iUltimateServiceProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> keys() {
        HashSet<String> hashSet;
        Object object = this.mLock;
        synchronized (object) {
            hashSet = new HashSet<String>(this.mToolchainStorage.keySet());
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushMarker(Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException("marker may not be null");
        }
        if (this.hasMarker(object)) {
            throw new IllegalArgumentException("duplicate marker");
        }
        Object object2 = this.mLock;
        synchronized (object2) {
            this.mMarker.push((Pair<Object, Set<String>>)new Pair(object, new HashSet()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> destroyMarker(Object object) {
        if (this.mMarker.isEmpty() || !this.hasMarker(object)) {
            return Collections.emptySet();
        }
        Object object2 = this.mLock;
        synchronized (object2) {
            HashSet<String> hashSet = new HashSet<String>();
            Iterator<Pair<Object, Set<String>>> iterator = this.mMarker.iterator();
            while (iterator.hasNext()) {
                Pair<Object, Set<String>> pair = iterator.next();
                iterator.remove();
                for (String string : (Set)pair.getSecond()) {
                    if (!this.destroyStorable(string)) continue;
                    hashSet.add(string);
                }
                if (pair.getFirst() != object) continue;
                return hashSet;
            }
            return hashSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasMarker(Object object) {
        assert (object != null);
        Object object3 = this.mLock;
        synchronized (object3) {
            return this.mMarker.stream().map(Pair::getFirst).anyMatch(object2 -> object2 == object);
        }
    }

    public IToolchainStorage getStorage() {
        return this;
    }
}

