/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.DisjunctiveAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.IAbstractStateStorage;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.IWorklistItem;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.LoggingHelper;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.SummaryMap;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;

final class BackwardsWorklistItem<STATE extends IAbstractState<STATE>, ACTION, VARDECL, LOC>
implements IWorklistItem<STATE, ACTION, LOC> {
    private final DisjunctiveAbstractState<STATE> mState;
    private final ACTION mAction;
    private final BackwardsWorklistItem<STATE, ACTION, VARDECL, LOC> mPredecessor;
    private final SummaryMap<STATE, ACTION, LOC> mSummaryMap;
    private final Deque<ScopeStackItem> mScopes;
    private ScopeStackItem mCurrentScope;

    BackwardsWorklistItem(DisjunctiveAbstractState<STATE> disjunctiveAbstractState, ACTION ACTION, IAbstractStateStorage<STATE, ACTION, LOC> iAbstractStateStorage, SummaryMap<STATE, ACTION, LOC> summaryMap) {
        this.mState = disjunctiveAbstractState;
        this.mAction = ACTION;
        this.mPredecessor = null;
        this.mSummaryMap = summaryMap;
        this.mCurrentScope = new ScopeStackItem(iAbstractStateStorage, disjunctiveAbstractState);
        this.mScopes = new ArrayDeque<ScopeStackItem>();
        this.mScopes.add(this.mCurrentScope);
    }

    BackwardsWorklistItem(DisjunctiveAbstractState<STATE> disjunctiveAbstractState, ACTION ACTION, BackwardsWorklistItem<STATE, ACTION, VARDECL, LOC> backwardsWorklistItem) {
        this.mState = disjunctiveAbstractState;
        this.mAction = ACTION;
        this.mPredecessor = backwardsWorklistItem;
        this.mSummaryMap = backwardsWorklistItem.mSummaryMap;
        this.mScopes = new ArrayDeque<ScopeStackItem>(backwardsWorklistItem.mScopes);
        this.mCurrentScope = this.mScopes.peek();
    }

    @Override
    public ACTION getAction() {
        return this.mAction;
    }

    @Override
    public DisjunctiveAbstractState<STATE> getState() {
        return this.mState;
    }

    DisjunctiveAbstractState<STATE> getHierachicalState() {
        return this.mCurrentScope.getScopeHierState();
    }

    ACTION getCurrentScope() {
        return this.mCurrentScope.getAction();
    }

    private Map<LOC, Pair<Integer, DisjunctiveAbstractState<STATE>>> getLoopPairs() {
        return this.mCurrentScope.getLoopPairs();
    }

    void addScope(ACTION ACTION, DisjunctiveAbstractState<STATE> disjunctiveAbstractState) {
        assert (ACTION != null);
        ScopeStackItem scopeStackItem = new ScopeStackItem(ACTION, this.mState, disjunctiveAbstractState, this.getCurrentStorage().createStorage(ACTION));
        this.mScopes.addFirst(scopeStackItem);
        this.mCurrentScope = scopeStackItem;
    }

    ACTION removeCurrentScope(DisjunctiveAbstractState<STATE> disjunctiveAbstractState) {
        ScopeStackItem scopeStackItem = this.removeCurrentScopeWithoutSummary();
        if (scopeStackItem == null) {
            return null;
        }
        this.mSummaryMap.addSummary(scopeStackItem.getScopeOldState(), disjunctiveAbstractState, scopeStackItem.getAction());
        return scopeStackItem.getAction();
    }

    DisjunctiveAbstractState<STATE> getSummaryPostState(ACTION ACTION, DisjunctiveAbstractState<STATE> disjunctiveAbstractState) {
        return this.mSummaryMap.getSummaryPostState(ACTION, disjunctiveAbstractState);
    }

    private ScopeStackItem removeCurrentScopeWithoutSummary() {
        ScopeStackItem scopeStackItem = this.mScopes.removeFirst();
        this.mCurrentScope = this.mScopes.isEmpty() ? null : this.mScopes.peekFirst();
        return scopeStackItem;
    }

    IAbstractStateStorage<STATE, ACTION, LOC> getCurrentStorage() {
        return this.mCurrentScope.getStorage();
    }

    int getScopeStackDepth() {
        return this.mScopes.size();
    }

    Deque<Pair<ACTION, IAbstractStateStorage<STATE, ACTION, LOC>>> getScopeStack() {
        ArrayDeque<Pair<ACTION, IAbstractStateStorage<STATE, ACTION, LOC>>> arrayDeque = new ArrayDeque<Pair<ACTION, IAbstractStateStorage<STATE, ACTION, LOC>>>();
        Iterator<ScopeStackItem> iterator = this.mScopes.descendingIterator();
        while (iterator.hasNext()) {
            ScopeStackItem scopeStackItem = iterator.next();
            arrayDeque.add(new Pair(scopeStackItem.getAction(), scopeStackItem.getStorage()));
        }
        return arrayDeque;
    }

    Deque<Pair<ACTION, DisjunctiveAbstractState<STATE>>> getScopeWideningStack() {
        ArrayDeque<Pair<ACTION, DisjunctiveAbstractState<STATE>>> arrayDeque = new ArrayDeque<Pair<ACTION, DisjunctiveAbstractState<STATE>>>();
        Iterator<ScopeStackItem> iterator = this.mScopes.descendingIterator();
        while (iterator.hasNext()) {
            ScopeStackItem scopeStackItem = iterator.next();
            arrayDeque.add(new Pair(scopeStackItem.getAction(), scopeStackItem.getScopeOldState()));
        }
        return arrayDeque;
    }

    int enterLoop(LOC LOC) {
        DisjunctiveAbstractState<STATE> disjunctiveAbstractState = this.getState();
        Pair<Integer, DisjunctiveAbstractState<STATE>> pair = this.getLoopPairs().get(LOC);
        Pair pair2 = pair == null ? new Pair((Object)0, disjunctiveAbstractState) : new Pair((Object)((Integer)pair.getFirst() + 1), disjunctiveAbstractState);
        this.getLoopPairs().put(LOC, pair2);
        return (Integer)pair2.getFirst();
    }

    Pair<Integer, DisjunctiveAbstractState<STATE>> getLoopPair(LOC LOC) {
        return this.getLoopPairs().get(LOC);
    }

    public BackwardsWorklistItem<STATE, ACTION, VARDECL, LOC> getPredecessor() {
        return this.mPredecessor;
    }

    public String toString() {
        String string = this.mState == null ? "?" : String.valueOf(this.mState.hashCode());
        StringBuilder stringBuilder = new StringBuilder().append('[').append(string).append("]--[").append(this.mAction.hashCode()).append("]--> ? (Scope={");
        Iterator<ScopeStackItem> iterator = this.mScopes.descendingIterator();
        while (iterator.hasNext()) {
            Object ACTION = iterator.next().getAction();
            if (ACTION != null) {
                stringBuilder.append((CharSequence)LoggingHelper.getHashCodeString(ACTION));
                continue;
            }
            stringBuilder.append("[G]");
        }
        stringBuilder.append("})");
        return stringBuilder.toString();
    }

    String toExtendedString() {
        return this.toString() + " Pre: " + String.valueOf(LoggingHelper.getHashCodeString(this.mState)) + " " + Optional.ofNullable(this.mState).map(disjunctiveAbstractState -> disjunctiveAbstractState.toLogString()).orElse("?") + " HierPre: " + String.valueOf(LoggingHelper.getHashCodeString(this.getHierachicalState())) + " " + Optional.ofNullable(this.getHierachicalState()).map(disjunctiveAbstractState -> disjunctiveAbstractState.toLogString()).orElse("?");
    }

    private final class ScopeStackItem {
        private final ACTION mScope;
        private final DisjunctiveAbstractState<STATE> mScopeHierachicalPreState;
        private final DisjunctiveAbstractState<STATE> mScopeFirstState;
        private final IAbstractStateStorage<STATE, ACTION, LOC> mStorage;
        private final Map<LOC, Pair<Integer, DisjunctiveAbstractState<STATE>>> mLoopPairs;

        private ScopeStackItem(ACTION ACTION, DisjunctiveAbstractState<STATE> disjunctiveAbstractState, DisjunctiveAbstractState<STATE> disjunctiveAbstractState2, IAbstractStateStorage<STATE, ACTION, LOC> iAbstractStateStorage) {
            this.mScope = ACTION;
            this.mScopeHierachicalPreState = disjunctiveAbstractState;
            this.mScopeFirstState = disjunctiveAbstractState2;
            this.mStorage = iAbstractStateStorage;
            this.mLoopPairs = new HashMap();
        }

        private ScopeStackItem(IAbstractStateStorage<STATE, ACTION, LOC> iAbstractStateStorage, DisjunctiveAbstractState<STATE> disjunctiveAbstractState) {
            this(null, disjunctiveAbstractState, disjunctiveAbstractState, iAbstractStateStorage);
        }

        ACTION getAction() {
            return this.mScope;
        }

        DisjunctiveAbstractState<STATE> getScopeHierState() {
            return this.mScopeHierachicalPreState;
        }

        DisjunctiveAbstractState<STATE> getScopeOldState() {
            return this.mScopeFirstState;
        }

        IAbstractStateStorage<STATE, ACTION, LOC> getStorage() {
            return this.mStorage;
        }

        Map<LOC, Pair<Integer, DisjunctiveAbstractState<STATE>>> getLoopPairs() {
            return this.mLoopPairs;
        }
    }
}

