/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.nonrelational.termevaluator;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.nonrelational.termevaluator.ITermEvaluator;
import java.util.ArrayDeque;
import java.util.Deque;

public class TermExpressionEvaluator<VALUE, STATE extends IAbstractState<STATE>> {
    private final Deque<ITermEvaluator<VALUE, STATE>> mEvaluators = new ArrayDeque<ITermEvaluator<VALUE, STATE>>();
    private ITermEvaluator<VALUE, STATE> mRootEvaluator = null;

    public void addEvaluator(ITermEvaluator<VALUE, STATE> iTermEvaluator) {
        if (this.mEvaluators.isEmpty()) {
            if (this.mRootEvaluator != null) {
                throw new IllegalStateException("The root evaluator is not empty. Cannot add new root evaluator.");
            }
            this.mEvaluators.push(iTermEvaluator);
            this.mRootEvaluator = iTermEvaluator;
        } else if (this.mEvaluators.peek().hasFreeOperands()) {
            this.mEvaluators.peek().addSubEvaluator(iTermEvaluator);
            if (iTermEvaluator.hasFreeOperands()) {
                this.mEvaluators.push(iTermEvaluator);
            }
        }
        while (!this.mEvaluators.isEmpty()) {
            if (this.mEvaluators.peek().hasFreeOperands()) break;
            this.mEvaluators.pop();
        }
    }

    public ITermEvaluator<VALUE, STATE> getRootEvaluator() {
        return this.mRootEvaluator;
    }

    public boolean isEmpty() {
        return this.mEvaluators.isEmpty();
    }

    public boolean isFinished() {
        return this.isEmpty() && this.mRootEvaluator != null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.mRootEvaluator);
        if (!this.mEvaluators.isEmpty()) {
            stringBuilder.append(", Stack: ").append(this.mEvaluators);
        }
        return stringBuilder.toString();
    }
}

