/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.vp;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqConstraintFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqDisjunctiveConstraint;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqNode;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqNodeAndFunctionFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramFunction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.TermVarsFuns;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SubTermFinder;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public class EqPredicate
implements IPredicate {
    private final EqDisjunctiveConstraint<EqNode> mConstraint;
    private final ImmutableSet<IProgramVar> mVars;
    private final ImmutableSet<IProgramFunction> mFuns;
    private final Term mClosedFormula;
    private final Term mFormula;
    private EqNodeAndFunctionFactory mEqNodeAndFunctionFactory;

    public EqPredicate(EqDisjunctiveConstraint<EqNode> eqDisjunctiveConstraint, ImmutableSet<IProgramVar> immutableSet, IIcfgSymbolTable iIcfgSymbolTable, ManagedScript managedScript, EqNodeAndFunctionFactory eqNodeAndFunctionFactory) {
        assert (immutableSet != null);
        assert (immutableSet.stream().allMatch(Objects::nonNull));
        this.mConstraint = eqDisjunctiveConstraint;
        this.mVars = immutableSet;
        Term term = eqDisjunctiveConstraint.getTerm(managedScript.getScript());
        TermVarsFuns termVarsFuns = TermVarsFuns.computeTermVarsFuns((Term)term, (ManagedScript)managedScript, (IIcfgSymbolTable)iIcfgSymbolTable);
        this.mFuns = ImmutableSet.copyOf((Collection)termVarsFuns.getFuns());
        Term term2 = this.mConstraint.getFactory().getWeqCcManager().getNonTheoryLiteralDisequalitiesIfNecessary();
        this.mClosedFormula = SmtUtils.and((Script)managedScript.getScript(), (Term[])new Term[]{term2, termVarsFuns.getClosedFormula()});
        this.mFormula = SmtUtils.and((Script)managedScript.getScript(), (Term[])new Term[]{term2, termVarsFuns.getFormula()});
    }

    public EqPredicate(Term term, ImmutableSet<IProgramVar> immutableSet, ImmutableSet<IProgramFunction> immutableSet2, IIcfgSymbolTable iIcfgSymbolTable, ManagedScript managedScript, EqNodeAndFunctionFactory eqNodeAndFunctionFactory, EqConstraintFactory<EqNode> eqConstraintFactory) {
        this.mConstraint = null;
        assert (immutableSet.stream().allMatch(Objects::nonNull));
        this.mVars = immutableSet;
        this.mFuns = immutableSet2;
        this.mEqNodeAndFunctionFactory = eqNodeAndFunctionFactory;
        Term term2 = term;
        TermVarsFuns termVarsFuns = TermVarsFuns.computeTermVarsFuns((Term)term2, (ManagedScript)managedScript, (IIcfgSymbolTable)iIcfgSymbolTable);
        Term term3 = eqConstraintFactory.getWeqCcManager().getNonTheoryLiteralDisequalitiesIfNecessary();
        this.mClosedFormula = SmtUtils.and((Script)managedScript.getScript(), (Term[])new Term[]{term3, termVarsFuns.getClosedFormula()});
        this.mFormula = SmtUtils.and((Script)managedScript.getScript(), (Term[])new Term[]{term3, termVarsFuns.getFormula()});
    }

    private Set<Term> collectLiteralsInFormula(Term term2) {
        Predicate<Term> predicate = term -> term instanceof ConstantTerm || this.mEqNodeAndFunctionFactory.getNonTheoryLiterals().contains(term);
        return SubTermFinder.find((Term)term2, predicate, (boolean)false);
    }

    public ImmutableSet<IProgramVar> getVars() {
        return this.mVars;
    }

    public ImmutableSet<IProgramFunction> getFuns() {
        return this.mFuns;
    }

    public EqDisjunctiveConstraint<EqNode> getEqConstraint() {
        assert (this.mConstraint != null);
        return this.mConstraint;
    }

    public String toString() {
        if (this.mConstraint != null) {
            return this.mConstraint.toString();
        }
        return this.mFormula.toString();
    }

    public String toLogString() {
        if (this.mConstraint != null) {
            return this.mConstraint.toLogString();
        }
        return this.mFormula.toString();
    }

    public Term getFormula() {
        return this.mFormula;
    }

    public Term getClosedFormula() {
        return this.mClosedFormula;
    }

    public int hashCode() {
        return Objects.hash(this.mConstraint);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EqPredicate eqPredicate = (EqPredicate)object;
        return !(this.mConstraint == null ? eqPredicate.mConstraint != null : !this.mConstraint.equals(eqPredicate.mConstraint));
    }
}

