/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.rcfg;

import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.annotations.IAnnotationProvider;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.annotations.ReachDefStatementAnnotation;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.util.Util;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlock;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.SequentialComposition;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.StatementSequence;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.util.RCFGEdgeVisitor;
import java.util.ArrayList;
import java.util.List;

public class ReachDefRCFGPredecessorGenerator
extends RCFGEdgeVisitor {
    private final ILogger mLogger;
    private final IAnnotationProvider<ReachDefStatementAnnotation> mProvider;
    private List<ReachDefStatementAnnotation> rtr;

    public ReachDefRCFGPredecessorGenerator(IAnnotationProvider<ReachDefStatementAnnotation> iAnnotationProvider, ILogger iLogger) {
        this.mLogger = iLogger;
        this.mProvider = iAnnotationProvider;
    }

    public List<ReachDefStatementAnnotation> process(IcfgLocation icfgLocation) {
        this.rtr = new ArrayList<ReachDefStatementAnnotation>();
        if (icfgLocation == null) {
            return this.rtr;
        }
        for (IcfgEdge icfgEdge : icfgLocation.getIncomingEdges()) {
            this.visit(icfgEdge);
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Predecessors: " + Util.prettyPrintIterable(icfgLocation.getIncomingEdges(), Util.createHashCodePrinter())));
        }
        return this.rtr;
    }

    protected void visit(SequentialComposition sequentialComposition) {
        List list = sequentialComposition.getCodeBlocks();
        if (list == null || list.isEmpty()) {
            return;
        }
        super.visit((CodeBlock)list.get(list.size() - 1));
    }

    protected void visit(StatementSequence statementSequence) {
        ReachDefStatementAnnotation reachDefStatementAnnotation = this.mProvider.getAnnotation((IElement)statementSequence.getStatements().get(statementSequence.getStatements().size() - 1));
        if (reachDefStatementAnnotation != null) {
            this.rtr.add(reachDefStatementAnnotation);
        }
        super.visit(statementSequence);
    }
}

