/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.procedureinliner;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Body;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Specification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Unit;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.Activator;
import de.uni_freiburg.informatik.ultimate.core.lib.results.SyntaxErrorResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.UnsupportedSyntaxResult;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BoogieProcedureFilter {
    private final IUltimateServiceProvider mServices;
    private Map<String, Procedure> mDeclarations;
    private Map<String, Procedure> mImplementations;
    private Set<Declaration> mNonProcedureDeclarations;

    public BoogieProcedureFilter(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
    }

    public BoogieProcedureFilter(IUltimateServiceProvider iUltimateServiceProvider, Unit unit) {
        this(iUltimateServiceProvider);
        this.filter(unit);
    }

    public void filter(Unit unit) {
        this.mDeclarations = new HashMap<String, Procedure>();
        this.mImplementations = new HashMap<String, Procedure>();
        this.mNonProcedureDeclarations = new HashSet<Declaration>();
        Declaration[] declarationArray = unit.getDeclarations();
        int n = declarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Declaration declaration = declarationArray[n2];
            if (declaration instanceof Procedure) {
                this.filterProcedure((Procedure)declaration);
            } else {
                this.mNonProcedureDeclarations.add(declaration);
            }
            ++n2;
        }
        this.finishFilteredResults();
        this.checkForMissingDeclarations();
    }

    public Map<String, Procedure> getDeclarations() {
        return this.mDeclarations;
    }

    public Map<String, Procedure> getImplementations() {
        return this.mImplementations;
    }

    public Set<Declaration> getNonProcedureDeclarations() {
        return this.mNonProcedureDeclarations;
    }

    private void filterProcedure(Procedure procedure) {
        Specification[] specificationArray = procedure.getSpecification();
        Body body = procedure.getBody();
        if (specificationArray != null) {
            this.addDeclaration(procedure);
        }
        if (body != null) {
            this.addImplementation(procedure);
        }
    }

    private void addDeclaration(Procedure procedure) {
        assert (procedure.getSpecification() != null);
        Procedure procedure2 = this.mDeclarations.put(procedure.getIdentifier(), procedure);
        if (procedure2 != null) {
            this.multiDeclarationsError(procedure);
        }
    }

    private void addImplementation(Procedure procedure) {
        assert (procedure.getBody() != null);
        Procedure procedure2 = this.mImplementations.put(procedure.getIdentifier(), procedure);
        if (procedure2 != null) {
            this.multiImplementationsError(procedure);
        }
    }

    private void finishFilteredResults() {
        this.mDeclarations = Collections.unmodifiableMap(this.mDeclarations);
        this.mImplementations = Collections.unmodifiableMap(this.mImplementations);
        this.mNonProcedureDeclarations = Collections.unmodifiableSet(this.mNonProcedureDeclarations);
    }

    private void checkForMissingDeclarations() {
        for (String string : this.mImplementations.keySet()) {
            if (this.mDeclarations.containsKey(string)) continue;
            Procedure procedure = this.mImplementations.get(string);
            this.missingDeclarationError(procedure);
        }
    }

    private void multiDeclarationsError(Procedure procedure) {
        String string = "Procedure was already declared: " + procedure.getIdentifier();
        this.syntaxError(procedure.getLocation(), string);
    }

    private void multiImplementationsError(Procedure procedure) {
        String string = "Multiple procedure implementations aren't supported: " + procedure.getIdentifier();
        this.unsupportedSyntaxError(procedure.getLocation(), string);
    }

    private void missingDeclarationError(Procedure procedure) {
        String string = "Missing declaration for procedure implementation: " + procedure.getIdentifier();
        this.syntaxError(procedure.getLocation(), string);
    }

    private void syntaxError(ILocation iLocation, String string) {
        this.errorAndAbort(iLocation, string, (IResult)new SyntaxErrorResult(Activator.PLUGIN_ID, iLocation, string));
    }

    private void unsupportedSyntaxError(ILocation iLocation, String string) {
        this.errorAndAbort(iLocation, string, (IResult)new UnsupportedSyntaxResult(Activator.PLUGIN_ID, iLocation, string));
    }

    private void errorAndAbort(ILocation iLocation, String string, IResult iResult) {
        String string2 = Activator.PLUGIN_ID;
        this.mServices.getLoggingService().getLogger(string2).error((Object)(String.valueOf(iLocation) + ": " + string));
        this.mServices.getResultService().reportResult(string2, iResult);
        this.mServices.getProgressMonitorService().cancelToolchain();
    }
}

