/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.backtranslation;

import de.uni_freiburg.informatik.ultimate.boogie.BoogieProgramExecution;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.output.BoogiePrettyPrinter;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.Activator;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.BackTransValue;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.InlineVersionTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.backtranslation.CallReinserter;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.backtranslation.ExpressionBacktranslation;
import de.uni_freiburg.informatik.ultimate.core.lib.results.GenericResult;
import de.uni_freiburg.informatik.ultimate.core.lib.translation.DefaultTranslator;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.results.IRelevanceInformation;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResultWithSeverity;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.AtomicTraceElement;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IToString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class InlinerBacktranslator
extends DefaultTranslator<BoogieASTNode, BoogieASTNode, Expression, Expression, String, String, ILocation> {
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final Map<BoogieASTNode, BackTransValue> mBackTransMap = new HashMap<BoogieASTNode, BackTransValue>();
    private final ExpressionBacktranslation mExprBackTrans = new ExpressionBacktranslation();

    public InlinerBacktranslator(IUltimateServiceProvider iUltimateServiceProvider) {
        super(BoogieASTNode.class, BoogieASTNode.class, Expression.class, Expression.class);
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
    }

    public void addBacktranslation(InlineVersionTransformer inlineVersionTransformer) {
        this.mBackTransMap.putAll(inlineVersionTransformer.getBacktranslationMap());
        this.mExprBackTrans.reverseAndAddMapping(inlineVersionTransformer.getVariableMap());
    }

    public Collection<Expression> translateExpressions(Collection<Expression> collection) {
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        for (Expression expression : collection) {
            arrayList.add(this.translateExpression(expression));
        }
        return arrayList;
    }

    public Expression translateExpression(Expression expression) {
        return this.mExprBackTrans.processExpression(expression);
    }

    public List<BoogieASTNode> translateTrace(List<BoogieASTNode> list) {
        HashSet<Object> hashSet = new HashSet<Object>();
        ArrayList<BoogieASTNode> arrayList = new ArrayList<BoogieASTNode>();
        CallReinserter callReinserter = new CallReinserter();
        IToString iToString = BoogiePrettyPrinter.getBoogieToStringProvider();
        for (BoogieASTNode boogieASTNode : list) {
            Object object;
            AtomicTraceElement.AtomicTraceElementBuilder atomicTraceElementBuilder = new AtomicTraceElement.AtomicTraceElementBuilder();
            atomicTraceElementBuilder.setStepAndElement((Object)boogieASTNode).setToStringFunc(iToString);
            if (boogieASTNode instanceof CallStatement) {
                object = (CallStatement)boogieASTNode;
                if (hashSet.contains(object)) {
                    this.reportUnfinishedBacktranslation("Cannot reconstruct StepInfo (either call or return): " + String.valueOf(object));
                }
                hashSet.add(object);
                atomicTraceElementBuilder.setStepInfo(new AtomicTraceElement.StepInfo[]{AtomicTraceElement.StepInfo.PROC_CALL}).setProcedures(null, ((CallStatement)boogieASTNode).getMethodName());
            }
            object = this.mBackTransMap.get(boogieASTNode);
            List<AtomicTraceElement<BoogieASTNode>> list2 = callReinserter.recoverInlinedCallsBefore((AtomicTraceElement<BoogieASTNode>)atomicTraceElementBuilder.build(), (BackTransValue)object, null);
            for (AtomicTraceElement<BoogieASTNode> atomicTraceElement : list2) {
                arrayList.add((BoogieASTNode)atomicTraceElement.getTraceElement());
            }
            if (object == null) {
                arrayList.add(boogieASTNode);
                continue;
            }
            BoogieASTNode boogieASTNode2 = ((BackTransValue)object).getOriginalNode();
            if (boogieASTNode2 == null) continue;
            arrayList.add(boogieASTNode2);
        }
        return arrayList;
    }

    public IProgramExecution<BoogieASTNode, Expression> translateProgramExecution(IProgramExecution<BoogieASTNode, Expression> iProgramExecution) {
        assert (this.checkCallStackSourceProgramExecution(this.mLogger, iProgramExecution)) : "callstack of program execution already broken at beginning of " + ((Object)((Object)this)).getClass().getSimpleName();
        CallReinserter callReinserter = new CallReinserter();
        BoogieProgramExecution boogieProgramExecution = this.translateProgramExecution(callReinserter, iProgramExecution);
        assert (this.checkCallStackTargetProgramExecution(this.mLogger, (IProgramExecution)boogieProgramExecution)) : "callstack broken after backtranslation by " + ((Object)((Object)this)).getClass().getSimpleName();
        return boogieProgramExecution;
    }

    public IBacktranslationService.Lasso<IProgramExecution<BoogieASTNode, Expression>> translateLassoProgramExecution(IBacktranslationService.Lasso<IProgramExecution<BoogieASTNode, Expression>> lasso) {
        assert (this.checkCallStackSourceLassoProgramExecution(this.mLogger, lasso)) : "callstack of program execution already broken at beginning of " + ((Object)((Object)this)).getClass().getSimpleName();
        CallReinserter callReinserter = new CallReinserter();
        BoogieProgramExecution boogieProgramExecution = this.translateProgramExecution(callReinserter, (IProgramExecution<BoogieASTNode, Expression>)lasso.stem());
        BoogieProgramExecution boogieProgramExecution2 = this.translateProgramExecution(callReinserter, (IProgramExecution<BoogieASTNode, Expression>)lasso.loop());
        IBacktranslationService.Lasso lasso2 = new IBacktranslationService.Lasso((IProgramExecution)boogieProgramExecution, (IProgramExecution)boogieProgramExecution2);
        assert (this.checkCallStackTargetLassoProgramExecution(this.mLogger, lasso2)) : "callstack broken after backtranslation by " + ((Object)((Object)this)).getClass().getSimpleName();
        return lasso2;
    }

    /*
     * Unable to fully structure code
     */
    private BoogieProgramExecution translateProgramExecution(CallReinserter var1_1, IProgramExecution<BoogieASTNode, Expression> var2_2) {
        var3_3 = var2_2.getLength();
        var4_4 = new HashMap<Integer, IProgramExecution.ProgramState>();
        var5_5 = new ArrayList<Object>();
        var6_6 = null;
        var7_7 = 0;
        while (var7_7 < var3_3) {
            block5: {
                var8_8 = var2_2.getTraceElement(var7_7);
                var9_9 = this.mBackTransMap.get(var8_8.getTraceElement());
                var5_5.addAll(var1_1.recoverInlinedCallsBefore((AtomicTraceElement<BoogieASTNode>)var8_8, var9_9, var6_6));
                if (var9_9 != null) break block5;
                var5_5.add(var8_8);
                ** GOTO lbl25
            }
            var10_10 = var9_9.getOriginalNode();
            if (var10_10 == null) {
                var6_6 = var6_6 == null ? var8_8.getRelevanceInformation() : var6_6.merge(new IRelevanceInformation[]{var8_8.getRelevanceInformation()});
            } else {
                var6_6 = null;
                var11_11 = this.mBackTransMap.get(var8_8.getStep());
                var12_12 = var11_11 == null || var11_11.getOriginalNode() == null ? var10_10 : var11_11.getOriginalNode();
                var5_5.add(InlinerBacktranslator.createAtomicTraceElement((AtomicTraceElement<BoogieASTNode>)var8_8, var10_10, (BoogieASTNode)var12_12));
lbl25:
                // 2 sources

                var10_10 = var2_2.getProgramState(var7_7);
                if (var10_10 != null) {
                    var11_11 = var9_9 != null ? InlinerBacktranslator.computeCurrectProc(var9_9) : var8_8.getSucceedingProcedure();
                    var12_12 = new HashMap<K, V>();
                    for (Expression var13_13 : var10_10.getVariables()) {
                        this.mExprBackTrans.setInlinedActiveProcedures(Collections.singleton(var11_11));
                        var15_15 = this.mExprBackTrans.processExpression(var13_13);
                        if (!this.mExprBackTrans.processedExprWasActive()) continue;
                        var12_12.put(var15_15, this.translateExpressions(var10_10.getValues((Object)var13_13)));
                    }
                    var4_4.put(var5_5.size() - 1, new IProgramExecution.ProgramState((Map)var12_12, Expression.class));
                }
            }
            ++var7_7;
        }
        return new BoogieProgramExecution(var4_4, var5_5, var2_2.isConcurrent());
    }

    private static String computeCurrectProc(BackTransValue backTransValue) {
        if (backTransValue.getOriginalCallStack().isEmpty()) {
            return backTransValue.getInlineEntryProcId();
        }
        return backTransValue.getOriginalCallStack().peekFirst().getMethodName();
    }

    private static AtomicTraceElement<BoogieASTNode> createAtomicTraceElement(AtomicTraceElement<BoogieASTNode> atomicTraceElement, BoogieASTNode boogieASTNode, BoogieASTNode boogieASTNode2) {
        AtomicTraceElement.AtomicTraceElementBuilder atomicTraceElementBuilder = new AtomicTraceElement.AtomicTraceElementBuilder();
        if (atomicTraceElement.hasThreadId()) {
            atomicTraceElementBuilder.setThreadId(atomicTraceElement.getThreadId());
        }
        if (atomicTraceElement.hasStepInfo(AtomicTraceElement.StepInfo.FORK)) {
            atomicTraceElementBuilder.setForkedThreadId(atomicTraceElement.getForkedThreadId());
        }
        if (atomicTraceElement.hasStepInfo(AtomicTraceElement.StepInfo.JOIN)) {
            atomicTraceElementBuilder.setJoinedThreadId(atomicTraceElement.getJoinedThreadId());
        }
        atomicTraceElementBuilder.setToStringFunc(BoogiePrettyPrinter.getBoogieToStringProvider());
        atomicTraceElementBuilder.setElement((Object)boogieASTNode);
        atomicTraceElementBuilder.setStep((Object)boogieASTNode2);
        atomicTraceElementBuilder.setStepInfo(atomicTraceElement.getStepInfo());
        atomicTraceElementBuilder.setRelevanceInformation(atomicTraceElement.getRelevanceInformation());
        atomicTraceElementBuilder.setProcedures(atomicTraceElement.getPrecedingProcedure(), atomicTraceElement.getSucceedingProcedure());
        return atomicTraceElementBuilder.build();
    }

    public String targetExpressionToString(Expression expression) {
        return BoogiePrettyPrinter.print((Expression)expression);
    }

    public List<String> targetTraceToString(List<BoogieASTNode> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (BoogieASTNode boogieASTNode : list) {
            if (boogieASTNode instanceof Statement) {
                arrayList.add(BoogiePrettyPrinter.print((Statement)((Statement)boogieASTNode)));
                continue;
            }
            return super.targetTraceToString(list);
        }
        return arrayList;
    }

    private void reportUnfinishedBacktranslation(String string) {
        this.mLogger.warn((Object)string);
        this.mServices.getResultService().reportResult(Activator.PLUGIN_ID, (IResult)new GenericResult(Activator.PLUGIN_ID, "Unfinished Backtranslation", string, IResultWithSeverity.Severity.WARNING));
    }
}

