/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.model.services;

public interface ILogger {
    default public boolean isFatalEnabled() {
        return this.isLogLevelEnabled(LogLevel.FATAL);
    }

    public void fatal(Object var1, Throwable var2);

    default public void fatal(Object object) {
        this.log(LogLevel.FATAL, object);
    }

    default public void fatal(String string, Object ... objectArray) {
        this.log(LogLevel.FATAL, string, objectArray);
    }

    default public boolean isErrorEnabled() {
        return this.isLogLevelEnabled(LogLevel.ERROR);
    }

    public void error(Object var1, Throwable var2);

    default public void error(Object object) {
        this.log(LogLevel.ERROR, object);
    }

    default public void error(String string, Object ... objectArray) {
        this.log(LogLevel.ERROR, string, objectArray);
    }

    default public boolean isWarnEnabled() {
        return this.isLogLevelEnabled(LogLevel.WARN);
    }

    default public void warn(Object object) {
        this.log(LogLevel.WARN, object);
    }

    default public void warn(String string, Object ... objectArray) {
        this.log(LogLevel.WARN, string, objectArray);
    }

    default public boolean isInfoEnabled() {
        return this.isLogLevelEnabled(LogLevel.INFO);
    }

    default public void info(Object object) {
        this.log(LogLevel.INFO, object);
    }

    default public void info(String string, Object ... objectArray) {
        this.log(LogLevel.INFO, string, objectArray);
    }

    default public boolean isDebugEnabled() {
        return this.isLogLevelEnabled(LogLevel.DEBUG);
    }

    default public void debug(Object object) {
        this.log(LogLevel.DEBUG, object);
    }

    default public void debug(String string, Object ... objectArray) {
        this.log(LogLevel.DEBUG, string, objectArray);
    }

    public boolean isLogLevelEnabled(LogLevel var1);

    public void log(LogLevel var1, String var2);

    default public void log(LogLevel logLevel, Object object) {
        if (this.isLogLevelEnabled(logLevel)) {
            this.log(logLevel, object.toString());
        }
    }

    default public void log(LogLevel logLevel, String string, Object ... objectArray) {
        if (this.isLogLevelEnabled(logLevel)) {
            this.log(logLevel, String.format(string, objectArray));
        }
    }

    public void setLevel(LogLevel var1);

    public static ILogger getLogger(String string) {
        throw new UnsupportedOperationException("You should never use the static logger method getLogger(String)! " + string);
    }

    public static ILogger getDummyLogger() {
        return new ILogger(){

            @Override
            public void setLevel(LogLevel logLevel) {
            }

            @Override
            public void log(LogLevel logLevel, String string) {
            }

            @Override
            public boolean isLogLevelEnabled(LogLevel logLevel) {
                return false;
            }

            @Override
            public void fatal(Object object, Throwable throwable) {
            }

            @Override
            public void error(Object object, Throwable throwable) {
            }
        };
    }

    public static enum LogLevel {
        DEBUG,
        INFO,
        WARN,
        ERROR,
        FATAL,
        OFF;

    }
}

