/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.NonTheorySymbolFinder;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Objects;
import java.util.Set;

public abstract class NonTheorySymbol<SYMBOL> {
    private final SYMBOL mSymbol;

    private NonTheorySymbol(SYMBOL SYMBOL) {
        this.mSymbol = SYMBOL;
    }

    public SYMBOL getSymbol() {
        return this.mSymbol;
    }

    public final int hashCode() {
        return Objects.hash(this.mSymbol);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        NonTheorySymbol nonTheorySymbol = (NonTheorySymbol)object;
        return !(this.mSymbol == null ? nonTheorySymbol.mSymbol != null : !this.mSymbol.equals(nonTheorySymbol.mSymbol));
    }

    public final String toString() {
        return this.mSymbol.toString();
    }

    public static Set<NonTheorySymbol<?>> extractNonTheorySymbols(Term term) {
        return new NonTheorySymbolFinder().findNonTheorySymbols(term);
    }

    public static class Constant
    extends NonTheorySymbol<ApplicationTerm> {
        public Constant(ApplicationTerm applicationTerm) {
            super(applicationTerm);
            if (applicationTerm.getParameters().length > 0) {
                throw new IllegalArgumentException("this is no constant");
            }
            if (applicationTerm.getFunction().isIntern()) {
                throw new IllegalArgumentException("this is not a non-theory symbol");
            }
        }
    }

    public static class Function
    extends NonTheorySymbol<FunctionSymbol> {
        public Function(FunctionSymbol functionSymbol) {
            super(functionSymbol);
            if (functionSymbol.isIntern()) {
                throw new IllegalArgumentException("this is not a non-theory symbol");
            }
        }
    }

    public static class Variable
    extends NonTheorySymbol<TermVariable> {
        public Variable(TermVariable termVariable) {
            super(termVariable);
        }
    }
}

