/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ModTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelectOverNestedStore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.SolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialRelation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public final class SimplificationUtils {
    private SimplificationUtils() {
    }

    public static Term applyConstantFolding(ManagedScript managedScript, Term term, Term term2) {
        HashMap<Term, Term> hashMap = new HashMap<Term, Term>();
        Term[] termArray = SmtUtils.getConjuncts(term);
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            SolvedBinaryRelation solvedBinaryRelation;
            PolynomialRelation polynomialRelation;
            Term term3 = termArray[n2];
            if (SmtUtils.isFunctionApplication(term3, "=") && (polynomialRelation = PolynomialRelation.of(managedScript.getScript(), term3)) != null && (solvedBinaryRelation = polynomialRelation.isSimpleEquality(managedScript.getScript())) != null) {
                hashMap.put(solvedBinaryRelation.getLeftHandSide(), solvedBinaryRelation.getRightHandSide());
            }
            ++n2;
        }
        if (hashMap.isEmpty()) {
            return term2;
        }
        return Substitution.apply(managedScript, hashMap, term2);
    }

    public static Term tryModSimplification(ManagedScript managedScript, ValidityCheck validityCheck, Term term) {
        Set<ApplicationTerm> set = SmtUtils.extractApplicationTerms("mod", term, true);
        if (set.isEmpty()) {
            return term;
        }
        HashMap<Term, Term> hashMap = new HashMap<Term, Term>();
        for (Term term2 : set) {
            ModTerm modTerm = ModTerm.of(term2);
            Term term3 = modTerm.getDivident();
            Term term4 = modTerm.getDivident();
            Term term5 = SimplificationUtils.tryModSimplification(managedScript, validityCheck, term4);
            if (term5 != term4) {
                modTerm = new ModTerm(term5, modTerm.getDivisor());
            }
            term4 = SmtUtils.geq(managedScript.getScript(), modTerm.getDivident(), SmtUtils.constructIntegerValue(managedScript.getScript(), SmtSortUtils.getIntSort(managedScript), BigInteger.ZERO));
            term5 = SmtUtils.less(managedScript.getScript(), modTerm.getDivident(), modTerm.getDivisor());
            Script.LBool lBool = validityCheck.isValid(term4, term5);
            if (lBool == Script.LBool.UNSAT) {
                hashMap.put(term2, modTerm.getDivident());
                continue;
            }
            if (term3 == modTerm.getDivident()) continue;
            hashMap.put(term3, modTerm.getDivident());
        }
        if (hashMap.isEmpty()) {
            return term;
        }
        return Substitution.apply(managedScript, hashMap, term);
    }

    public static Term tryArraySimplification(ManagedScript managedScript, ValidityCheck validityCheck, Term term) {
        List<MultiDimensionalSelectOverNestedStore> list = MultiDimensionalSelectOverNestedStore.extractMultiDimensionalSelectOverNestedStore(term, true);
        if (list.isEmpty()) {
            return term;
        }
        HashMap<Term, Term> hashMap = new HashMap<Term, Term>();
        for (MultiDimensionalSelectOverNestedStore multiDimensionalSelectOverNestedStore : list) {
            if (multiDimensionalSelectOverNestedStore.getNestedStore().getValues().size() != 1) continue;
            ArrayIndex arrayIndex = multiDimensionalSelectOverNestedStore.getNestedStore().getIndices().get(0);
            ArrayIndex arrayIndex2 = multiDimensionalSelectOverNestedStore.getSelectIndex();
            Term term2 = ArrayIndex.constructIndexEquality(managedScript.getScript(), arrayIndex, arrayIndex2);
            Script.LBool lBool = validityCheck.isValid(term2);
            if (lBool == Script.LBool.UNSAT) {
                hashMap.put(multiDimensionalSelectOverNestedStore.toTerm(managedScript.getScript()), multiDimensionalSelectOverNestedStore.getNestedStore().getValues().get(0));
                continue;
            }
            Script.LBool lBool2 = validityCheck.isValid(SmtUtils.not(managedScript.getScript(), term2));
            if (lBool2 != Script.LBool.UNSAT) continue;
            MultiDimensionalSelect multiDimensionalSelect = new MultiDimensionalSelect(multiDimensionalSelectOverNestedStore.getNestedStore().getArray(), multiDimensionalSelectOverNestedStore.getSelectIndex());
            hashMap.put(multiDimensionalSelectOverNestedStore.toTerm(managedScript.getScript()), multiDimensionalSelect.toTerm(managedScript.getScript()));
        }
        if (hashMap.isEmpty()) {
            return term;
        }
        return Substitution.apply(managedScript, hashMap, term);
    }

    @FunctionalInterface
    public static interface ValidityCheck {
        public Script.LBool isValid(Term ... var1);
    }
}

