/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AbstractAssumption;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.math.BigInteger;
import java.util.LinkedList;

public class DivisibleByAssumption
extends AbstractAssumption {
    private final LinkedList<Term> mModTerms;

    public DivisibleByAssumption(Script script, Term term, Term term2) {
        super(script, term.getSort(), DivisibleByAssumption::equalZero);
        this.mModTerms = new LinkedList();
        this.mModTerms.add(SmtUtils.mod(script, term, term2));
    }

    public DivisibleByAssumption(Script script, Sort sort, DivisibleByAssumption ... divisibleByAssumptionArray) {
        super(script, sort, DivisibleByAssumption::equalZero);
        assert (divisibleByAssumptionArray.length > 1) : "This constructor only makes sense for 2 or more assumptions";
        this.mModTerms = divisibleByAssumptionArray[0].getModTerms();
        int n = 1;
        while (n < divisibleByAssumptionArray.length) {
            this.mModTerms.addAll(divisibleByAssumptionArray[n].getModTerms());
            ++n;
        }
    }

    private static Term equalZero(Script script, Sort sort, Term term) {
        if (SmtSortUtils.isIntSort(sort)) {
            return DivisibleByAssumption.equalZeroInt(script, sort, term);
        }
        throw new UnsupportedOperationException("This method is not implemented for this sort.");
    }

    private static Term equalZeroInt(Script script, Sort sort, Term term) {
        return SmtUtils.binaryEquality(script, term, SmtUtils.constructIntValue(script, BigInteger.ZERO));
    }

    @Override
    public boolean hasContractedForm() {
        return false;
    }

    @Override
    protected Term[] getConjunctsForExplicitForm() {
        Term[] termArray = new Term[this.mModTerms.size()];
        int n = 0;
        for (Term term : this.mModTerms) {
            termArray[n] = (Term)this.mRhsAppender.apply(this.mScript, this.mSort, term);
            ++n;
        }
        return termArray;
    }

    @Override
    protected Term constructContractedLhs() {
        return this.toExplicitTerm();
    }

    private LinkedList<Term> getModTerms() {
        return this.mModTerms;
    }
}

