/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.arrays;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

final class IntArray
implements Iterable<Integer> {
    private int[] mArray = new int[0];
    private int mSize = 0;
    private int mCapacity = 0;

    IntArray() {
    }

    int get(int n) {
        if (n < 0 || n >= this.mSize) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.mArray[n];
    }

    void set(int n, int n2) {
        if (n < 0 || n >= this.mSize) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.mArray[n] = n2;
    }

    void add(int n) {
        if (this.mSize == this.mCapacity) {
            int n2 = this.mCapacity == 0 ? 4 : 2 * this.mCapacity;
            this.mArray = Arrays.copyOf(this.mArray, n2);
            this.mCapacity = n2;
        }
        this.mArray[this.mSize] = n;
        ++this.mSize;
    }

    void clear() {
        this.mArray = new int[0];
        this.mSize = 0;
        this.mCapacity = 0;
    }

    int size() {
        return this.mSize;
    }

    public boolean equals(Object object) {
        block2: {
            block3: {
                if (object == this) break block2;
                if (!(object instanceof IntArray)) break block3;
                IntArray intArray = (IntArray)object;
                if (Arrays.equals(this.mArray, intArray.mArray)) break block2;
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        throw new UnsupportedOperationException("hashCode() not implemented");
    }

    @Override
    public Iterator<Integer> iterator() {
        return new IntArrayIterator(this.mArray, 0, this.mSize);
    }

    private static final class IntArrayIterator
    implements Iterator<Integer> {
        private final int[] mInnerArray;
        private final int mLast;
        private int mIdx;

        IntArrayIterator(int[] nArray, int n, int n2) {
            assert (n >= 0 && n <= n2 && n2 <= nArray.length);
            this.mInnerArray = nArray;
            this.mLast = n2;
            this.mIdx = n;
        }

        @Override
        public boolean hasNext() {
            return this.mIdx < this.mLast;
        }

        @Override
        public Integer next() {
            if (this.mIdx >= this.mLast) {
                throw new NoSuchElementException();
            }
            int n = this.mInnerArray[this.mIdx];
            ++this.mIdx;
            return n;
        }
    }
}

