/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.inclusion;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.inclusion.AbstractGeneralizedAutomatonReachableStates;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.inclusion.StateContainer;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingInternalTransition;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import java.util.HashSet;
import java.util.LinkedList;

public class RemoveUnusedStates<LETTER, STATE> {
    private final AbstractGeneralizedAutomatonReachableStates<LETTER, STATE> mOperand;
    private final AutomataLibraryServices mServices;

    public RemoveUnusedStates(AutomataLibraryServices automataLibraryServices, AbstractGeneralizedAutomatonReachableStates<LETTER, STATE> abstractGeneralizedAutomatonReachableStates) throws AutomataOperationCanceledException {
        this.mServices = automataLibraryServices;
        this.mOperand = abstractGeneralizedAutomatonReachableStates;
        this.removeUnusedStates();
    }

    private void removeUnusedStates() throws AutomataOperationCanceledException {
        HashSet hashSet = new HashSet(this.mOperand.getStates());
        LinkedList linkedList = new LinkedList();
        HashSet hashSet2 = new HashSet();
        for (Object object : this.mOperand.mFinalStates) {
            linkedList.addFirst(object);
        }
        while (!linkedList.isEmpty()) {
            Object object;
            if (!this.mServices.getProgressAwareTimer().continueProcessing()) {
                object = this.constructRunningTaskInfo();
                throw new AutomataOperationCanceledException((RunningTaskInfo)object);
            }
            object = linkedList.poll();
            hashSet2.add(object);
            hashSet.remove(object);
            StateContainer<LETTER, STATE> stateContainer = this.mOperand.getStateContainer(object);
            for (IncomingInternalTransition object2 : stateContainer.internalPredecessors()) {
                if (hashSet2.contains(object2.getPred())) continue;
                linkedList.addFirst(object2.getPred());
            }
        }
        for (Object object : hashSet) {
            StateContainer<LETTER, STATE> stateContainer = this.mOperand.getStateContainer(object);
            HashSet hashSet3 = new HashSet();
            for (IncomingInternalTransition<LETTER, STATE> incomingInternalTransition : stateContainer.internalPredecessors()) {
                Object object2;
                if (!this.mServices.getProgressAwareTimer().continueProcessing()) {
                    object2 = this.constructRunningTaskInfo();
                    throw new AutomataOperationCanceledException((RunningTaskInfo)object2);
                }
                object2 = this.mOperand.getStateContainer(incomingInternalTransition.getPred());
                if (object2 != null) {
                    ((StateContainer)object2).removeSuccessor(object);
                }
                hashSet3.add(incomingInternalTransition.getPred());
            }
            stateContainer.removePredecessors(hashSet3);
            this.mOperand.removeStates(object);
        }
    }

    private RunningTaskInfo constructRunningTaskInfo() {
        String string = "remove unused states (" + this.mOperand.getClass().getSimpleName() + ")";
        RunningTaskInfo runningTaskInfo = new RunningTaskInfo(this.getClass(), string);
        return runningTaskInfo;
    }

    public INestedWordAutomaton<LETTER, STATE> getResult() {
        return this.mOperand;
    }
}

