/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.partialorder.independence;

import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.IIndependenceRelation;
import java.util.function.BinaryOperator;
import java.util.function.Function;

public class IndependenceResultAggregator<T> {
    private T mIndependentConditional;
    private T mIndependentUnconditional;
    private T mDependentConditional;
    private T mDependentUnconditional;
    private T mUnknownConditional;
    private T mUnknownUnconditional;
    private final BinaryOperator<T> mAggregator;

    private IndependenceResultAggregator(T t, BinaryOperator<T> binaryOperator) {
        this.mIndependentConditional = t;
        this.mIndependentUnconditional = t;
        this.mDependentConditional = t;
        this.mDependentUnconditional = t;
        this.mUnknownConditional = t;
        this.mUnknownUnconditional = t;
        this.mAggregator = binaryOperator;
    }

    protected void aggregate(T t, IIndependenceRelation.Dependence dependence, boolean bl) {
        switch (dependence) {
            case DEPENDENT: {
                this.aggregateDependent(t, bl);
                return;
            }
            case INDEPENDENT: {
                this.aggregateIndependent(t, bl);
                return;
            }
            case UNKNOWN: {
                this.aggregateUnknown(t, bl);
                return;
            }
        }
        throw new IllegalArgumentException("Unknown value: " + String.valueOf((Object)dependence));
    }

    protected void aggregateIndependent(T t, boolean bl) {
        if (bl) {
            this.mIndependentConditional = this.mAggregator.apply(this.mIndependentConditional, t);
        } else {
            this.mIndependentUnconditional = this.mAggregator.apply(this.mIndependentUnconditional, t);
        }
    }

    protected void aggregateDependent(T t, boolean bl) {
        if (bl) {
            this.mDependentConditional = this.mAggregator.apply(this.mDependentConditional, t);
        } else {
            this.mDependentUnconditional = this.mAggregator.apply(this.mDependentUnconditional, t);
        }
    }

    protected void aggregateUnknown(T t, boolean bl) {
        if (bl) {
            this.mUnknownConditional = this.mAggregator.apply(this.mUnknownConditional, t);
        } else {
            this.mUnknownUnconditional = this.mAggregator.apply(this.mUnknownUnconditional, t);
        }
    }

    protected void aggregate(IndependenceResultAggregator<T> independenceResultAggregator) {
        this.mIndependentConditional = this.mAggregator.apply(this.mIndependentConditional, independenceResultAggregator.mIndependentConditional);
        this.mIndependentUnconditional = this.mAggregator.apply(this.mIndependentUnconditional, independenceResultAggregator.mIndependentUnconditional);
        this.mDependentConditional = this.mAggregator.apply(this.mDependentConditional, independenceResultAggregator.mDependentConditional);
        this.mDependentUnconditional = this.mAggregator.apply(this.mDependentUnconditional, independenceResultAggregator.mDependentUnconditional);
        this.mUnknownConditional = this.mAggregator.apply(this.mUnknownConditional, independenceResultAggregator.mUnknownConditional);
        this.mUnknownUnconditional = this.mAggregator.apply(this.mUnknownUnconditional, independenceResultAggregator.mUnknownUnconditional);
    }

    public T getTotal() {
        return (T)this.mAggregator.apply(this.getConditional(), this.getUnconditional());
    }

    public T getConditional() {
        return (T)this.mAggregator.apply(this.getIndependentConditional(), this.mAggregator.apply(this.getDependentConditional(), this.getUnknownConditional()));
    }

    public T getUnconditional() {
        return (T)this.mAggregator.apply(this.getIndependentUnconditional(), this.mAggregator.apply(this.getDependentUnconditional(), this.getUnknownUnconditional()));
    }

    public T getIndependent() {
        return (T)this.mAggregator.apply(this.getIndependentConditional(), this.getIndependentUnconditional());
    }

    public T getIndependentConditional() {
        return this.mIndependentConditional;
    }

    public T getIndependentUnconditional() {
        return this.mIndependentUnconditional;
    }

    public T getDependent() {
        return (T)this.mAggregator.apply(this.getDependentConditional(), this.getDependentUnconditional());
    }

    public T getDependentConditional() {
        return this.mDependentConditional;
    }

    public T getDependentUnconditional() {
        return this.mDependentUnconditional;
    }

    public T getUnknown() {
        return (T)this.mAggregator.apply(this.getUnknownConditional(), this.getUnknownUnconditional());
    }

    public T getUnknownConditional() {
        return this.mUnknownConditional;
    }

    public T getUnknownUnconditional() {
        return this.mUnknownUnconditional;
    }

    public String print(Function<T, String> function) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[ total: ");
        stringBuilder.append(function.apply(this.getTotal()));
        stringBuilder.append(", independent: ");
        stringBuilder.append(function.apply(this.getIndependent()));
        stringBuilder.append(", independent conditional: ");
        stringBuilder.append(function.apply(this.getIndependentConditional()));
        stringBuilder.append(", independent unconditional: ");
        stringBuilder.append(function.apply(this.getIndependentUnconditional()));
        stringBuilder.append(", dependent: ");
        stringBuilder.append(function.apply(this.getDependent()));
        stringBuilder.append(", dependent conditional: ");
        stringBuilder.append(function.apply(this.getDependentConditional()));
        stringBuilder.append(", dependent unconditional: ");
        stringBuilder.append(function.apply(this.getDependentUnconditional()));
        stringBuilder.append(", unknown: ");
        stringBuilder.append(function.apply(this.getUnknown()));
        stringBuilder.append(", unknown conditional: ");
        stringBuilder.append(function.apply(this.getUnknownConditional()));
        stringBuilder.append(", unknown unconditional: ");
        stringBuilder.append(function.apply(this.getUnknownUnconditional()));
        stringBuilder.append("] ");
        return stringBuilder.toString();
    }

    public static class Counter
    extends IndependenceResultAggregator<Integer> {
        public Counter() {
            super(0, (n, n2) -> n + n2);
        }

        public void increment(IIndependenceRelation.Dependence dependence, boolean bl) {
            this.aggregate(1, dependence, bl);
        }

        public static Counter sum(Counter counter, Counter counter2) {
            Counter counter3 = new Counter();
            counter3.aggregate(counter);
            counter3.aggregate(counter2);
            return counter3;
        }
    }

    public static class Timer
    extends IndependenceResultAggregator<Long> {
        private long mStartTime;

        public Timer() {
            super(0L, (l, l2) -> l + l2);
        }

        public void start() {
            assert (this.mStartTime == 0L) : "Timer already running";
            this.mStartTime = System.nanoTime();
        }

        public void stop(IIndependenceRelation.Dependence dependence, boolean bl) {
            assert (this.mStartTime != 0L) : "Timer was not running";
            long l = System.nanoTime() - this.mStartTime;
            this.aggregate(l, dependence, bl);
            this.mStartTime = 0L;
        }

        public static Timer sum(Timer timer, Timer timer2) {
            Timer timer3 = new Timer();
            timer3.aggregate(timer);
            timer3.aggregate(timer2);
            return timer3;
        }
    }
}

