/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.tree.operations.difference;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.GeneralOperation;
import de.uni_freiburg.informatik.ultimate.automata.IOperation;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.DummySemanticReducerFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IIntersectionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IMergeStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.ISemanticReducerFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.ISinkStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.StringFactory;
import de.uni_freiburg.informatik.ultimate.automata.tree.IRankedLetter;
import de.uni_freiburg.informatik.ultimate.automata.tree.ITreeAutomatonBU;
import de.uni_freiburg.informatik.ultimate.automata.tree.StringRankedLetter;
import de.uni_freiburg.informatik.ultimate.automata.tree.TreeAutomatonBU;
import de.uni_freiburg.informatik.ultimate.automata.tree.TreeAutomatonRule;
import de.uni_freiburg.informatik.ultimate.automata.tree.operations.Determinize;
import de.uni_freiburg.informatik.ultimate.automata.tree.operations.IsEquivalent;
import de.uni_freiburg.informatik.ultimate.automata.tree.operations.difference.Difference;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.services.ToolchainStorage;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.util.CombinatoricsUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LazyDifference<LETTER extends IRankedLetter, STATE>
extends GeneralOperation<LETTER, STATE, IStateFactory<STATE>>
implements IOperation<LETTER, STATE, IStateFactory<STATE>> {
    private final ITreeAutomatonBU<LETTER, STATE> mFirstOperand;
    private final ITreeAutomatonBU<LETTER, STATE> mResult;
    private final ITreeAutomatonBU<LETTER, STATE> mSecondOperand;
    private final STATE mSink;
    private NestedMap2<STATE, STATE, STATE> mCache;
    private final ISemanticReducerFactory<STATE, LETTER> mReducer;

    public <SF extends IMergeStateFactory<STATE> & ISinkStateFactory<STATE>> LazyDifference(AutomataLibraryServices automataLibraryServices, SF SF, ITreeAutomatonBU<LETTER, STATE> iTreeAutomatonBU, ITreeAutomatonBU<LETTER, STATE> iTreeAutomatonBU2, ISemanticReducerFactory<STATE, LETTER> iSemanticReducerFactory) throws AutomataOperationCanceledException {
        super(automataLibraryServices);
        this.mFirstOperand = new Determinize<LETTER, STATE>(automataLibraryServices, SF, iTreeAutomatonBU).getResult();
        this.mSecondOperand = new Determinize<LETTER, STATE>(automataLibraryServices, SF, iTreeAutomatonBU2).getResult();
        this.mReducer = iSemanticReducerFactory;
        this.mSink = ((ISinkStateFactory<STATE>)SF).createSinkStateContent();
        this.mCache = new NestedMap2();
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)this.startMessage());
        }
        this.mResult = this.computeDifference(SF);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)this.exitMessage());
        }
    }

    public <SF extends IMergeStateFactory<STATE> & ISinkStateFactory<STATE>> LazyDifference(AutomataLibraryServices automataLibraryServices, SF SF, ITreeAutomatonBU<LETTER, STATE> iTreeAutomatonBU, ITreeAutomatonBU<LETTER, STATE> iTreeAutomatonBU2) throws AutomataOperationCanceledException {
        this(automataLibraryServices, SF, iTreeAutomatonBU, iTreeAutomatonBU2, SF instanceof ISemanticReducerFactory ? (ISemanticReducerFactory)SF : new DummySemanticReducerFactory());
    }

    private <SF extends IMergeStateFactory<STATE> & ISinkStateFactory<STATE>> boolean getAllDestinations(SF SF, List<Collection<Pair<STATE, STATE>>> list, Map<STATE, Set<STATE>> map, TreeAutomatonRule<LETTER, STATE> treeAutomatonRule, Set<TreeAutomatonRule<LETTER, STATE>> set) {
        boolean bl = false;
        assert (list.size() == treeAutomatonRule.getArity() && treeAutomatonRule.getArity() == treeAutomatonRule.getLetter().getRank());
        for (List list2 : CombinatoricsUtils.getCombinations(list)) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            ArrayList<Object> arrayList3 = new ArrayList<Object>();
            for (Object object : list2) {
                arrayList.add(object.getFirst());
                arrayList2.add(object.getSecond());
                arrayList3.add(this.intersectPair(SF, (STATE)object.getFirst(), (STATE)object.getSecond()));
            }
            for (Object object : this.mFirstOperand.getSuccessors(arrayList, treeAutomatonRule.getLetter())) {
                Set set2;
                if (map.get(object) == null) {
                    map.put(object, new HashSet());
                }
                if ((set2 = CombinatoricsUtils.iterateAll(this.mSecondOperand.getSuccessors(arrayList2, treeAutomatonRule.getLetter()))).isEmpty()) {
                    set.add(new TreeAutomatonRule<LETTER, Pair>(treeAutomatonRule.getLetter(), arrayList3, this.intersectPair(SF, (STATE)object, this.mSink)));
                    bl |= !map.get(object).contains(this.mSink);
                    map.get(object).add(this.mSink);
                    continue;
                }
                for (Object e : set2) {
                    set.add(new TreeAutomatonRule<LETTER, Pair>(treeAutomatonRule.getLetter(), arrayList3, this.intersectPair(SF, (STATE)object, (STATE)e)));
                    bl |= !map.get(object).contains(e);
                    map.get(object).add(e);
                }
            }
        }
        return bl;
    }

    private <SF extends IMergeStateFactory<STATE> & ISinkStateFactory<STATE>> ITreeAutomatonBU<LETTER, STATE> computeDifference(SF SF) {
        boolean bl;
        HashMap hashMap = new HashMap();
        HashSet<TreeAutomatonRule<LETTER, STATE>> hashSet = new HashSet<TreeAutomatonRule<LETTER, STATE>>();
        do {
            bl = false;
            for (List<STATE> nestedMap22 : this.mFirstOperand.getSourceCombinations()) {
                for (TreeAutomatonRule<List<STATE>, STATE> treeAutomatonRule : this.mFirstOperand.getSuccessors(nestedMap22)) {
                    if (!hashMap.keySet().containsAll(treeAutomatonRule.getSource())) {
                        assert (!treeAutomatonRule.getSource().isEmpty());
                        continue;
                    }
                    Object object3 = new LinkedList();
                    for (Object object2 : treeAutomatonRule.getSource()) {
                        HashSet<Pair> hashSet2 = new HashSet<Pair>();
                        for (Object e : (Set)hashMap.get(object2)) {
                            hashSet2.add(new Pair(object2, e));
                        }
                        hashSet2.add(new Pair(object2, this.mSink));
                        object3.add(hashSet2);
                    }
                    bl |= this.getAllDestinations(SF, (List<Collection<Pair<STATE, STATE>>>)object3, hashMap, treeAutomatonRule, (Set<TreeAutomatonRule<LETTER, STATE>>)hashSet);
                }
            }
        } while (bl);
        NestedMap2 nestedMap2 = new NestedMap2();
        for (TreeAutomatonRule treeAutomatonRule : hashSet) {
            if (nestedMap2.get(treeAutomatonRule.getSource(), treeAutomatonRule.getLetter()) == null) {
                nestedMap2.put(treeAutomatonRule.getSource(), treeAutomatonRule.getLetter(), new HashSet());
            }
            ((Set)nestedMap2.get(treeAutomatonRule.getSource(), treeAutomatonRule.getLetter())).add(treeAutomatonRule.getDest());
        }
        hashSet.clear();
        for (Triple triple : nestedMap2.entrySet()) {
            for (Iterator<TreeAutomatonRule<List<Object>, STATE>> iterator : this.mReducer.filter((Iterable)triple.getThird())) {
                hashSet.add(new TreeAutomatonRule<IRankedLetter, Iterator<TreeAutomatonRule<List<Object>, STATE>>>((IRankedLetter)triple.getSecond(), (List)triple.getFirst(), iterator));
            }
        }
        TreeAutomatonBU treeAutomatonBU = new TreeAutomatonBU();
        treeAutomatonBU.extendAlphabet(this.mFirstOperand.getAlphabet());
        treeAutomatonBU.extendAlphabet(this.mSecondOperand.getAlphabet());
        for (TreeAutomatonRule<List<Object>, STATE> treeAutomatonRule : hashSet) {
            treeAutomatonBU.addRule(treeAutomatonRule);
        }
        for (Object object : this.mFirstOperand.getStates()) {
            for (Object object3 : this.mSecondOperand.getStates()) {
                treeAutomatonBU.addState(this.intersectPair(SF, (STATE)object, (STATE)object3));
                if (!this.mFirstOperand.isFinalState(object) || this.mSecondOperand.isFinalState(object3)) continue;
                treeAutomatonBU.addFinalState(this.intersectPair(SF, (STATE)object, (STATE)object3));
            }
            assert (!this.mSecondOperand.isFinalState(this.mSink));
            treeAutomatonBU.addState(this.intersectPair(SF, (STATE)object, this.mSink));
            if (!this.mFirstOperand.isFinalState(object)) continue;
            treeAutomatonBU.addFinalState(this.intersectPair(SF, (STATE)object, this.mSink));
        }
        return treeAutomatonBU;
    }

    private <SF extends IMergeStateFactory<STATE> & ISinkStateFactory<STATE>> STATE intersectPair(SF SF, STATE STATE, STATE STATE2) {
        Object object = this.mCache.get(STATE, STATE2);
        if (object == null) {
            object = ((IIntersectionStateFactory)SF).intersection(STATE, STATE2);
            this.mCache.put(STATE, STATE2, object);
        }
        return (STATE)object;
    }

    @Override
    public ITreeAutomatonBU<LETTER, STATE> getResult() {
        return this.mResult;
    }

    @Override
    public boolean checkResult(IStateFactory<STATE> iStateFactory) throws AutomataLibraryException {
        return true;
    }

    public static void main(String[] stringArray) throws AutomataOperationCanceledException {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(2);
        hashSet.add(3);
        hashSet.add(5);
        HashSet<Integer> hashSet2 = new HashSet<Integer>();
        hashSet2.add(1);
        hashSet2.add(10);
        hashSet2.add(100);
        List<Collection> list = Arrays.asList(hashSet, hashSet2);
        System.out.println(hashSet);
        System.out.println(hashSet2);
        System.out.println(CombinatoricsUtils.getCombinations(list));
        StringFactory stringFactory = new StringFactory();
        TreeAutomatonBU<StringRankedLetter, String> treeAutomatonBU = new TreeAutomatonBU<StringRankedLetter, String>();
        treeAutomatonBU.addRule(new TreeAutomatonRule<StringRankedLetter, String>(new StringRankedLetter("cons", 2), Arrays.asList("Num", "List"), "List"));
        treeAutomatonBU.addRule(new TreeAutomatonRule<StringRankedLetter, String>(new StringRankedLetter("nil", 0), Arrays.asList(new String[0]), "List"));
        treeAutomatonBU.addRule(new TreeAutomatonRule<StringRankedLetter, String>(new StringRankedLetter("0", 0), Arrays.asList(new String[0]), "Num"));
        treeAutomatonBU.addRule(new TreeAutomatonRule<StringRankedLetter, String>(new StringRankedLetter("succ", 1), Arrays.asList("Num"), "Num"));
        treeAutomatonBU.addFinalState("List");
        TreeAutomatonBU<StringRankedLetter, String> treeAutomatonBU2 = new TreeAutomatonBU<StringRankedLetter, String>();
        treeAutomatonBU2.addRule(new TreeAutomatonRule<StringRankedLetter, String>(new StringRankedLetter("cons", 2), Arrays.asList("Num", "List"), "List"));
        treeAutomatonBU2.addRule(new TreeAutomatonRule<StringRankedLetter, String>(new StringRankedLetter("nil", 0), Arrays.asList(new String[0]), "List"));
        treeAutomatonBU2.addRule(new TreeAutomatonRule<StringRankedLetter, String>(new StringRankedLetter("0", 0), Arrays.asList(new String[0]), "Num"));
        treeAutomatonBU2.addRule(new TreeAutomatonRule<StringRankedLetter, String>(new StringRankedLetter("1", 0), Arrays.asList(new String[0]), "Num"));
        treeAutomatonBU2.addFinalState("List");
        System.out.println(treeAutomatonBU);
        System.out.println(treeAutomatonBU2);
        AutomataLibraryServices automataLibraryServices = new AutomataLibraryServices((IUltimateServiceProvider)new ToolchainStorage());
        Difference difference = new Difference(automataLibraryServices, stringFactory, treeAutomatonBU, treeAutomatonBU2);
        LazyDifference lazyDifference = new LazyDifference(automataLibraryServices, stringFactory, treeAutomatonBU, treeAutomatonBU2);
        boolean bl = new IsEquivalent(automataLibraryServices, stringFactory, difference.getResult(), lazyDifference.getResult()).getResult();
        System.out.println(bl);
        System.out.println(new LazyDifference(automataLibraryServices, stringFactory, treeAutomatonBU, treeAutomatonBU2).getResult());
    }
}

