/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.chc;

import de.uni_freiburg.informatik.ultimate.lib.chc.HcPredicateSymbol;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.chc.HornClause;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.NamedTermWrapper;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.LoggingScript;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ChcAsserter {
    private final ManagedScript mMgdScript;
    private final Script mOutputScript;
    private final boolean mAddClauseNames;
    private final boolean mAddComments;
    private final boolean mDeclareFunctions;
    private Map<String, HornClause> mName2Clause;

    public ChcAsserter(ManagedScript managedScript, Script script, boolean bl, boolean bl2, boolean bl3) {
        this.mMgdScript = managedScript;
        this.mOutputScript = script;
        this.mAddClauseNames = bl;
        this.mAddComments = bl2;
        this.mDeclareFunctions = bl3;
        assert (!this.mAddComments || script instanceof LoggingScript);
    }

    public void assertClauses(HcSymbolTable hcSymbolTable, List<HornClause> list) {
        this.reset();
        ArrayList<HornClause> arrayList = new ArrayList<HornClause>();
        ArrayList<HornClause> arrayList2 = new ArrayList<HornClause>();
        for (HornClause hornClause : list) {
            if (hornClause.isHeadFalse()) {
                arrayList2.add(hornClause);
                continue;
            }
            arrayList.add(hornClause);
        }
        if (this.mDeclareFunctions) {
            for (HcPredicateSymbol hcPredicateSymbol : hcSymbolTable.getHcPredicateSymbols()) {
                FunctionSymbol functionSymbol = hcPredicateSymbol.getFunctionSymbol();
                this.mOutputScript.declareFun(functionSymbol.getName(), functionSymbol.getParameterSorts(), functionSymbol.getReturnSort());
            }
            for (Triple triple : hcSymbolTable.getSkolemFunctions()) {
                this.mOutputScript.declareFun((String)triple.getFirst(), (Sort[])triple.getSecond(), (Sort)triple.getThird());
            }
        }
        this.assertClauses(arrayList);
        this.assertClauses(arrayList2);
    }

    private void assertClauses(List<HornClause> list) {
        for (HornClause hornClause : list) {
            if (this.mAddComments) {
                ((LoggingScript)this.mOutputScript).comment(hornClause.toString());
            }
            Term term = hornClause.constructFormula(this.mMgdScript, this.mAddClauseNames);
            this.mOutputScript.assertTerm(term);
            if (!this.mAddClauseNames) continue;
            NamedTermWrapper namedTermWrapper = NamedTermWrapper.of((Term)term);
            assert (namedTermWrapper != null) : "term was not named: " + String.valueOf(term);
            this.mName2Clause.put(namedTermWrapper.getName(), hornClause);
        }
    }

    private void reset() {
        this.mName2Clause = new HashMap<String, HornClause>();
    }

    public Map<String, HornClause> getName2Clause() {
        return Collections.unmodifiableMap(this.mName2Clause);
    }
}

