/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.model.acsl.ast;

import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLTransformer;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLVisitor;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ContractStatement;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Expression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public final class Assigns
extends ContractStatement {
    private static final Predicate<ACSLNode> VALIDATOR = ACSLNode.VALIDATORS.get(Assigns.class);
    Expression[] locations;

    public Assigns(Expression[] expressionArray) {
        this.locations = expressionArray;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid Assigns: " + String.valueOf(this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Assigns").append('[');
        if (this.locations == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            int n = 0;
            while (n < this.locations.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.locations[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        return stringBuffer.append(']').toString();
    }

    public Expression[] getLocations() {
        return this.locations;
    }

    @Override
    public List<ACSLNode> getOutgoingNodes() {
        List<ACSLNode> list = super.getOutgoingNodes();
        if (this.locations != null) {
            list.addAll(Arrays.asList(this.locations));
        }
        return list;
    }

    @Override
    public void accept(ACSLVisitor aCSLVisitor) {
        if (!aCSLVisitor.visit((ContractStatement)this)) {
            return;
        }
        if (aCSLVisitor.visit(this) && this.locations != null) {
            Expression[] expressionArray = this.locations;
            int n = this.locations.length;
            int n2 = 0;
            while (n2 < n) {
                Expression expression = expressionArray[n2];
                expression.accept(aCSLVisitor);
                ++n2;
            }
        }
    }

    @Override
    public ContractStatement accept(ACSLTransformer aCSLTransformer) {
        ContractStatement contractStatement = aCSLTransformer.transform(this);
        if (contractStatement != this) {
            return contractStatement;
        }
        boolean bl = false;
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        if (this.locations != null) {
            Expression[] expressionArray = this.locations;
            int n = this.locations.length;
            int n2 = 0;
            while (n2 < n) {
                Expression expression = expressionArray[n2];
                Expression expression2 = expression.accept(aCSLTransformer);
                bl = bl || expression2 != expression;
                arrayList.add(expression2);
                ++n2;
            }
        }
        if (bl) {
            return new Assigns(arrayList.toArray(new Expression[0]));
        }
        return this;
    }
}

