/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.woelfing;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.woelfing.SymbolicMemory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IteratedSymbolicMemory
extends SymbolicMemory {
    private final List<TermVariable> mLoopCounters;
    private final Map<TermVariable, TermVariable> mRenamedVars = new HashMap<TermVariable, TermVariable>();
    private final List<SymbolicMemory> mSymbolicMemories;

    public IteratedSymbolicMemory(ManagedScript managedScript, List<SymbolicMemory> list) {
        super(managedScript);
        this.mSymbolicMemories = list;
        int n = this.mSymbolicMemories.size();
        this.mLoopCounters = new ArrayList<TermVariable>(n);
        Sort sort = SmtSortUtils.getIntSort((ManagedScript)this.mScript);
        int n2 = 0;
        while (n2 < n) {
            this.mLoopCounters.add(this.mScript.constructFreshTermVariable("loopCounter", sort));
            ++n2;
        }
        for (SymbolicMemory symbolicMemory : this.mSymbolicMemories) {
            TermVariable termVariable;
            TermVariable termVariable2;
            this.mOverapproximation |= symbolicMemory.isOverapproximation();
            for (IProgramVar iProgramVar : symbolicMemory.mInVars.keySet()) {
                termVariable2 = symbolicMemory.mInVars.get(iProgramVar);
                if (this.mInVars.containsKey(iProgramVar)) {
                    assert (!((TermVariable)this.mInVars.get(iProgramVar)).equals(termVariable2));
                    this.mRenamedVars.put(termVariable2, (TermVariable)this.mInVars.get(iProgramVar));
                    continue;
                }
                if (this.mRenamedVars.containsKey(termVariable2)) {
                    this.mInVars.put(iProgramVar, this.mRenamedVars.get(termVariable2));
                    continue;
                }
                termVariable = this.mScript.constructFreshCopy(termVariable2);
                this.mRenamedVars.put(termVariable2, termVariable);
                this.mInVars.put(iProgramVar, termVariable);
            }
            for (IProgramVar iProgramVar : symbolicMemory.mOutVars.keySet()) {
                termVariable2 = symbolicMemory.mOutVars.get(iProgramVar);
                if (this.mOutVars.containsKey(iProgramVar)) {
                    assert (!((TermVariable)this.mOutVars.get(iProgramVar)).equals(termVariable2));
                    this.mRenamedVars.put(termVariable2, (TermVariable)this.mOutVars.get(iProgramVar));
                    continue;
                }
                if (this.mRenamedVars.containsKey(termVariable2)) {
                    this.mOutVars.put(iProgramVar, this.mRenamedVars.get(termVariable2));
                    continue;
                }
                termVariable = this.mScript.constructFreshCopy(termVariable2);
                this.mRenamedVars.put(termVariable2, termVariable);
                this.mOutVars.put(iProgramVar, termVariable);
            }
        }
        ArrayDeque arrayDeque = new ArrayDeque(this.mOutVars.keySet());
        while (!arrayDeque.isEmpty()) {
            IProgramVar iProgramVar = (IProgramVar)arrayDeque.pop();
            Term term = this.getIteratedTerm(iProgramVar);
            if (term != null) {
                this.mVariableTerms.put((TermVariable)this.mOutVars.get(iProgramVar), term);
                continue;
            }
            this.mOverapproximation = true;
        }
    }

    private Term getIteratedTerm(IProgramVar iProgramVar) {
        Term term;
        Term term2;
        Term[] termArray = new Term[this.mSymbolicMemories.size()];
        int n = 0;
        while (n < termArray.length) {
            termArray[n] = this.mSymbolicMemories.get(n).getVariableTerm(iProgramVar);
            ++n;
        }
        Term term3 = (Term)this.mInVars.get(iProgramVar);
        ConstantTerm constantTerm = null;
        ArrayList<TermVariable> arrayList = new ArrayList<TermVariable>();
        int n2 = 0;
        while (n2 < termArray.length) {
            term2 = this.simplifyTerm(this.mSymbolicMemories.get(n2), termArray[n2]);
            if (term2 == null) {
                return null;
            }
            if (term2 instanceof ApplicationTerm) {
                ApplicationTerm applicationTerm2 = (ApplicationTerm)term2;
                assert ("+".equals(applicationTerm2.getFunction().getName()));
                Term[] termArray2 = applicationTerm2.getParameters();
                if (termArray2[0] != this.mInVars.get(iProgramVar)) {
                    return null;
                }
                term = new Term[termArray2.length];
                term[0] = term3;
                int n3 = 1;
                while (n3 < termArray2.length) {
                    if (!(termArray2[n3] instanceof ConstantTerm)) {
                        return null;
                    }
                    term[n3] = this.mScript.getScript().term("*", new Term[]{(Term)this.mLoopCounters.get(n2), termArray2[n3]});
                    ++n3;
                }
                term3 = this.mScript.getScript().term("+", IteratedSymbolicMemory.mergeSums((Term[])term));
            } else if (term2 instanceof TermVariable) {
                if (term2 != this.mInVars.get(iProgramVar)) {
                    return null;
                }
            } else if (term2 instanceof ConstantTerm) {
                if (constantTerm != null && constantTerm != term2) {
                    return null;
                }
                constantTerm = (ConstantTerm)term2;
                arrayList.add(this.mLoopCounters.get(n2));
            } else {
                throw new AssertionError((Object)"Unexpected term type.");
            }
            ++n2;
        }
        if (constantTerm != null) {
            if (term3 != this.mInVars.get(iProgramVar)) {
                return null;
            }
            Term term4 = Rational.ZERO.toTerm(SmtSortUtils.getIntSort((ManagedScript)this.mScript));
            term2 = this.mScript.getScript().term("false", new Term[0]);
            for (TermVariable termVariable : arrayList) {
                term = this.mScript.getScript().term(">", new Term[]{termVariable, term4});
                term2 = SmtUtils.or((Script)this.mScript.getScript(), (Term[])new Term[]{term2, term});
            }
            if (term3 == null) {
                TermVariable termVariable = this.mScript.constructFreshCopy(iProgramVar.getTermVariable());
                this.mInVars.put(iProgramVar, termVariable);
                term3 = termVariable;
            }
            return this.mScript.getScript().term("ite", new Term[]{term2, constantTerm, term3});
        }
        return term3;
    }

    private static Term[] mergeSums(Term[] termArray) {
        ArrayList<Term> arrayList = new ArrayList<Term>(Arrays.asList(termArray));
        int n = 0;
        while (n < arrayList.size()) {
            if (arrayList.get(n) instanceof ApplicationTerm && "+".equals(((ApplicationTerm)arrayList.get(n)).getFunction().getName())) {
                ApplicationTerm applicationTerm = (ApplicationTerm)arrayList.get(n);
                arrayList.remove(n);
                arrayList.addAll(n, Arrays.asList(applicationTerm.getParameters()));
            }
            ++n;
        }
        return arrayList.toArray(new Term[0]);
    }

    private Term simplifyTerm(SymbolicMemory symbolicMemory, Term term) {
        if (term instanceof TermVariable) {
            if (this.mRenamedVars.containsKey(term)) {
                return this.simplifyTerm(symbolicMemory, (Term)this.mRenamedVars.get(term));
            }
            if (this.mInVars.containsValue(term)) {
                return term;
            }
            Term term2 = symbolicMemory.getVariableTerm((TermVariable)term);
            return this.simplifyTerm(symbolicMemory, term2);
        }
        if (term instanceof ApplicationTerm) {
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            if ("+".equals(applicationTerm.getFunction().getName())) {
                Term[] termArray = (Term[])applicationTerm.getParameters().clone();
                int n = 0;
                while (n < termArray.length) {
                    termArray[n] = this.simplifyTerm(symbolicMemory, termArray[n]);
                    if (termArray[n] == null) {
                        return null;
                    }
                    ++n;
                }
                termArray = IteratedSymbolicMemory.mergeSums(termArray);
                assert (this.mInVars.containsValue(termArray[0]));
                return this.mScript.getScript().term("+", termArray);
            }
        } else if (term instanceof ConstantTerm) {
            return term;
        }
        return null;
    }

    @Override
    public Term replaceTermVars(Term term, Map<IProgramVar, TermVariable> map) {
        if (this.mRenamedVars.containsKey(term) && (map == null || !map.containsValue(term))) {
            if (this.mOutVars.containsValue(this.mRenamedVars.get(term))) {
                return this.replaceTermVars((Term)this.mRenamedVars.get(term), map);
            }
            assert (false);
        }
        if (this.mRenamedVars.containsKey(term) && map != null && map.containsValue(term)) {
            for (Map.Entry<IProgramVar, TermVariable> entry : map.entrySet()) {
                if (!entry.getValue().equals(term) || this.mOutVars.containsKey(entry.getKey())) continue;
                return (Term)this.mRenamedVars.get(term);
            }
        }
        return super.replaceTermVars(term, map);
    }

    public List<TermVariable> getLoopCounters() {
        return this.mLoopCounters;
    }

    public SymbolicMemory getSymbolicMemory(int n) {
        return this.mSymbolicMemories.get(n);
    }
}

