/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.tracecheck;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SMTFeatureExtractionTermClassifier;

public interface ITraceCheckPreferences {
    public boolean getUseSeparateSolverForTracechecks();

    public AssertCodeBlockOrder getAssertCodeBlockOrder();

    public String getPathOfDumpedScript();

    public boolean getDumpSmtScriptToFile();

    public boolean getUseWeakestPreconditionForPathInvariants();

    public boolean getUseAbstractInterpretation();

    public boolean getUseVarsFromUnsatCore();

    public boolean getUseNonlinearConstraints();

    public IIcfg<?> getIcfgContainer();

    public boolean getUseLiveVariables();

    public UnsatCores getUnsatCores();

    public SmtUtils.SimplificationTechnique getSimplificationTechnique();

    public CfgSmtToolkit getCfgSmtToolkit();

    public boolean collectInterpolantStatistics();

    public boolean computeCounterexample();

    public static class AssertCodeBlockOrder {
        public static final SmtFeatureHeuristicPartitioningType DEF_PARTITIONING_STRATEGY = SmtFeatureHeuristicPartitioningType.FIXED_NUM_PARTITIONS;
        public static final SMTFeatureExtractionTermClassifier.ScoringMethod DEF_SCORING_METHOD = SMTFeatureExtractionTermClassifier.ScoringMethod.NUM_FUNCTIONS;
        public static final int DEF_NUM_PARTITIONS = 4;
        public static final double DEF_SCORE_THRESHOLD = 0.75;
        public static final AssertCodeBlockOrder NOT_INCREMENTALLY = new AssertCodeBlockOrder(AssertCodeBlockOrderType.NOT_INCREMENTALLY);
        private final AssertCodeBlockOrderType mAssertCodeBlockOrderType;
        private final SmtFeatureHeuristicPartitioningType mSmtFeatureHeuristicPartitioningType;
        private final SMTFeatureExtractionTermClassifier.ScoringMethod mSmtFeatureHeuristicScoringMethod;
        private final int mSmtFeatureHeuristicNumPartitions;
        private final double mSmtFeatureHeuristicThreshold;

        public AssertCodeBlockOrder(AssertCodeBlockOrderType assertCodeBlockOrderType) {
            this.mAssertCodeBlockOrderType = assertCodeBlockOrderType;
            this.mSmtFeatureHeuristicPartitioningType = DEF_PARTITIONING_STRATEGY;
            this.mSmtFeatureHeuristicScoringMethod = DEF_SCORING_METHOD;
            this.mSmtFeatureHeuristicNumPartitions = 4;
            this.mSmtFeatureHeuristicThreshold = 0.75;
        }

        public AssertCodeBlockOrder(AssertCodeBlockOrderType assertCodeBlockOrderType, SmtFeatureHeuristicPartitioningType smtFeatureHeuristicPartitioningType, SMTFeatureExtractionTermClassifier.ScoringMethod scoringMethod, int n, double d) {
            this.mAssertCodeBlockOrderType = assertCodeBlockOrderType;
            this.mSmtFeatureHeuristicPartitioningType = smtFeatureHeuristicPartitioningType;
            this.mSmtFeatureHeuristicScoringMethod = scoringMethod;
            this.mSmtFeatureHeuristicNumPartitions = n;
            this.mSmtFeatureHeuristicThreshold = d;
        }

        public AssertCodeBlockOrderType getAssertCodeBlockOrderType() {
            return this.mAssertCodeBlockOrderType;
        }

        public SmtFeatureHeuristicPartitioningType getSmtFeatureHeuristicPartitioningType() {
            return this.mSmtFeatureHeuristicPartitioningType;
        }

        public SMTFeatureExtractionTermClassifier.ScoringMethod getSmtFeatureHeuristicScoringMethod() {
            return this.mSmtFeatureHeuristicScoringMethod;
        }

        public int getSmtFeatureHeuristicNumPartitions() {
            return this.mSmtFeatureHeuristicNumPartitions;
        }

        public double getSmtFeatureHeuristicThreshold() {
            return this.mSmtFeatureHeuristicThreshold;
        }

        public String toString() {
            if (this.mAssertCodeBlockOrderType != AssertCodeBlockOrderType.SMT_FEATURE_HEURISTIC) {
                return this.mAssertCodeBlockOrderType.toString();
            }
            switch (this.mSmtFeatureHeuristicPartitioningType) {
                case FIXED_NUM_PARTITIONS: {
                    return String.format("%s (partitioning type %s, %s partitions)", this.mAssertCodeBlockOrderType.toString(), this.mSmtFeatureHeuristicPartitioningType.toString(), String.valueOf(this.mSmtFeatureHeuristicNumPartitions));
                }
                case THRESHOLD: {
                    return String.format("%s (partitioning type %s, threshold %s)", this.mAssertCodeBlockOrderType.toString(), this.mSmtFeatureHeuristicPartitioningType.toString(), String.valueOf(this.mSmtFeatureHeuristicThreshold));
                }
            }
            return String.format("%s (unknown partitioning type %s)", this.mAssertCodeBlockOrderType.toString(), this.mSmtFeatureHeuristicPartitioningType.toString());
        }
    }

    public static enum AssertCodeBlockOrderType {
        NOT_INCREMENTALLY,
        OUTSIDE_LOOP_FIRST1,
        OUTSIDE_LOOP_FIRST2,
        INSIDE_LOOP_FIRST1,
        MIX_INSIDE_OUTSIDE,
        TERMS_WITH_SMALL_CONSTANTS_FIRST,
        SMT_FEATURE_HEURISTIC,
        SHUFFLED_SINGLETONS;

    }

    public static enum SmtFeatureHeuristicPartitioningType {
        FIXED_NUM_PARTITIONS,
        THRESHOLD;

    }

    public static enum UnsatCores {
        IGNORE,
        STATEMENT_LEVEL,
        CONJUNCT_LEVEL;

    }
}

