/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie;

import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayStoreExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.FunctionApplication;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.QuantifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.output.BoogiePrettyPrinter;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieConstructedType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogiePrimitiveType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.util.simplifier.INormalFormable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class BoogieExpressionTransformer
implements INormalFormable<Expression> {
    public Collection<? extends Expression> normalizeNesting(Expression expression, Expression expression2) {
        if (expression instanceof BinaryExpression && expression2 instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            BinaryExpression binaryExpression2 = (BinaryExpression)expression2;
            if (binaryExpression.getOperator().equals((Object)binaryExpression2.getOperator())) {
                return BoogieExpressionTransformer.getOperands((BinaryExpression)expression2);
            }
        }
        return Collections.singleton(expression2);
    }

    public Expression makeFalse() {
        return new BooleanLiteral(null, BoogieType.TYPE_BOOL, false);
    }

    public Expression makeTrue() {
        return new BooleanLiteral(null, BoogieType.TYPE_BOOL, true);
    }

    public Expression makeAnd(Expression expression, Expression expression2) {
        if (((Object)((Object)expression)).equals((Object)expression2)) {
            return expression;
        }
        ArrayList<Expression> arrayList = new ArrayList<Expression>(2);
        arrayList.add(expression);
        arrayList.add(expression2);
        return BoogieExpressionTransformer.makeBoolBinop(BinaryExpression.Operator.LOGICAND, arrayList.iterator());
    }

    public Expression makeOr(Iterator<Expression> iterator) {
        return BoogieExpressionTransformer.makeBoolBinop(BinaryExpression.Operator.LOGICOR, iterator);
    }

    public Expression makeAnd(Iterator<Expression> iterator) {
        return BoogieExpressionTransformer.makeBoolBinop(BinaryExpression.Operator.LOGICAND, iterator);
    }

    private static Expression makeBoolBinop(BinaryExpression.Operator operator, Iterator<Expression> iterator) {
        Expression expression = null;
        Expression expression2 = null;
        Iterator<Expression> iterator2 = BoogieExpressionTransformer.unifyOperands(operator, iterator);
        while (iterator2.hasNext()) {
            expression = expression2;
            expression2 = iterator2.next();
            if (expression == null) continue;
            expression2 = new BinaryExpression(expression.getLocation(), BoogieType.TYPE_BOOL, operator, expression, expression2);
            if (iterator2.hasNext()) continue;
            return expression2;
        }
        if (expression == null && expression2 != null) {
            return expression2;
        }
        if (expression == null && expression2 == null) {
            throw new IllegalArgumentException("You must supply operands to this method");
        }
        return expression;
    }

    private static Iterator<Expression> unifyOperands(BinaryExpression.Operator operator, Iterator<Expression> iterator) {
        LinkedHashSet<Expression> linkedHashSet = new LinkedHashSet<Expression>();
        while (iterator.hasNext()) {
            Expression expression = iterator.next();
            if (expression instanceof BinaryExpression) {
                BinaryExpression binaryExpression = (BinaryExpression)expression;
                if (binaryExpression.getOperator().equals((Object)operator)) {
                    linkedHashSet.addAll(BoogieExpressionTransformer.getOperands(binaryExpression));
                } else {
                    linkedHashSet.add(expression);
                }
            } else {
                linkedHashSet.add(expression);
            }
            iterator.remove();
        }
        return linkedHashSet.iterator();
    }

    public Expression makeNot(Expression expression) {
        return new UnaryExpression(expression.getLocation(), BoogieType.TYPE_BOOL, UnaryExpression.Operator.LOGICNEG, expression);
    }

    public Expression getOperand(Expression expression) {
        if (expression instanceof UnaryExpression) {
            UnaryExpression unaryExpression = (UnaryExpression)expression;
            return unaryExpression.getExpr();
        }
        if (expression instanceof QuantifierExpression) {
            QuantifierExpression quantifierExpression = (QuantifierExpression)expression;
            return quantifierExpression.getSubformula();
        }
        throw new UnsupportedOperationException();
    }

    public Iterator<Expression> getOperands(Expression expression) {
        if (expression instanceof UnaryExpression) {
            UnaryExpression unaryExpression = (UnaryExpression)expression;
            ArrayList<Expression> arrayList = new ArrayList<Expression>(1);
            arrayList.add(unaryExpression.getExpr());
            return arrayList.iterator();
        }
        if (expression instanceof BinaryExpression) {
            return BoogieExpressionTransformer.getOperands((BinaryExpression)expression).iterator();
        }
        if (expression instanceof QuantifierExpression) {
            QuantifierExpression quantifierExpression = (QuantifierExpression)expression;
            ArrayList<Expression> arrayList = new ArrayList<Expression>(1);
            arrayList.add(quantifierExpression.getSubformula());
            return arrayList.iterator();
        }
        throw new UnsupportedOperationException();
    }

    private static Collection<Expression> getOperands(BinaryExpression binaryExpression) {
        ArrayDeque<Expression> arrayDeque = new ArrayDeque<Expression>();
        LinkedHashSet<Expression> linkedHashSet = new LinkedHashSet<Expression>();
        arrayDeque.add(binaryExpression.getLeft());
        arrayDeque.add(binaryExpression.getRight());
        BinaryExpression.Operator operator = binaryExpression.getOperator();
        while (!arrayDeque.isEmpty()) {
            BinaryExpression binaryExpression2;
            Expression expression = (Expression)((Object)arrayDeque.removeLast());
            if (expression instanceof BinaryExpression && (binaryExpression2 = (BinaryExpression)expression).getOperator() == operator) {
                arrayDeque.add(binaryExpression2.getLeft());
                arrayDeque.add(binaryExpression2.getRight());
                continue;
            }
            linkedHashSet.add(expression);
        }
        return linkedHashSet;
    }

    public boolean isAtom(Expression expression) {
        return !this.isNot(expression) && !this.isAnd(expression) && !this.isOr(expression) && !this.isForall(expression) && !this.isExists(expression);
    }

    public boolean isNot(Expression expression) {
        if (expression instanceof UnaryExpression) {
            UnaryExpression unaryExpression = (UnaryExpression)expression;
            return unaryExpression.getOperator() == UnaryExpression.Operator.LOGICNEG;
        }
        return false;
    }

    public boolean isAnd(Expression expression) {
        if (expression instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            return binaryExpression.getOperator() == BinaryExpression.Operator.LOGICAND;
        }
        return false;
    }

    public boolean isOr(Expression expression) {
        if (expression instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            return binaryExpression.getOperator() == BinaryExpression.Operator.LOGICOR;
        }
        return false;
    }

    public boolean isExists(Expression expression) {
        return expression instanceof QuantifierExpression && !((QuantifierExpression)expression).isUniversal();
    }

    public boolean isForall(Expression expression) {
        return expression instanceof QuantifierExpression && ((QuantifierExpression)expression).isUniversal();
    }

    public Expression changeForall(Expression expression, Expression expression2) {
        QuantifierExpression quantifierExpression = (QuantifierExpression)expression;
        return new QuantifierExpression(expression2.getLocation(), true, quantifierExpression.getTypeParams(), quantifierExpression.getParameters(), quantifierExpression.getAttributes(), expression2);
    }

    public Expression changeExists(Expression expression, Expression expression2) {
        QuantifierExpression quantifierExpression = (QuantifierExpression)expression;
        return new QuantifierExpression(expression2.getLocation(), false, quantifierExpression.getTypeParams(), quantifierExpression.getParameters(), quantifierExpression.getAttributes(), expression2);
    }

    public boolean isEqual(Expression expression, Expression expression2) {
        if (expression == null || expression2 == null) {
            return false;
        }
        if (((Object)((Object)expression)).getClass().equals(((Object)((Object)expression2)).getClass()) && expression instanceof BooleanLiteral) {
            return ((BooleanLiteral)expression).getValue() == ((BooleanLiteral)expression2).getValue();
        }
        return ((Object)((Object)expression)).equals((Object)expression2);
    }

    public Expression rewritePredNotEquals(Expression expression) {
        if (expression instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            if (binaryExpression.getOperator() != BinaryExpression.Operator.COMPNEQ) {
                return expression;
            }
            IBoogieType iBoogieType = binaryExpression.getLeft().getType();
            if (!BoogieExpressionTransformer.isAnyPrimitiveType(iBoogieType) || BoogieExpressionTransformer.isPrimitiveType(iBoogieType, BoogieType.TYPE_BOOL)) {
                return expression;
            }
            BinaryExpression binaryExpression2 = new BinaryExpression(expression.getLocation(), BoogieType.TYPE_BOOL, BinaryExpression.Operator.COMPLT, binaryExpression.getLeft(), binaryExpression.getRight());
            BinaryExpression binaryExpression3 = new BinaryExpression(expression.getLocation(), BoogieType.TYPE_BOOL, BinaryExpression.Operator.COMPGT, binaryExpression.getLeft(), binaryExpression.getRight());
            return new BinaryExpression(expression.getLocation(), BoogieType.TYPE_BOOL, BinaryExpression.Operator.LOGICOR, binaryExpression2, binaryExpression3);
        }
        return expression;
    }

    public Expression negatePred(Expression expression) {
        if (expression instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            BinaryExpression.Operator operator = switch (binaryExpression.getOperator()) {
                case BinaryExpression.Operator.BITVECCONCAT, BinaryExpression.Operator.ARITHPLUS, BinaryExpression.Operator.ARITHMINUS, BinaryExpression.Operator.ARITHMUL, BinaryExpression.Operator.ARITHDIV, BinaryExpression.Operator.ARITHMOD -> throw new UnsupportedOperationException("Cannot negate non-boolean terms");
                case BinaryExpression.Operator.LOGICIFF, BinaryExpression.Operator.LOGICIMPLIES, BinaryExpression.Operator.LOGICAND, BinaryExpression.Operator.LOGICOR -> throw new UnsupportedOperationException(BoogiePrettyPrinter.print(expression) + " is no predicate");
                case BinaryExpression.Operator.COMPPO -> throw new UnsupportedOperationException("Dont know how to negate partial order");
                case BinaryExpression.Operator.COMPEQ -> BinaryExpression.Operator.COMPNEQ;
                case BinaryExpression.Operator.COMPGEQ -> BinaryExpression.Operator.COMPLT;
                case BinaryExpression.Operator.COMPGT -> BinaryExpression.Operator.COMPLEQ;
                case BinaryExpression.Operator.COMPLEQ -> BinaryExpression.Operator.COMPGT;
                case BinaryExpression.Operator.COMPLT -> BinaryExpression.Operator.COMPGEQ;
                case BinaryExpression.Operator.COMPNEQ -> BinaryExpression.Operator.COMPEQ;
                default -> throw new MatchException(null, null);
            };
            return new BinaryExpression(expression.getLocation(), BoogieType.TYPE_BOOL, operator, binaryExpression.getLeft(), binaryExpression.getRight());
        }
        if (expression instanceof BooleanLiteral) {
            BooleanLiteral booleanLiteral = (BooleanLiteral)expression;
            return new BooleanLiteral(booleanLiteral.getLocation(), BoogieType.TYPE_BOOL, !booleanLiteral.getValue());
        }
        if (expression instanceof UnaryExpression) {
            UnaryExpression unaryExpression = (UnaryExpression)expression;
            switch (unaryExpression.getOperator()) {
                case ARITHNEGATIVE: {
                    throw new UnsupportedOperationException("Cannot negate non-boolean terms");
                }
                case LOGICNEG: {
                    break;
                }
                case OLD: {
                    throw new UnsupportedOperationException(BoogiePrettyPrinter.print(expression) + " is no predicate");
                }
                default: {
                    throw new MatchException(null, null);
                }
            }
            return unaryExpression.getExpr();
        }
        throw new UnsupportedOperationException("Cannot negate " + BoogiePrettyPrinter.print(expression));
    }

    public boolean isLiteral(Expression expression) {
        if (expression instanceof IdentifierExpression || expression instanceof BooleanLiteral || expression instanceof ArrayAccessExpression || expression instanceof ArrayStoreExpression || expression instanceof FunctionApplication) {
            return true;
        }
        if (expression instanceof UnaryExpression) {
            UnaryExpression unaryExpression = (UnaryExpression)expression;
            Expression expression2 = unaryExpression.getExpr();
            return unaryExpression.getOperator() == UnaryExpression.Operator.LOGICNEG && (expression2 instanceof IdentifierExpression || expression2 instanceof ArrayAccessExpression || expression2 instanceof ArrayStoreExpression || expression2 instanceof FunctionApplication);
        }
        return false;
    }

    private static boolean isPrimitiveType(IBoogieType iBoogieType, BoogiePrimitiveType boogiePrimitiveType) {
        if (iBoogieType instanceof BoogiePrimitiveType) {
            return ((BoogiePrimitiveType)iBoogieType).getTypeCode() == boogiePrimitiveType.getTypeCode();
        }
        if (iBoogieType instanceof BoogieConstructedType) {
            BoogieConstructedType boogieConstructedType = (BoogieConstructedType)iBoogieType;
            if (boogieConstructedType.getUnderlyingType() instanceof BoogieConstructedType) {
                return false;
            }
            if (boogieConstructedType.getUnderlyingType() == boogieConstructedType) {
                return false;
            }
            return BoogieExpressionTransformer.isPrimitiveType(boogieConstructedType.getUnderlyingType(), boogiePrimitiveType);
        }
        return false;
    }

    private static boolean isAnyPrimitiveType(IBoogieType iBoogieType) {
        if (iBoogieType == null) {
            throw new IllegalArgumentException("type is null");
        }
        if (iBoogieType instanceof BoogiePrimitiveType) {
            return true;
        }
        if (iBoogieType instanceof BoogieConstructedType) {
            BoogieConstructedType boogieConstructedType = (BoogieConstructedType)iBoogieType;
            if (boogieConstructedType.getUnderlyingType() instanceof BoogieConstructedType) {
                return false;
            }
            if (boogieConstructedType.getUnderlyingType() == boogieConstructedType) {
                return false;
            }
            return BoogieExpressionTransformer.isAnyPrimitiveType(boogieConstructedType.getUnderlyingType());
        }
        return false;
    }

    public boolean isTrue(Expression expression) {
        return expression instanceof BooleanLiteral && ((BooleanLiteral)expression).getValue();
    }

    public boolean isFalse(Expression expression) {
        return expression instanceof BooleanLiteral && !((BooleanLiteral)expression).getValue();
    }
}

