/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.ast;

import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstVisitor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.List;
import java.util.function.Predicate;

public final class StructLHS
extends LeftHandSide {
    private static final long serialVersionUID = 1L;
    private static final Predicate<BoogieASTNode> VALIDATOR = BoogieASTNode.VALIDATORS.get(StructLHS.class);
    LeftHandSide struct;
    String field;

    public StructLHS(ILocation iLocation, LeftHandSide leftHandSide, String string) {
        super(iLocation);
        this.struct = leftHandSide;
        this.field = string;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid StructLHS: " + String.valueOf((Object)this);
    }

    public StructLHS(ILocation iLocation, IBoogieType iBoogieType, LeftHandSide leftHandSide, String string) {
        super(iLocation, iBoogieType);
        this.struct = leftHandSide;
        this.field = string;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid StructLHS: " + String.valueOf((Object)this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("StructLHS").append('[');
        stringBuffer.append((Object)this.struct);
        stringBuffer.append(',').append(this.field);
        return stringBuffer.append(']').toString();
    }

    public LeftHandSide getStruct() {
        return this.struct;
    }

    public String getField() {
        return this.field;
    }

    @Override
    public List<BoogieASTNode> getOutgoingNodes() {
        List<BoogieASTNode> list = super.getOutgoingNodes();
        list.add(this.struct);
        return list;
    }

    @Override
    public void accept(GeneratedBoogieAstVisitor generatedBoogieAstVisitor) {
        if (!generatedBoogieAstVisitor.visit((LeftHandSide)this)) {
            return;
        }
        if (generatedBoogieAstVisitor.visit(this) && this.struct != null) {
            this.struct.accept(generatedBoogieAstVisitor);
        }
    }

    @Override
    public LeftHandSide accept(GeneratedBoogieAstTransformer generatedBoogieAstTransformer) {
        LeftHandSide leftHandSide = generatedBoogieAstTransformer.transform(this);
        if (leftHandSide != this) {
            return leftHandSide;
        }
        LeftHandSide leftHandSide2 = null;
        if (this.struct != null) {
            leftHandSide2 = this.struct.accept(generatedBoogieAstTransformer);
        }
        if (this.struct != leftHandSide2) {
            return new StructLHS(this.loc, this.type, leftHandSide2, this.field);
        }
        return this;
    }
}

