/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.convert;

import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.IProofTracker;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofConstants;
import java.util.LinkedHashSet;

public class LogicSimplifier {
    private final IProofTracker mTracker;

    public LogicSimplifier(IProofTracker iProofTracker) {
        this.mTracker = iProofTracker;
    }

    public Term convertNot(Term term) {
        ApplicationTerm applicationTerm = (ApplicationTerm)this.mTracker.getProvedTerm(term);
        assert (applicationTerm.getFunction().getName() == "not");
        Theory theory = applicationTerm.getTheory();
        Term term2 = applicationTerm.getParameters()[0];
        if (term2 == theory.mFalse) {
            Term term3 = this.mTracker.buildRewrite((Term)applicationTerm, (Term)theory.mTrue, ProofConstants.RW_NOT_SIMP);
            return this.mTracker.transitivity(term, term3);
        }
        if (term2 == theory.mTrue) {
            Term term4 = this.mTracker.buildRewrite((Term)applicationTerm, (Term)theory.mFalse, ProofConstants.RW_NOT_SIMP);
            return this.mTracker.transitivity(term, term4);
        }
        return term;
    }

    public Term convertOr(Term term) {
        Term term2;
        ApplicationTerm applicationTerm = (ApplicationTerm)this.mTracker.getProvedTerm(term);
        assert (applicationTerm.getFunction().getName() == "or");
        Term[] termArray = applicationTerm.getParameters();
        LinkedHashSet<Term> linkedHashSet = new LinkedHashSet<Term>();
        Theory theory = termArray[0].getTheory();
        ApplicationTerm applicationTerm2 = theory.mTrue;
        ApplicationTerm applicationTerm3 = theory.mFalse;
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            term2 = termArray2[n2];
            if (term2 == applicationTerm2) {
                return this.mTracker.transitivity(term, this.mTracker.buildRewrite((Term)applicationTerm, (Term)applicationTerm2, ProofConstants.RW_OR_TAUT));
            }
            if (term2 != applicationTerm3) {
                if (linkedHashSet.contains(theory.not(term2))) {
                    return this.mTracker.transitivity(term, this.mTracker.buildRewrite((Term)applicationTerm, (Term)applicationTerm2, ProofConstants.RW_OR_TAUT));
                }
                linkedHashSet.add(term2);
            }
            ++n2;
        }
        if (linkedHashSet.isEmpty()) {
            return this.mTracker.transitivity(term, this.mTracker.buildRewrite((Term)applicationTerm, (Term)applicationTerm3, ProofConstants.RW_OR_SIMP));
        }
        if (linkedHashSet.size() == 1) {
            term2 = (Term)linkedHashSet.iterator().next();
            return this.mTracker.transitivity(term, this.mTracker.buildRewrite((Term)applicationTerm, term2, ProofConstants.RW_OR_SIMP));
        }
        if (linkedHashSet.size() == termArray.length) {
            return term;
        }
        term2 = theory.term(theory.mOr, linkedHashSet.toArray(new Term[linkedHashSet.size()]));
        return this.mTracker.transitivity(term, this.mTracker.buildRewrite((Term)applicationTerm, term2, ProofConstants.RW_OR_SIMP));
    }

    public Term convertLeq0(Term term) {
        ApplicationTerm applicationTerm = (ApplicationTerm)this.mTracker.getProvedTerm(term);
        assert (applicationTerm.getFunction().getName() == "<=");
        assert (applicationTerm.getParameters()[1] == Rational.ZERO.toTerm(applicationTerm.getParameters()[0].getSort()));
        Term term2 = applicationTerm.getParameters()[0];
        if (term2 instanceof ConstantTerm) {
            Rational rational = (Rational)((ConstantTerm)term2).getValue();
            Theory theory = term2.getTheory();
            if (rational.compareTo(Rational.ZERO) > 0) {
                return this.mTracker.transitivity(term, this.mTracker.buildRewrite((Term)applicationTerm, (Term)theory.mFalse, ProofConstants.RW_LEQ_FALSE));
            }
            return this.mTracker.transitivity(term, this.mTracker.buildRewrite((Term)applicationTerm, (Term)theory.mTrue, ProofConstants.RW_LEQ_TRUE));
        }
        return term;
    }

    public Term convertIte(Term term) {
        ApplicationTerm applicationTerm = (ApplicationTerm)this.mTracker.getProvedTerm(term);
        assert (applicationTerm.getFunction().getName() == "ite");
        Term term2 = applicationTerm.getParameters()[0];
        Term term3 = applicationTerm.getParameters()[1];
        Term term4 = applicationTerm.getParameters()[2];
        Theory theory = term2.getTheory();
        if (term2 == theory.mTrue) {
            return this.mTracker.transitivity(term, this.mTracker.buildRewrite((Term)applicationTerm, term3, ProofConstants.RW_ITE_TRUE));
        }
        if (term2 == theory.mFalse) {
            return this.mTracker.transitivity(term, this.mTracker.buildRewrite((Term)applicationTerm, term4, ProofConstants.RW_ITE_FALSE));
        }
        if (term3 == term4) {
            return this.mTracker.transitivity(term, this.mTracker.buildRewrite((Term)applicationTerm, term3, ProofConstants.RW_ITE_SAME));
        }
        if (term3 == theory.mTrue && term4 == theory.mFalse) {
            return this.mTracker.transitivity(term, this.mTracker.buildRewrite((Term)applicationTerm, term2, ProofConstants.RW_ITE_BOOL_1));
        }
        if (term3 == theory.mFalse && term4 == theory.mTrue) {
            Term term5 = this.mTracker.transitivity(term, this.mTracker.buildRewrite((Term)applicationTerm, theory.term("not", new Term[]{term2}), ProofConstants.RW_ITE_BOOL_2));
            return this.convertNot(term5);
        }
        if (term3 == theory.mTrue) {
            Term term6 = this.mTracker.transitivity(term, this.mTracker.buildRewrite((Term)applicationTerm, theory.term("or", new Term[]{term2, term4}), ProofConstants.RW_ITE_BOOL_3));
            return this.convertOr(term6);
        }
        if (term3 == theory.mFalse) {
            Term term7 = theory.term("not", new Term[]{theory.term("or", new Term[]{term2, theory.term("not", new Term[]{term4})})});
            Term term8 = this.mTracker.transitivity(term, this.mTracker.buildRewrite((Term)applicationTerm, term7, ProofConstants.RW_ITE_BOOL_4));
            return this.convertNotOrNot(term8);
        }
        if (term4 == theory.mTrue) {
            Term term9 = theory.term("or", new Term[]{theory.term("not", new Term[]{term2}), term3});
            Term term10 = this.mTracker.transitivity(term, this.mTracker.buildRewrite((Term)applicationTerm, term9, ProofConstants.RW_ITE_BOOL_5));
            return this.convertOrNot(term10);
        }
        if (term4 == theory.mFalse) {
            Term term11 = theory.term("not", new Term[]{theory.term("or", new Term[]{theory.term("not", new Term[]{term2}), theory.term("not", new Term[]{term3})})});
            Term term12 = this.mTracker.transitivity(term, this.mTracker.buildRewrite((Term)applicationTerm, term11, ProofConstants.RW_ITE_BOOL_6));
            return this.convertNotOrNot(term12);
        }
        return term;
    }

    public Term convertBinaryEq(Term term) {
        ApplicationTerm applicationTerm;
        Term term2;
        ApplicationTerm applicationTerm2 = (ApplicationTerm)this.mTracker.getProvedTerm(term);
        assert (applicationTerm2.getFunction().getName() == "=");
        Term term3 = applicationTerm2.getParameters();
        assert (((Term[])term3).length == 2) : "Non-binary equality in makeBinaryEq";
        Theory theory = term.getTheory();
        while (term3[0].getSort().isArraySort()) {
            term2 = this.checkStoreRewrite((Term[])term3);
            if (term2 == null) break;
            applicationTerm = (ApplicationTerm)theory.term("=", (Term[])term2);
            Term term4 = this.mTracker.buildRewrite((Term)applicationTerm2, (Term)applicationTerm, ProofConstants.RW_STORE_REWRITE);
            term = this.mTracker.transitivity(term, term4);
            applicationTerm2 = applicationTerm;
            term3 = term2;
        }
        if (term3[0].getSort().equals(theory.getBooleanSort())) {
            term2 = theory.term("xor", (Term[])term3);
            applicationTerm = this.mTracker.buildRewrite((Term)applicationTerm2, theory.term("not", new Term[]{term2}), ProofConstants.RW_EQ_TO_XOR);
            applicationTerm = this.mTracker.congruence((Term)applicationTerm, new Term[]{this.convertXor(this.mTracker.reflexivity(term2))});
            return this.convertNot(this.mTracker.transitivity(term, (Term)applicationTerm));
        }
        return term;
    }

    private Term[] checkStoreRewrite(Term[] termArray) {
        assert (termArray.length == 2);
        int n = 0;
        while (n < 2) {
            ApplicationTerm applicationTerm;
            Term[] termArray2;
            if (this.isStore(termArray[n]) && termArray[1 - n] == (termArray2 = (applicationTerm = (ApplicationTerm)termArray[n]).getParameters())[0]) {
                Theory theory = termArray2[0].getTheory();
                return new Term[]{theory.term("select", new Term[]{termArray2[0], termArray2[1]}), termArray2[2]};
            }
            ++n;
        }
        return null;
    }

    public Term convertEq(Term term) {
        Term[] termArray;
        Term[] termArray2 = (Term[])this.mTracker.getProvedTerm(term);
        assert (termArray2.getFunction().getName() == "=");
        Theory theory = term.getTheory();
        Term term2 = termArray2.getParameters();
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        if (term2[0].getSort().isNumericSort()) {
            Term term3 = null;
            Term term4 = term2;
            int n = ((Term[])term4).length;
            int n2 = 0;
            while (n2 < n) {
                termArray = term4[n2];
                if (termArray instanceof ConstantTerm) {
                    var11_29 = (Term)((ConstantTerm)termArray).getValue();
                    if (term3 == null) {
                        term3 = var11_29;
                    } else if (!term3.equals((Object)var11_29)) {
                        return this.mTracker.transitivity(term, this.mTracker.buildRewrite((Term)termArray2, (Term)theory.mFalse, ProofConstants.RW_CONST_DIFF));
                    }
                }
                linkedHashSet.add(termArray);
                ++n2;
            }
        } else if (term2[0].getSort() == theory.getBooleanSort()) {
            Rational rational;
            boolean bl = false;
            boolean bl2 = false;
            var11_29 = term2;
            int n = ((Term[])var11_29).length;
            int n3 = 0;
            while (n3 < n) {
                rational = var11_29[n3];
                if (rational == theory.mTrue) {
                    bl = true;
                } else if (rational == theory.mFalse) {
                    bl2 = true;
                } else {
                    linkedHashSet.add(rational);
                }
                ++n3;
            }
            if (bl && bl2) {
                return this.mTracker.transitivity(term, this.mTracker.buildRewrite((Term)termArray2, (Term)theory.mFalse, ProofConstants.RW_TRUE_NOT_FALSE));
            }
            if (bl || bl2) {
                if (linkedHashSet.isEmpty()) {
                    return this.mTracker.transitivity(term, this.mTracker.buildRewrite((Term)termArray2, (Term)theory.mTrue, ProofConstants.RW_EQ_SAME));
                }
                rational = bl ? ProofConstants.RW_EQ_TRUE : ProofConstants.RW_EQ_FALSE;
                Term[] termArray3 = linkedHashSet.toArray(new Term[linkedHashSet.size()]);
                if (termArray3.length == 1) {
                    Term term5 = termArray3[0];
                    if (bl2) {
                        term5 = theory.term("not", new Term[]{term5});
                    }
                    var11_29 = this.mTracker.transitivity(term, this.mTracker.buildRewrite((Term)termArray2, term5, (Annotation)rational));
                    if (bl2) {
                        var11_29 = this.convertNot(var11_29);
                    }
                    return var11_29;
                }
                if (bl) {
                    int n4 = 0;
                    while (n4 < termArray3.length) {
                        termArray3[n4] = theory.term("not", new Term[]{termArray3[n4]});
                        ++n4;
                    }
                }
                Term term6 = theory.term("not", new Term[]{theory.term("or", termArray3)});
                return this.convertNotOrNot(this.mTracker.transitivity(term, this.mTracker.buildRewrite((Term)termArray2, term6, (Annotation)rational)));
            }
        } else {
            Term term7 = term2;
            int n = ((Term[])term7).length;
            int n5 = 0;
            while (n5 < n) {
                Term term8 = term7[n5];
                linkedHashSet.add(term8);
                ++n5;
            }
        }
        if (linkedHashSet.size() == 1) {
            return this.mTracker.transitivity(term, this.mTracker.buildRewrite((Term)termArray2, (Term)theory.mTrue, ProofConstants.RW_EQ_SAME));
        }
        if (linkedHashSet.size() != ((Term[])term2).length) {
            Term term9 = linkedHashSet.toArray(new Term[linkedHashSet.size()]);
            termArray = (ApplicationTerm)theory.term("=", (Term[])term9);
            term = this.mTracker.transitivity(term, this.mTracker.buildRewrite((Term)termArray2, (Term)termArray, ProofConstants.RW_EQ_SIMP));
            termArray2 = termArray;
            term2 = term9;
        }
        if (((Term[])term2).length == 2) {
            return this.convertBinaryEq(term);
        }
        Term[] termArray4 = new Term[((Rational)term2).length - 1];
        termArray = new Term[((Rational)term2).length - 1];
        int n = 0;
        while (n < termArray4.length) {
            Term term10 = theory.term("=", new Term[]{term2[n], term2[n + 1]});
            termArray4[n] = theory.term("not", new Term[]{term10});
            termArray[n] = this.convertNot(this.mTracker.congruence(this.mTracker.reflexivity(termArray4[n]), new Term[]{this.convertBinaryEq(this.mTracker.reflexivity(term10))}));
            ++n;
        }
        Term term11 = theory.term("or", termArray4);
        Term term12 = theory.term("not", new Term[]{term11});
        return this.mTracker.congruence(this.mTracker.transitivity(term, this.mTracker.buildRewrite((Term)termArray2, term12, ProofConstants.RW_EQ_BINARY)), new Term[]{this.mTracker.congruence(this.mTracker.reflexivity(term11), termArray)});
    }

    private boolean isStore(Term term) {
        if (term instanceof ApplicationTerm) {
            FunctionSymbol functionSymbol = ((ApplicationTerm)term).getFunction();
            return functionSymbol.isIntern() && functionSymbol.getName().equals("store");
        }
        return false;
    }

    public Term convertDistinct(Term term) {
        Term term2;
        ApplicationTerm applicationTerm = (ApplicationTerm)this.mTracker.getProvedTerm(term);
        assert (applicationTerm.getFunction().getName() == "distinct");
        Term[] termArray = applicationTerm.getParameters();
        Theory theory = term.getTheory();
        if (termArray[0].getSort() == theory.getBooleanSort()) {
            if (termArray.length > 2) {
                return this.mTracker.transitivity(term, this.mTracker.buildRewrite((Term)applicationTerm, (Term)theory.mFalse, ProofConstants.RW_DISTINCT_BOOL));
            }
            Term term3 = this.mTracker.transitivity(term, this.mTracker.buildRewrite((Term)applicationTerm, theory.term("xor", termArray), ProofConstants.RW_DISTINCT_TO_XOR));
            return this.convertXor(term3);
        }
        LinkedHashSet<Term> linkedHashSet = new LinkedHashSet<Term>();
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            term2 = termArray2[n2];
            if (!linkedHashSet.add(term2)) {
                return this.mTracker.transitivity(term, this.mTracker.buildRewrite((Term)applicationTerm, (Term)theory.mFalse, ProofConstants.RW_DISTINCT_SAME));
            }
            ++n2;
        }
        linkedHashSet = null;
        if (termArray.length == 2) {
            term2 = theory.term("not", new Term[]{theory.term("=", termArray)});
            return this.mTracker.transitivity(term, this.mTracker.buildRewrite((Term)applicationTerm, term2, ProofConstants.RW_DISTINCT_BINARY));
        }
        term2 = new Term[termArray.length * (termArray.length - 1) / 2];
        n2 = 0;
        n = 0;
        while (n < termArray.length - 1) {
            int n3 = n + 1;
            while (n3 < termArray.length) {
                term2[n2++] = theory.term("=", new Term[]{termArray[n], termArray[n3]});
                ++n3;
            }
            ++n;
        }
        Term term4 = theory.term("not", new Term[]{theory.term("or", (Term[])term2)});
        return this.mTracker.transitivity(term, this.mTracker.buildRewrite((Term)applicationTerm, term4, ProofConstants.RW_DISTINCT_BINARY));
    }

    public static boolean isNegation(Term term) {
        if (term instanceof ApplicationTerm) {
            return ((ApplicationTerm)term).getFunction() == term.getTheory().mNot;
        }
        return false;
    }

    public Term convertFuncNot(Term term) {
        ApplicationTerm applicationTerm = (ApplicationTerm)this.mTracker.getProvedTerm(term);
        Term[] termArray = applicationTerm.getParameters();
        Term[] termArray2 = new Term[termArray.length];
        int n = 0;
        while (n < termArray.length) {
            termArray2[n] = this.mTracker.reflexivity(termArray[n]);
            if (termArray[n] instanceof ApplicationTerm && ((ApplicationTerm)termArray[n]).getFunction().getName() == "not") {
                termArray2[n] = this.convertNot(termArray2[n]);
            }
            ++n;
        }
        return this.mTracker.congruence(term, termArray2);
    }

    public Term convertOrNot(Term term) {
        return this.convertOr(this.convertFuncNot(term));
    }

    public Term convertNotOrNot(Term term) {
        ApplicationTerm applicationTerm = (ApplicationTerm)this.mTracker.getProvedTerm(term);
        assert (applicationTerm.getFunction().getName() == "not");
        ApplicationTerm applicationTerm2 = (ApplicationTerm)applicationTerm.getParameters()[0];
        Term term2 = this.convertOrNot(this.mTracker.reflexivity((Term)applicationTerm2));
        return this.convertNot(this.mTracker.congruence(term, new Term[]{term2}));
    }

    public Term convertAnd(Term term) {
        return term;
    }

    public Term convertXor(Term term) {
        Term term2;
        Term term3 = this.mTracker.getProvedTerm(term);
        assert (((ApplicationTerm)term3).getFunction().getName() == "xor");
        Term[] termArray = ((ApplicationTerm)term3).getParameters();
        Theory theory = term.getTheory();
        assert (termArray.length == 2);
        if (termArray[0] == theory.mFalse) {
            return this.mTracker.transitivity(term, this.mTracker.buildRewrite(term3, termArray[1], ProofConstants.RW_XOR_FALSE));
        }
        if (termArray[1] == theory.mFalse) {
            return this.mTracker.transitivity(term, this.mTracker.buildRewrite(term3, termArray[0], ProofConstants.RW_XOR_FALSE));
        }
        if (termArray[0] == theory.mTrue) {
            Term term4 = this.mTracker.transitivity(term, this.mTracker.buildRewrite(term3, theory.term("not", new Term[]{termArray[1]}), ProofConstants.RW_XOR_TRUE));
            return this.convertNot(term4);
        }
        if (termArray[1] == theory.mTrue) {
            Term term5 = this.mTracker.transitivity(term, this.mTracker.buildRewrite(term3, theory.term("not", new Term[]{termArray[0]}), ProofConstants.RW_XOR_TRUE));
            return this.convertNot(term5);
        }
        Term[] termArray2 = (Term[])termArray.clone();
        int n = 0;
        int n2 = 0;
        while (n2 < termArray.length) {
            term2 = termArray[n2];
            while (LogicSimplifier.isNegation(term2)) {
                term2 = ((ApplicationTerm)term2).getParameters()[0];
                ++n;
            }
            termArray2[n2] = term2;
            ++n2;
        }
        Term term6 = term;
        if (n > 0) {
            term2 = theory.term("xor", termArray2);
            Term term7 = n % 2 == 1 ? theory.term("not", new Term[]{term2}) : term2;
            term6 = this.mTracker.transitivity(term, this.mTracker.buildRewrite(term3, term7, ProofConstants.RW_XOR_NOT));
            term3 = term2;
        }
        if (termArray2[0] == termArray2[1]) {
            term2 = this.mTracker.buildRewrite(term3, theory.term("false", new Term[0]), ProofConstants.RW_XOR_SAME);
            term6 = n % 2 == 1 ? this.convertNot(this.mTracker.congruence(term6, new Term[]{term2})) : this.mTracker.transitivity(term6, term2);
        }
        return term6;
    }

    public Term convertImplies(Term term) {
        return term;
    }
}

