/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.option;

import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.Option;

public class DoubleOption
extends Option {
    double mValue;
    double mDefaultValue;

    public DoubleOption(double d, boolean bl, String string) {
        super(bl, string);
        this.mValue = this.mDefaultValue = d;
    }

    public DoubleOption(DoubleOption doubleOption) {
        super(doubleOption.isOnlineModifiable(), doubleOption.getDescription());
        this.mValue = doubleOption.mValue;
        this.mDefaultValue = doubleOption.mDefaultValue;
    }

    @Override
    public Option copy() {
        return new DoubleOption(this);
    }

    @Override
    public void set(Object object) {
        if (object instanceof Number) {
            this.mValue = ((Number)object).doubleValue();
        } else if (object instanceof String) {
            try {
                this.mValue = Double.parseDouble((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SMTLIBException(numberFormatException.getMessage());
            }
        } else {
            throw new SMTLIBException("Not a number: " + String.valueOf(object));
        }
    }

    @Override
    public Object get() {
        return this.mValue;
    }

    @Override
    public void reset() {
        this.mValue = this.mDefaultValue;
    }

    @Override
    public Object defaultValue() {
        return this.mDefaultValue;
    }

    @Override
    public void started() {
        this.mDefaultValue = this.mValue;
    }
}

