/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.proof;

import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ResolutionNode;
import java.util.AbstractSet;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class PropProofChecker {
    private final ArrayDeque<Clause> mTodo = new ArrayDeque();
    private final HashSet<Clause> mVisited = new HashSet();

    public boolean check(Clause clause) {
        this.mTodo.add(clause);
        return this.run();
    }

    private boolean run() {
        int n = 0;
        while (!this.mTodo.isEmpty()) {
            Object object;
            Clause clause = this.mTodo.removeLast();
            if (this.mVisited.contains(clause)) continue;
            ProofNode proofNode = clause.getProof();
            if (proofNode.isLeaf()) {
                this.mVisited.add(clause);
                continue;
            }
            ResolutionNode.Antecedent[] antecedentArray = ((ResolutionNode)proofNode).getAntecedents();
            Clause clause2 = ((ResolutionNode)proofNode).getPrimary();
            boolean bl = false;
            if (!this.mVisited.contains(clause2)) {
                if (!bl) {
                    this.mTodo.addLast(clause);
                }
                bl = true;
                this.mTodo.addLast(clause2);
            }
            ResolutionNode.Antecedent[] antecedentArray2 = antecedentArray;
            int n2 = antecedentArray.length;
            int n3 = 0;
            while (n3 < n2) {
                object = antecedentArray2[n3];
                if (!this.mVisited.contains(((ResolutionNode.Antecedent)object).mAntecedent)) {
                    if (!bl) {
                        this.mTodo.addLast(clause);
                    }
                    bl = true;
                    this.mTodo.addLast(((ResolutionNode.Antecedent)object).mAntecedent);
                }
                ++n3;
            }
            if (bl) continue;
            object = new HashSet();
            n3 = 0;
            while (n3 < clause2.getSize()) {
                ((HashSet)object).add(clause2.getLiteral(n3));
                ++n3;
            }
            ResolutionNode.Antecedent[] antecedentArray3 = antecedentArray;
            int n4 = antecedentArray.length;
            n2 = 0;
            while (n2 < n4) {
                ResolutionNode.Antecedent antecedent = antecedentArray3[n2];
                Clause clause3 = antecedent.mAntecedent;
                if (!clause3.contains(antecedent.mPivot)) {
                    System.err.println("Pivot literal " + String.valueOf(antecedent.mPivot) + " not in antecedent");
                    return false;
                }
                if (!((HashSet)object).remove(antecedent.mPivot.negate())) {
                    System.err.println("Negated pivot literal " + String.valueOf(antecedent.mPivot.negate()) + " not in primary");
                    return false;
                }
                int n5 = 0;
                while (n5 < clause3.getSize()) {
                    Literal literal = clause3.getLiteral(n5);
                    if (literal != antecedent.mPivot) {
                        ((HashSet)object).add(literal);
                    }
                    ++n5;
                }
                ++n2;
            }
            HashSet<Literal> hashSet = new HashSet<Literal>();
            n2 = 0;
            while (n2 < clause.getSize()) {
                hashSet.add(clause.getLiteral(n2));
                ++n2;
            }
            if (!((AbstractSet)object).equals(hashSet)) {
                ++n;
                System.err.println("Result of resolution incorrect for: " + String.valueOf(clause));
                Set set = (Set)((HashSet)object).clone();
                set.removeAll(hashSet);
                if (!set.isEmpty()) {
                    System.err.println();
                    System.err.println("Result misses:");
                    System.err.println(set);
                }
                Set set2 = (Set)hashSet.clone();
                set2.removeAll((Collection<?>)object);
                if (!set2.isEmpty()) {
                    System.err.println();
                    System.err.println("Result additionally has:");
                    System.err.println(set2);
                }
            }
            this.mVisited.add(clause);
        }
        return n == 0;
    }
}

