/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cli.options;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.Option;

public final class CommandLineOptions {
    public static final String OPTION_NAME_TOOLCHAIN = "tc";
    public static final String OPTION_LONG_NAME_TOOLCHAIN = "toolchain";
    public static final String OPTION_NAME_INPUTFILES = "i";
    public static final String OPTION_LONG_NAME_INPUTFILES = "input";
    public static final String OPTION_NAME_SETTINGS = "s";
    public static final String OPTION_LONG_NAME_SETTINGS = "settings";
    public static final String OPTION_NAME_HELP = "h";
    public static final String OPTION_LONG_NAME_VERSION = "version";
    public static final String OPTION_LONG_NAME_EXPERIMENTAL = "experimental";
    public static final String OPTION_LONG_NAME_CSV_DIR = "csv-dir";
    public static final String OPTION_LONG_NAME_GENERATE_CSV = "generate-csv";
    public static final String OPTION_LONG_NAME_FRONTEND_JSON_FROM_DEFAULTS = "generate-frontend-json-from-defaults";
    public static final String OPTION_LONG_NAME_BACKEND_WHITELIST_JSON_FROM_DEFAULTS = "generate-backend-json-from-defaults";
    public static final String OPTION_LONG_NAME_FRONTEND_JSON_FROM_DELTA = "generate-frontend-json-from-delta";
    public static final String OPTION_LONG_NAME_BACKEND_WHITELIST_JSON_FROM_DELTA = "generate-backend-json-from-delta";

    private CommandLineOptions() {
    }

    public static List<Option> createCliControllerOptions() {
        return CommandLineOptions.createCliControllerOptions(true, true);
    }

    public static List<Option> createCliControllerOptions(boolean bl, boolean bl2) {
        ArrayList<Option> arrayList = new ArrayList<Option>();
        arrayList.add(Option.builder((String)OPTION_NAME_TOOLCHAIN).longOpt(OPTION_LONG_NAME_TOOLCHAIN).type(File.class).hasArg().required(bl).argName("FILE").desc("Specify the path to an Ultimate toolchain file. Depending on the toolchain, you may have more options.").build());
        arrayList.add(Option.builder((String)OPTION_NAME_INPUTFILES).longOpt(OPTION_LONG_NAME_INPUTFILES).hasArgs().required(bl2).argName("FILE").build());
        arrayList.add(Option.builder((String)OPTION_NAME_SETTINGS).longOpt(OPTION_LONG_NAME_SETTINGS).type(File.class).hasArg().argName("FILE").build());
        arrayList.add(Option.builder().longOpt(OPTION_LONG_NAME_GENERATE_CSV).type(Boolean.class).desc("Generate .csv files from Statistics results and dump them to a directory (the directory name is chosen based on the filenames of input, toolchain and settings). The .csv files will also contain four additional columns in the beginning for Toolchainfile, Settingsfile, Inputfile, Result").build());
        arrayList.add(Option.builder().longOpt(OPTION_LONG_NAME_CSV_DIR).type(File.class).desc("Specify the path to a directory where the generated .csv files should be stored.").hasArg().argName("DIR").build());
        arrayList.add(Option.builder((String)OPTION_NAME_HELP).longOpt("help").type(Boolean.class).build());
        arrayList.add(Option.builder().longOpt(OPTION_LONG_NAME_VERSION).type(Boolean.class).build());
        arrayList.add(Option.builder().longOpt(OPTION_LONG_NAME_EXPERIMENTAL).type(Boolean.class).desc("Also show experimental options (even if they do not have a description).").build());
        arrayList.add(Option.builder().longOpt(OPTION_LONG_NAME_FRONTEND_JSON_FROM_DEFAULTS).type(Boolean.class).desc("Generate JSON for web frontend 'frontend_settings' from Ultimate default settings.").build());
        arrayList.add(Option.builder().longOpt(OPTION_LONG_NAME_BACKEND_WHITELIST_JSON_FROM_DEFAULTS).type(Boolean.class).desc("Generate JSON for web backend whitelist from Ultimate default settings.").build());
        arrayList.add(Option.builder().longOpt(OPTION_LONG_NAME_FRONTEND_JSON_FROM_DELTA).type(Boolean.class).desc("Generate JSON for web frontend 'frontend_settings' for Ultimate settings that differ from their defaults.").build());
        arrayList.add(Option.builder().longOpt(OPTION_LONG_NAME_BACKEND_WHITELIST_JSON_FROM_DELTA).type(Boolean.class).desc("Generate JSON for web backend whitelist for Ultimate settings that differ from their defaults.").build());
        return arrayList;
    }
}

