/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates;

import de.uni_freiburg.informatik.ultimate.lassoranker.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearInequality;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.AffineFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.AffineFunctionGenerator;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.PiecewiseRankingFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.RankingFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates.RankingTemplate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class PiecewiseTemplate
extends RankingTemplate {
    public final int size;
    private static final String s_name_delta = "delta";
    private static final String s_name_function = "rank";
    private static final String s_name_pred = "pred";
    private Term mdelta;
    private final AffineFunctionGenerator[] mfgens;
    private final AffineFunctionGenerator[] mpgens;

    public PiecewiseTemplate(int n) {
        assert (n >= 2);
        this.size = n;
        this.mfgens = new AffineFunctionGenerator[this.size];
        this.mpgens = new AffineFunctionGenerator[this.size];
    }

    @Override
    protected void init() {
        this.mdelta = this.newDelta(s_name_delta);
        int n = 0;
        while (n < this.size) {
            this.mfgens[n] = new AffineFunctionGenerator(this.mScript, this.mVariables, s_name_function + n);
            this.mpgens[n] = new AffineFunctionGenerator(this.mScript, this.mVariables, s_name_pred + n);
            ++n;
        }
    }

    @Override
    public String getName() {
        return this.size + "-piece";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.size);
        stringBuilder.append("-piece template:\n");
        stringBuilder.append("   delta > 0\n");
        int n = 0;
        while (n < this.size) {
            int n2 = 0;
            while (n2 < this.size) {
                stringBuilder.append("/\\ ( g_" + n + "(x) < 0 \\/ ");
                stringBuilder.append("g_" + n2 + "(x') < 0 \\/ ");
                stringBuilder.append("f_" + n2 + "(x') < f_" + n + "(x) - delta )\n");
                ++n2;
            }
            ++n;
        }
        n = 0;
        while (n < this.size) {
            stringBuilder.append("/\\ f_" + n + "(x) > 0\n");
            ++n;
        }
        stringBuilder.append("/\\ ( ");
        n = 0;
        while (n < this.size) {
            stringBuilder.append("g_" + n + "(x) >= 0");
            if (n < this.size - 1) {
                stringBuilder.append(" \\/ ");
            }
            ++n;
        }
        stringBuilder.append(" )");
        return stringBuilder.toString();
    }

    @Override
    public List<List<LinearInequality>> getConstraints(Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2) {
        Serializable serializable;
        this.checkInitialized();
        ArrayList<List<LinearInequality>> arrayList = new ArrayList<List<LinearInequality>>();
        int n = 0;
        while (n < this.size) {
            int n2 = 0;
            while (n2 < this.size) {
                serializable = new ArrayList();
                LinearInequality linearInequality = this.mpgens[n].generate(map);
                linearInequality.negate();
                linearInequality.setStrict(true);
                linearInequality.mMotzkinCoefficient = n == n2 ? LinearInequality.PossibleMotzkinCoefficients.ZERO_AND_ONE : LinearInequality.PossibleMotzkinCoefficients.ANYTHING;
                serializable.add(linearInequality);
                LinearInequality linearInequality2 = this.mpgens[n2].generate(map2);
                linearInequality2.negate();
                linearInequality2.setStrict(true);
                linearInequality2.mMotzkinCoefficient = LinearInequality.PossibleMotzkinCoefficients.ANYTHING;
                serializable.add(linearInequality2);
                LinearInequality linearInequality3 = this.mfgens[n].generate(map);
                LinearInequality linearInequality4 = this.mfgens[n2].generate(map2);
                linearInequality4.negate();
                linearInequality3.add(linearInequality4);
                AffineTerm affineTerm = new AffineTerm(this.mdelta, Rational.MONE);
                linearInequality3.add(affineTerm);
                linearInequality3.setStrict(true);
                linearInequality3.mMotzkinCoefficient = LinearInequality.PossibleMotzkinCoefficients.ZERO_AND_ONE;
                serializable.add(linearInequality3);
                arrayList.add((List<LinearInequality>)((Object)serializable));
                ++n2;
            }
            ++n;
        }
        n = 0;
        while (n < this.size) {
            LinearInequality linearInequality = this.mfgens[n].generate(map);
            linearInequality.setStrict(true);
            linearInequality.mMotzkinCoefficient = LinearInequality.PossibleMotzkinCoefficients.ONE;
            arrayList.add(Collections.singletonList(linearInequality));
            ++n;
        }
        ArrayList<Serializable> arrayList2 = new ArrayList<Serializable>();
        int n3 = 0;
        while (n3 < this.size) {
            serializable = this.mpgens[n3].generate(map);
            ((LinearInequality)serializable).setStrict(false);
            ((LinearInequality)serializable).mMotzkinCoefficient = n3 == 0 ? LinearInequality.PossibleMotzkinCoefficients.ZERO_AND_ONE : LinearInequality.PossibleMotzkinCoefficients.ANYTHING;
            arrayList2.add(serializable);
            ++n3;
        }
        arrayList.add(arrayList2);
        return arrayList;
    }

    @Override
    public Collection<Term> getCoefficients() {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        arrayList.add(this.mdelta);
        int n = 0;
        while (n < this.size) {
            arrayList.addAll(this.mfgens[n].getCoefficients());
            arrayList.addAll(this.mpgens[n].getCoefficients());
            ++n;
        }
        return arrayList;
    }

    @Override
    public RankingFunction extractRankingFunction(Map<Term, Rational> map) throws SMTLIBException {
        Rational rational = this.mfgens[0].getGcd(map);
        int n = 1;
        while (n < this.size) {
            rational = rational.gcd(this.mfgens[n].getGcd(map));
            ++n;
        }
        AffineFunction[] affineFunctionArray = new AffineFunction[this.size];
        AffineFunction[] affineFunctionArray2 = new AffineFunction[this.size];
        int n2 = 0;
        while (n2 < this.size) {
            affineFunctionArray[n2] = this.mfgens[n2].extractAffineFunction(map, rational);
            affineFunctionArray2[n2] = this.mpgens[n2].extractAffineFunction(map);
            ++n2;
        }
        return new PiecewiseRankingFunction(affineFunctionArray, affineFunctionArray2);
    }

    @Override
    public List<String> getAnnotations() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < this.size) {
            int n2 = 0;
            while (n2 < this.size) {
                arrayList.add("transition from piece " + n + " to piece " + n2);
                ++n2;
            }
            ++n;
        }
        n = 0;
        while (n < this.size) {
            arrayList.add("rank f" + n + " is bounded");
            ++n;
        }
        arrayList.add("case split is exhaustive");
        return arrayList;
    }

    @Override
    public int getDegree() {
        assert (this.size > 0);
        return 2 * this.size * this.size - 1;
    }
}

