/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin.external;

import de.uni_freiburg.informatik.ultimate.core.coreplugin.UltimateCore;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.exceptions.LifecycleException;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.toolchain.DefaultToolchainJob;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.RunDefinition;
import de.uni_freiburg.informatik.ultimate.core.model.IController;
import de.uni_freiburg.informatik.ultimate.core.model.ICore;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILoggingService;
import java.io.File;
import java.util.concurrent.Semaphore;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ExternalUltimateCore {
    private UltimateCore mCurrentUltimateInstance;
    private Throwable mUltimateThrowable;
    private volatile boolean mReachedInit;
    private final Semaphore mUltimateExit = new Semaphore(0);
    private final Semaphore mStarterContinue = new Semaphore(0);
    private final IController<RunDefinition> mController;
    protected ManualReleaseToolchainJob mJob;
    private volatile IStatus mReturnStatus;

    public ExternalUltimateCore(IController<RunDefinition> iController) {
        this.mController = iController;
        this.mReachedInit = false;
    }

    public IStatus runUltimate(String string) throws Throwable {
        if (this.mCurrentUltimateInstance != null) {
            throw new IllegalStateException("You must call complete() before re-using this instance: " + string);
        }
        this.mCurrentUltimateInstance = new UltimateCore();
        this.mUltimateThrowable = null;
        ActualUltimateRunnable actualUltimateRunnable = new ActualUltimateRunnable();
        Thread thread = new Thread((Runnable)actualUltimateRunnable, string);
        thread.start();
        this.mStarterContinue.acquireUninterruptibly();
        if (this.mUltimateThrowable != null) {
            throw this.mUltimateThrowable;
        }
        return this.mReturnStatus;
    }

    public IStatus init(ICore<RunDefinition> iCore) {
        return this.init(iCore, null, 0L, null);
    }

    public IStatus init(ICore<RunDefinition> iCore, File[] fileArray) {
        return this.init(iCore, null, 0L, fileArray);
    }

    public IStatus init(ICore<RunDefinition> iCore, File file, long l, File[] fileArray) {
        ILogger iLogger = null;
        try {
            this.mReachedInit = true;
            if (iCore == null) {
                Status status = new Status(4, "de.uni_freiburg.informatik.ultimate.core", 4, "Initialization failed", null);
                return status;
            }
            try {
                iLogger = this.getLogger(iCore.getCoreLoggingService());
                if (file != null) {
                    iCore.loadPreferences(file.getAbsolutePath(), false);
                }
                this.mJob = this.getToolchainJob(iCore, this.mController, iLogger, fileArray);
                if (l > 0L) {
                    this.mJob.setDeadline(l);
                }
                this.mJob.schedule();
                this.mJob.join();
                this.mReturnStatus = this.mJob.getResult();
            }
            catch (Throwable throwable) {
                iLogger.error((Object)"Exception during toolchain execution.", throwable);
            }
        }
        finally {
            this.mStarterContinue.release();
            this.mUltimateExit.acquireUninterruptibly();
        }
        return this.mReturnStatus;
    }

    protected ILogger getLogger(ILoggingService iLoggingService) {
        return iLoggingService.getControllerLogger();
    }

    protected ManualReleaseToolchainJob getToolchainJob(ICore<RunDefinition> iCore, IController<RunDefinition> iController, ILogger iLogger, File[] fileArray) {
        return new ManualReleaseToolchainJob("Processing Toolchain", iCore, iController, iLogger, fileArray);
    }

    public void complete() {
        if (this.mJob != null) {
            this.mJob.releaseToolchainManually();
        }
        this.mUltimateExit.release();
    }

    private final class ActualUltimateRunnable
    implements Runnable {
        private ActualUltimateRunnable() {
        }

        @Override
        public void run() {
            try {
                ExternalUltimateCore.this.mCurrentUltimateInstance.startManually(ExternalUltimateCore.this.mController);
            }
            catch (Throwable throwable) {
                ExternalUltimateCore.this.mUltimateThrowable = throwable;
            }
            if (!ExternalUltimateCore.this.mReachedInit) {
                if (ExternalUltimateCore.this.mUltimateThrowable == null) {
                    ExternalUltimateCore.this.mUltimateThrowable = new LifecycleException("Ultimate terminated before calling init(...) on ExternalUltimateCore");
                }
                ExternalUltimateCore.this.mStarterContinue.release();
            }
        }
    }

    protected static class ManualReleaseToolchainJob
    extends DefaultToolchainJob {
        public ManualReleaseToolchainJob(String string, ICore<RunDefinition> iCore, IController<RunDefinition> iController, ILogger iLogger, File[] fileArray) {
            super(string, iCore, iController, iLogger, fileArray);
        }

        @Override
        protected void releaseToolchain() {
        }

        public void releaseToolchainManually() {
            super.releaseToolchain();
        }
    }
}

