/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.IRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.DefaultIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ModifiableGlobalsTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.SmtFunctionsAndAxioms;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ILocalProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramFunction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.LocalProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.TermTransferrer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SolverBuilder;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgLocation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Call;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlock;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Return;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.SequentialComposition;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.StatementSequence;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.ProgramVariableTransferrer;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class TransferBetweenMainAndWorker<LETTER, STATE> {
    private final ILogger mLogger;
    private final ManagedScript mMainScript;
    private final ManagedScript mWorkerScript;
    private final HashMap<LETTER, LETTER> mEdgeCache = new HashMap();
    private final HashMap<IProgramVar, IProgramVar> mProgramVarBackTranslationCache = new HashMap();
    private final AutomataLibraryServices mServices;
    private final IUltimateServiceProvider mIUltiamteServices;
    private final TermTransferrer mWorker2main;
    private final TermTransferrer mMain2worker;
    private VpAlphabet<LETTER> mMainVpAlphabet;
    private final CfgSmtToolkit mMainCsToolkit;
    private final CfgSmtToolkit mWorkerCsToolkit;
    private final ProgramVariableTransferrer mVarTransfer;
    private Mode mMode = Mode.NONE;

    public TransferBetweenMainAndWorker(AutomataLibraryServices automataLibraryServices, ILogger iLogger, ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider, SolverBuilder.SolverSettings solverSettings, CfgSmtToolkit cfgSmtToolkit) {
        this.mLogger = iLogger;
        this.mIUltiamteServices = iUltimateServiceProvider;
        this.mMainScript = managedScript;
        this.mWorkerScript = cfgSmtToolkit.createFreshManagedScript(iUltimateServiceProvider, solverSettings);
        this.mServices = automataLibraryServices;
        this.mMainCsToolkit = cfgSmtToolkit;
        this.mWorker2main = new TermTransferrer(this.mWorkerScript.getScript(), this.mMainScript.getScript());
        this.mMain2worker = new TermTransferrer(this.mMainScript.getScript(), this.mWorkerScript.getScript());
        this.mVarTransfer = new ProgramVariableTransferrer(this.mMain2worker, this.mWorkerScript);
        this.mWorkerCsToolkit = this.constructWorkerCfgSmtToolkit();
    }

    public IRun<LETTER, ?> transferRun(NestedRun<LETTER, ?> nestedRun, Mode mode) {
        NestedRun<LETTER, ?> nestedRun2 = nestedRun;
        this.mMode = mode;
        NestedWord nestedWord = new NestedWord();
        int n = 0;
        while (n < nestedRun2.getWord().length()) {
            Object e = nestedRun2.getWord().asList().get(n);
            int n2 = -2;
            Object e2 = e;
            Objects.requireNonNull(e2);
            Object object = e2;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Call.class, Return.class, StatementSequence.class, SequentialComposition.class}, object, 0)) {
                case 0: {
                    Call call = (Call)object;
                    n2 = Integer.MAX_VALUE;
                    break;
                }
                case 1: {
                    Return return_ = (Return)object;
                    n2 = Integer.MIN_VALUE;
                    break;
                }
                case 2: {
                    StatementSequence statementSequence = (StatementSequence)object;
                    n2 = -2;
                    break;
                }
                case 3: {
                    SequentialComposition sequentialComposition = (SequentialComposition)object;
                    n2 = -2;
                    break;
                }
                default: {
                    new AssertionError((Object)("Unexpected letter type: " + String.valueOf(e.getClass())));
                }
            }
            object = new NestedWord(this.transferEdge(e), n2);
            nestedWord = nestedWord.concatenate(object);
            ++n;
        }
        NestedRun nestedRun3 = new NestedRun(nestedWord, nestedRun2.getStateSequence());
        return nestedRun3;
    }

    private LETTER transferEdge(LETTER LETTER) {
        Call call = null;
        if (this.mEdgeCache.containsKey(LETTER)) {
            call = (Call)this.mEdgeCache.get(LETTER);
        } else {
            LETTER LETTER2 = LETTER;
            Objects.requireNonNull(LETTER2);
            LETTER LETTER3 = LETTER2;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Call.class, Return.class, StatementSequence.class, SequentialComposition.class}, LETTER3, 0)) {
                case 0: {
                    Call call2 = (Call)LETTER3;
                    call = this.getTransferCall(call2);
                    break;
                }
                case 1: {
                    Return return_ = (Return)LETTER3;
                    call = this.getTransferReturn(return_);
                    break;
                }
                case 2: {
                    StatementSequence statementSequence = (StatementSequence)LETTER3;
                    call = this.getTransferStmtSequence(statementSequence);
                    break;
                }
                case 3: {
                    SequentialComposition sequentialComposition = (SequentialComposition)LETTER3;
                    call = this.getTransferSeqComp(sequentialComposition);
                    break;
                }
                default: {
                    new AssertionError((Object)("Unexpected letter type: " + String.valueOf(LETTER.getClass())));
                }
            }
        }
        assert (call != null);
        this.mEdgeCache.put(LETTER, call);
        this.mEdgeCache.put(call, LETTER);
        return (LETTER)call;
    }

    private SequentialComposition getTransferSeqComp(SequentialComposition sequentialComposition) {
        SequentialComposition sequentialComposition2 = new SequentialComposition(sequentialComposition.getSerialNumber(), (BoogieIcfgLocation)sequentialComposition.getSource(), (BoogieIcfgLocation)sequentialComposition.getTarget(), this.mWorkerCsToolkit, sequentialComposition.getSimplify(), sequentialComposition.getExtPqe(), this.mIUltiamteServices, this.getTransferredCodeBlocks(sequentialComposition.getCodeBlocks()), sequentialComposition.getSimplificationTechnique());
        sequentialComposition2.setPayload(sequentialComposition.getPayload());
        return sequentialComposition2;
    }

    private List<CodeBlock> getTransferredCodeBlocks(List<CodeBlock> list) {
        ArrayList<CodeBlock> arrayList = new ArrayList<CodeBlock>();
        for (CodeBlock codeBlock : list) {
            arrayList.add(this.transferEdge(codeBlock));
        }
        return arrayList;
    }

    private Call getTransferCall(Call call) {
        Call call2 = new Call(call.getSerialNumber(), (BoogieIcfgLocation)call.getSource(), (BoogieIcfgLocation)call.getTarget(), call.getCallStatement(), this.mLogger);
        call2.setTransitionFormula(this.transferTransFormulaWithMode(call.getTransformula()));
        call2.setPayload(call.getPayload());
        return call2;
    }

    private StatementSequence getTransferStmtSequence(StatementSequence statementSequence) {
        StatementSequence statementSequence2 = new StatementSequence(statementSequence.getSerialNumber(), (BoogieIcfgLocation)statementSequence.getSource(), (BoogieIcfgLocation)statementSequence.getTarget(), statementSequence.getStatements(), this.mLogger);
        statementSequence2.setTransitionFormula(this.transferTransFormulaWithMode(statementSequence.getTransformula()));
        statementSequence2.setPayload(statementSequence.getPayload());
        return statementSequence2;
    }

    private Return getTransferReturn(Return return_) {
        Return return_2 = new Return(return_.getSerialNumber(), (BoogieIcfgLocation)return_.getSource(), (BoogieIcfgLocation)return_.getTarget(), this.getTransferCall(return_.getCorrespondingCall()), this.mLogger);
        return_2.setTransitionFormula(this.transferTransFormulaWithMode(return_.getTransformula()));
        return_2.setPayload(return_.getPayload());
        return return_2;
    }

    private UnmodifiableTransFormula transferTransFormulaWithMode(UnmodifiableTransFormula unmodifiableTransFormula) {
        switch (this.mMode) {
            case MAIN2WORKER: {
                return this.transferTransformula(unmodifiableTransFormula, this.mMain2worker, this.mWorkerScript);
            }
            case WORKER2MAIN: {
                return this.transferTransformula(unmodifiableTransFormula, this.mWorker2main, this.mMainScript);
            }
        }
        throw new AssertionError((Object)("Unexpected transferrer mode: " + String.valueOf((Object)this.mMode)));
    }

    private UnmodifiableTransFormula transferTransformula(UnmodifiableTransFormula unmodifiableTransFormula, TermTransferrer termTransferrer, ManagedScript managedScript) {
        TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder(this.transferMap(termTransferrer, unmodifiableTransFormula.getInVars()), this.transferMap(termTransferrer, unmodifiableTransFormula.getOutVars()), unmodifiableTransFormula.getNonTheoryConsts().isEmpty(), unmodifiableTransFormula.getNonTheoryConsts(), unmodifiableTransFormula.getBranchEncoders().isEmpty(), TransferBetweenMainAndWorker.transferSet(termTransferrer, unmodifiableTransFormula.getBranchEncoders()), unmodifiableTransFormula.getAuxVars().isEmpty());
        assert (unmodifiableTransFormula.getNonTheoryConsts().isEmpty());
        transFormulaBuilder.setFormula(termTransferrer.transform(unmodifiableTransFormula.getFormula()));
        transFormulaBuilder.addAuxVarsButRenameToFreshCopies(TransferBetweenMainAndWorker.transferSet(termTransferrer, unmodifiableTransFormula.getAuxVars()), managedScript);
        transFormulaBuilder.setInfeasibility(unmodifiableTransFormula.isInfeasible());
        return transFormulaBuilder.finishConstruction(managedScript);
    }

    private Map<TermVariable, String> transferTv2StringMap(TermTransferrer termTransferrer, Map<TermVariable, String> map) {
        HashMap<TermVariable, String> hashMap = new HashMap<TermVariable, String>();
        for (Map.Entry<TermVariable, String> entry : map.entrySet()) {
            hashMap.put((TermVariable)termTransferrer.transform((Term)entry.getKey()), entry.getValue());
        }
        return hashMap;
    }

    private Map<IProgramVar, TermVariable> transferMap(TermTransferrer termTransferrer, Map<IProgramVar, TermVariable> map) {
        HashMap<IProgramVar, TermVariable> hashMap = new HashMap<IProgramVar, TermVariable>();
        for (Map.Entry<IProgramVar, TermVariable> entry : map.entrySet()) {
            IProgramVar iProgramVar;
            if (!this.mProgramVarBackTranslationCache.containsKey(entry.getKey())) {
                IProgramVar iProgramVar2;
                assert (this.mMode.equals((Object)Mode.MAIN2WORKER));
                Objects.requireNonNull(entry.getKey());
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ProgramNonOldVar.class, LocalProgramVar.class}, (Object)iProgramVar2, 0)) {
                    case 0: {
                        ProgramNonOldVar programNonOldVar = (ProgramNonOldVar)iProgramVar2;
                        iProgramVar = this.mVarTransfer.translateProgramVar((IProgramVar)programNonOldVar);
                        break;
                    }
                    case 1: {
                        LocalProgramVar localProgramVar = (LocalProgramVar)iProgramVar2;
                        iProgramVar = this.mVarTransfer.translateProgramVar((IProgramVar)localProgramVar);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected type of BoogieVar: " + String.valueOf(entry.getKey().getClass())));
                    }
                }
                this.mProgramVarBackTranslationCache.put(iProgramVar, entry.getKey());
            } else {
                iProgramVar = this.mProgramVarBackTranslationCache.get(entry.getKey());
            }
            assert (iProgramVar != null);
            hashMap.put(iProgramVar, (TermVariable)termTransferrer.transform((Term)entry.getValue()));
        }
        return hashMap;
    }

    public static Set<TermVariable> transferSet(TermTransferrer termTransferrer, Set<TermVariable> set) {
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>();
        for (TermVariable termVariable : set) {
            hashSet.add((TermVariable)termTransferrer.transform((Term)termVariable));
        }
        return hashSet;
    }

    public INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> transferAutomaton(INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, IEmptyStackStateFactory<STATE> iEmptyStackStateFactory, Mode mode) {
        Set<Object> set;
        Set<Object> set2;
        Set<Object> set3;
        this.mMode = mode;
        NestedWordAutomaton nestedWordAutomaton = new NestedWordAutomaton(this.mServices, switch (this.mMode) {
            case Mode.MAIN2WORKER -> {
                set3 = new HashSet();
                set2 = new HashSet();
                set = new HashSet();
                this.mMainVpAlphabet = iNwaOutgoingLetterAndTransitionProvider.getVpAlphabet();
                yield new VpAlphabet(set3, set2, set);
            }
            case Mode.WORKER2MAIN -> {
                set3 = this.mMainVpAlphabet.getInternalAlphabet();
                set2 = this.mMainVpAlphabet.getCallAlphabet();
                set = this.mMainVpAlphabet.getReturnAlphabet();
                yield new VpAlphabet(set3, set2, set);
            }
            default -> throw new AssertionError((Object)("Unexpected transferrer mode: " + String.valueOf((Object)this.mMode)));
        }, iEmptyStackStateFactory);
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.add(iNwaOutgoingLetterAndTransitionProvider.getEmptyStackState());
        HashSet<Object> hashSet2 = new HashSet<Object>();
        HashSet hashSet3 = new HashSet();
        iNwaOutgoingLetterAndTransitionProvider.getInitialStates().forEach(hashSet3::add);
        ArrayDeque<Object> arrayDeque = new ArrayDeque<Object>(hashSet3);
        HashSet hashSet4 = new HashSet();
        while (!arrayDeque.isEmpty()) {
            Object object4;
            Object object2;
            Object object32;
            Object e = arrayDeque.pop();
            if (!hashSet4.add(e)) continue;
            if (!nestedWordAutomaton.contains(e)) {
                hashSet2.add(e);
                nestedWordAutomaton.addState(iNwaOutgoingLetterAndTransitionProvider.isInitial(e), iNwaOutgoingLetterAndTransitionProvider.isFinal(e), e);
            }
            for (Object object32 : iNwaOutgoingLetterAndTransitionProvider.callSuccessors(e)) {
                object2 = object32.getSucc();
                if (!nestedWordAutomaton.contains(object2)) {
                    hashSet2.add(object2);
                    nestedWordAutomaton.addState(iNwaOutgoingLetterAndTransitionProvider.isInitial(object2), iNwaOutgoingLetterAndTransitionProvider.isFinal(object2), object2);
                }
                object4 = this.transferEdge(object32.getLetter());
                set2.add(object4);
                nestedWordAutomaton.addCallTransition(e, object4, object2);
                hashSet.add(e);
                arrayDeque.add(object2);
            }
            for (Object object32 : iNwaOutgoingLetterAndTransitionProvider.internalSuccessors(e)) {
                object2 = object32.getSucc();
                if (!nestedWordAutomaton.contains(object2)) {
                    hashSet2.add(object2);
                    nestedWordAutomaton.addState(iNwaOutgoingLetterAndTransitionProvider.isInitial(object2), iNwaOutgoingLetterAndTransitionProvider.isFinal(object2), object2);
                }
                object4 = this.transferEdge(object32.getLetter());
                set3.add(object4);
                nestedWordAutomaton.addInternalTransition(e, object4, object2);
                arrayDeque.add(object2);
            }
            object32 = new HashSet(hashSet2);
            object2 = object32.iterator();
            while (object2.hasNext()) {
                Iterator<Object> iterator = object2.next();
                for (Object object4 : hashSet) {
                    for (OutgoingReturnTransition outgoingReturnTransition : iNwaOutgoingLetterAndTransitionProvider.returnSuccessorsGivenHier(iterator, object4)) {
                        Object object5 = outgoingReturnTransition.getSucc();
                        Object object6 = outgoingReturnTransition.getHierPred();
                        if (!nestedWordAutomaton.contains(object5)) {
                            hashSet2.add(object5);
                            nestedWordAutomaton.addState(iNwaOutgoingLetterAndTransitionProvider.isInitial(object5), iNwaOutgoingLetterAndTransitionProvider.isFinal(object5), object5);
                        }
                        if (!nestedWordAutomaton.contains(object6)) {
                            hashSet2.add(object6);
                            nestedWordAutomaton.addState(iNwaOutgoingLetterAndTransitionProvider.isInitial(object6), iNwaOutgoingLetterAndTransitionProvider.isFinal(object6), object6);
                        }
                        Object object7 = this.transferEdge(outgoingReturnTransition.getLetter());
                        set.add(object7);
                        nestedWordAutomaton.addReturnTransition(iterator, object6, object7, object5);
                        arrayDeque.add(object5);
                    }
                }
            }
        }
        assert (nestedWordAutomaton.size() == iNwaOutgoingLetterAndTransitionProvider.size());
        return nestedWordAutomaton;
    }

    public CfgSmtToolkit constructWorkerCfgSmtToolkit() {
        IProgramFunction iProgramFunction2;
        IProgramVar iProgramVar2;
        HashRelation<String, IProgramNonOldVar> hashRelation = TransferBetweenMainAndWorker.constructNewProc2Globals((HashRelation<String, IProgramNonOldVar>)this.mMainCsToolkit.getModifiableGlobalsTable().getProcToGlobals(), this.mVarTransfer);
        ModifiableGlobalsTable modifiableGlobalsTable = new ModifiableGlobalsTable(hashRelation);
        IIcfgSymbolTable iIcfgSymbolTable = TransferBetweenMainAndWorker.constructNewSymbolTable(this.mMainCsToolkit.getSymbolTable(), this.mMainCsToolkit.getProcedures(), this.mVarTransfer);
        Map<String, List<ILocalProgramVar>> map = TransferBetweenMainAndWorker.constructNewParams(this.mMainCsToolkit.getInParams(), this.mVarTransfer);
        Map<String, List<ILocalProgramVar>> map2 = TransferBetweenMainAndWorker.constructNewParams(this.mMainCsToolkit.getOutParams(), this.mVarTransfer);
        IPredicate iPredicate = this.mMainCsToolkit.getSmtFunctionsAndAxioms().getAxioms();
        HashSet<IProgramVar> hashSet = new HashSet<IProgramVar>();
        for (IProgramVar iProgramVar2 : iPredicate.getVars()) {
            hashSet.add(this.mVarTransfer.translateProgramVar(iProgramVar2));
        }
        iProgramVar2 = new HashSet();
        for (IProgramFunction iProgramFunction2 : iPredicate.getFuns()) {
            iProgramVar2.add(this.mVarTransfer.getOrConstruct((IProgramConst)iProgramFunction2));
        }
        iProgramFunction2 = new BasicPredicate(0, this.mMain2worker.transform(iPredicate.getFormula()), hashSet, (Set)iProgramVar2, this.mMain2worker.transform(iPredicate.getClosedFormula()));
        SmtFunctionsAndAxioms smtFunctionsAndAxioms = new SmtFunctionsAndAxioms((IPredicate)iProgramFunction2, this.mWorkerScript);
        return new CfgSmtToolkit(modifiableGlobalsTable, this.mWorkerScript, iIcfgSymbolTable, this.mMainCsToolkit.getProcedures(), map, map2, this.mMainCsToolkit.getIcfgEdgeFactory(), this.mMainCsToolkit.getConcurrencyInformation(), smtFunctionsAndAxioms);
    }

    private static Map<String, List<ILocalProgramVar>> constructNewParams(Map<String, List<ILocalProgramVar>> map, ProgramVariableTransferrer programVariableTransferrer) {
        HashMap<String, List<ILocalProgramVar>> hashMap = new HashMap<String, List<ILocalProgramVar>>();
        for (Map.Entry<String, List<ILocalProgramVar>> entry : map.entrySet()) {
            List list = entry.getValue().stream().map(iLocalProgramVar -> programVariableTransferrer.getOrConstruct((ILocalProgramVar)iLocalProgramVar)).collect(Collectors.toList());
            hashMap.put(entry.getKey(), list);
        }
        return hashMap;
    }

    private static IIcfgSymbolTable constructNewSymbolTable(IIcfgSymbolTable iIcfgSymbolTable, Set<String> set, ProgramVariableTransferrer programVariableTransferrer) {
        DefaultIcfgSymbolTable defaultIcfgSymbolTable = new DefaultIcfgSymbolTable();
        for (IProgramConst object : iIcfgSymbolTable.getConstants()) {
            defaultIcfgSymbolTable.add((IProgramVarOrConst)programVariableTransferrer.getOrConstruct(object));
        }
        for (IProgramNonOldVar iProgramNonOldVar : iIcfgSymbolTable.getGlobals()) {
            defaultIcfgSymbolTable.add((IProgramVarOrConst)programVariableTransferrer.getOrConstruct(iProgramNonOldVar));
        }
        for (String string : set) {
            for (ILocalProgramVar iLocalProgramVar : iIcfgSymbolTable.getLocals(string)) {
                defaultIcfgSymbolTable.add((IProgramVarOrConst)programVariableTransferrer.getOrConstruct(iLocalProgramVar));
            }
        }
        return defaultIcfgSymbolTable;
    }

    private static HashRelation<String, IProgramNonOldVar> constructNewProc2Globals(HashRelation<String, IProgramNonOldVar> hashRelation, ProgramVariableTransferrer programVariableTransferrer) {
        HashRelation hashRelation2 = new HashRelation();
        for (Map.Entry entry : hashRelation.entrySet()) {
            for (IProgramNonOldVar iProgramNonOldVar : (HashSet)entry.getValue()) {
                IProgramNonOldVar iProgramNonOldVar2 = programVariableTransferrer.getOrConstruct(iProgramNonOldVar);
                hashRelation2.addPair((Object)((String)entry.getKey()), (Object)iProgramNonOldVar2);
            }
        }
        return hashRelation2;
    }

    public CfgSmtToolkit getWorkerCfgSmtToolKit() {
        return this.mWorkerCsToolkit;
    }

    static enum Mode {
        NONE,
        MAIN2WORKER,
        WORKER2MAIN;

    }
}

