/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.results;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Check;
import de.uni_freiburg.informatik.ultimate.core.lib.results.AbstractResultAtElement;
import de.uni_freiburg.informatik.ultimate.core.lib.results.IResultWithCheck;
import de.uni_freiburg.informatik.ultimate.core.lib.results.ResultUtil;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResultWithFiniteTrace;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import java.util.List;

public class CounterExampleResult<ELEM extends IElement, TE extends IElement, E>
extends AbstractResultAtElement<ELEM>
implements IResultWithFiniteTrace<TE, E>,
IResultWithCheck {
    private final Check mCheckedSpecification;
    private final List<ILocation> mFailurePath;
    private final IProgramExecution<TE, E> mProgramExecution;
    private final String mProgramExecutionAsString;

    public CounterExampleResult(ELEM ELEM, String string, IBacktranslationService iBacktranslationService, IProgramExecution<TE, E> iProgramExecution) {
        super(ELEM, string);
        this.mCheckedSpecification = Check.getAnnotation(ELEM);
        this.mProgramExecution = iProgramExecution;
        this.mFailurePath = ResultUtil.getLocationSequence(iProgramExecution);
        this.mProgramExecutionAsString = iBacktranslationService.translateProgramExecution(this.mProgramExecution).toString();
    }

    private CounterExampleResult(CounterExampleResult<ELEM, TE, E> counterExampleResult) {
        super(counterExampleResult.getElement(), counterExampleResult.getPlugin());
        this.mCheckedSpecification = counterExampleResult.mCheckedSpecification;
        this.mProgramExecution = IProgramExecution.emptyExecution((Class)counterExampleResult.mProgramExecution.getExpressionClass(), (Class)counterExampleResult.mProgramExecution.getTraceElementClass());
        this.mFailurePath = counterExampleResult.mFailurePath;
        this.mProgramExecutionAsString = "";
    }

    public String getShortDescription() {
        if (this.mCheckedSpecification == null) {
            return "some specification is violated - ERROR (information lost during translation process)";
        }
        return this.mCheckedSpecification.getNegativeMessage();
    }

    @Override
    public Check getCheckedSpecification() {
        return this.mCheckedSpecification;
    }

    private boolean isRelevanceInformationIncluded() {
        if (this.getProgramExecution().getLength() > 0) {
            return this.getProgramExecution().getTraceElement(0).getRelevanceInformation() != null;
        }
        return false;
    }

    public String getLongDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getShortDescription());
        stringBuilder.append(CoreUtil.getPlatformLineSeparator());
        stringBuilder.append("We found a FailurePath: ");
        stringBuilder.append(CoreUtil.getPlatformLineSeparator());
        if (this.isRelevanceInformationIncluded()) {
            stringBuilder.append("(The third column contains information about the relevance of the program statement.");
            stringBuilder.append(" The asterisk (*) means that the statement's code block is 'error enforcing'.");
            stringBuilder.append(" The at sign (@) means that the statement's code block is 'error admitting'.");
            stringBuilder.append(" The dash (-) means that the statement's code block is irrelevant.)");
            stringBuilder.append(CoreUtil.getPlatformLineSeparator());
        }
        stringBuilder.append(this.getProgramExecutionAsString());
        return stringBuilder.toString();
    }

    public List<ILocation> getFailurePath() {
        return this.mFailurePath;
    }

    public IProgramExecution<TE, E> getProgramExecution() {
        return this.mProgramExecution;
    }

    public String getProgramExecutionAsString() {
        return this.mProgramExecutionAsString;
    }

    public CounterExampleResult<ELEM, TE, E> createCounterExampleResultWithoutTrace() {
        return new CounterExampleResult<ELEM, TE, E>(this);
    }
}

