/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.results;

import de.uni_freiburg.informatik.ultimate.core.lib.results.AbstractResultAtElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResultWithInfiniteLassoTrace;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;

public class NonterminatingLassoResult<ELEM extends IElement, TE extends IElement, EXP>
extends AbstractResultAtElement<ELEM>
implements IResultWithInfiniteLassoTrace<TE, EXP> {
    private final IProgramExecution<TE, EXP> mStemExecution;
    protected final String mStemExecutionAsString;
    private final IProgramExecution<TE, EXP> mLoopExecution;
    protected final String mLoopExecutionAsString;

    public NonterminatingLassoResult(ELEM ELEM, String string, IBacktranslationService iBacktranslationService, IProgramExecution<TE, EXP> iProgramExecution, IProgramExecution<TE, EXP> iProgramExecution2) {
        super(ELEM, string);
        this.mStemExecution = iProgramExecution;
        this.mLoopExecution = iProgramExecution2;
        IBacktranslationService.Lasso lasso = iBacktranslationService.translateLassoProgramExecution(new IBacktranslationService.Lasso(this.mStemExecution, this.mLoopExecution));
        this.mStemExecutionAsString = lasso.stem().toString();
        this.mLoopExecutionAsString = lasso.loop().toString();
    }

    public String getShortDescription() {
        return "Nonterminating execution";
    }

    public String getLongDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Found a nonterminating execution for the following lasso shaped sequence of statements.");
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append("Stem:");
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(this.mStemExecutionAsString);
        stringBuilder.append("Loop:");
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append(this.mLoopExecutionAsString);
        stringBuilder.append("End of lasso representation.");
        return stringBuilder.toString();
    }

    public IProgramExecution<TE, EXP> getStem() {
        return this.mStemExecution;
    }

    public IProgramExecution<TE, EXP> getLasso() {
        return this.mLoopExecution;
    }
}

