/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.blockencoding.encoding;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.BasicIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.BlockEncodingBacktranslator;
import de.uni_freiburg.informatik.ultimate.plugins.blockencoding.encoding.BaseBlockEncoder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;

public final class InterproceduralSequenzer
extends BaseBlockEncoder<IcfgLocation> {
    private final IcfgEdgeBuilder mEdgeBuilder;

    public InterproceduralSequenzer(IcfgEdgeBuilder icfgEdgeBuilder, IUltimateServiceProvider iUltimateServiceProvider, BlockEncodingBacktranslator blockEncodingBacktranslator, ILogger iLogger) {
        super(iLogger, iUltimateServiceProvider, blockEncodingBacktranslator);
        this.mEdgeBuilder = icfgEdgeBuilder;
    }

    @Override
    protected BasicIcfg<IcfgLocation> createResult(BasicIcfg<IcfgLocation> basicIcfg) {
        ArrayDeque arrayDeque = new ArrayDeque();
        HashSet<IcfgEdge> hashSet = new HashSet<IcfgEdge>();
        arrayDeque.addAll(basicIcfg.getInitialOutgoingEdges());
        while (!arrayDeque.isEmpty()) {
            IcfgLocation icfgLocation;
            IcfgEdge icfgEdge = (IcfgEdge)arrayDeque.removeFirst();
            if (!hashSet.add(icfgEdge) || (icfgLocation = icfgEdge instanceof IIcfgCallTransition ? this.createInterproceduralSequenceIfPossible((IIcfgCallTransition)icfgEdge) : (IcfgLocation)icfgEdge.getTarget()) == null) continue;
            arrayDeque.addAll(icfgLocation.getOutgoingEdges());
        }
        if (this.isGraphStructureChanged()) {
            this.removeDisconnectedLocations(basicIcfg);
            this.mLogger.info((Object)("Removed " + this.mRemovedEdges + " edges and " + this.mRemovedLocations + " locations during generation of interprocedural sequences"));
        }
        return basicIcfg;
    }

    private IcfgLocation createInterproceduralSequenceIfPossible(IIcfgCallTransition<?> iIcfgCallTransition) {
        IcfgLocation icfgLocation = iIcfgCallTransition.getTarget();
        List list = icfgLocation.getOutgoingEdges();
        if (list.size() > 1) {
            return icfgLocation;
        }
        IcfgEdge icfgEdge = (IcfgEdge)list.stream().findAny().orElseThrow(() -> new AssertionError((Object)"Call with no out-edge"));
        IcfgLocation icfgLocation2 = (IcfgLocation)icfgEdge.getTarget();
        List list2 = icfgLocation2.getOutgoingEdges();
        if (list2.size() > 1) {
            return icfgLocation;
        }
        Optional<IIcfgReturnTransition<?, ?>> optional = InterproceduralSequenzer.findReturn(iIcfgCallTransition, list2);
        if (!optional.isPresent()) {
            return icfgLocation;
        }
        IcfgEdge icfgEdge2 = this.createInterproceduralSequentialComposition(iIcfgCallTransition, (IIcfgTransition<?>)icfgEdge, optional.get());
        this.rememberEdgeMapping((IIcfgTransition<?>)icfgEdge2, (IIcfgTransition<?>)iIcfgCallTransition);
        this.rememberEdgeMapping((IIcfgTransition<?>)icfgEdge2, (IIcfgTransition<?>)icfgEdge);
        this.rememberEdgeMapping((IIcfgTransition<?>)icfgEdge2, (IIcfgTransition<?>)((IIcfgTransition)optional.get()));
        return (IcfgLocation)icfgEdge2.getTarget();
    }

    private static Optional<IIcfgReturnTransition<?, ?>> findReturn(IIcfgCallTransition<?> iIcfgCallTransition, List<IcfgEdge> list) {
        for (IcfgEdge icfgEdge : list) {
            IIcfgReturnTransition iIcfgReturnTransition;
            if (!(icfgEdge instanceof IIcfgReturnTransition) || !(iIcfgReturnTransition = (IIcfgReturnTransition)icfgEdge).getCorrespondingCall().equals(iIcfgCallTransition)) continue;
            return Optional.of(iIcfgReturnTransition);
        }
        return Optional.empty();
    }

    private IcfgEdge createInterproceduralSequentialComposition(IIcfgCallTransition<?> iIcfgCallTransition, IIcfgTransition<?> iIcfgTransition, IIcfgReturnTransition<?, ?> iIcfgReturnTransition) {
        ArrayList<IcfgEdge> arrayList = new ArrayList<IcfgEdge>(3);
        arrayList.add((IcfgEdge)iIcfgCallTransition);
        arrayList.add((IcfgEdge)iIcfgTransition);
        arrayList.add((IcfgEdge)iIcfgReturnTransition);
        IcfgEdge icfgEdge = this.mEdgeBuilder.constructInterproceduralSequentialComposition(iIcfgCallTransition.getSource(), iIcfgReturnTransition.getTarget(), iIcfgCallTransition, iIcfgTransition, iIcfgReturnTransition);
        arrayList.stream().forEach(this::disconnect);
        assert (icfgEdge.getTarget() != null);
        return icfgEdge;
    }

    private void disconnect(IcfgEdge icfgEdge) {
        icfgEdge.disconnectSource();
        icfgEdge.disconnectTarget();
        ++this.mRemovedEdges;
    }

    @Override
    public boolean isGraphStructureChanged() {
        return this.mRemovedEdges > 0;
    }
}

