/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.blockencoding.encoding;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.RewriteDisequality;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.BasicIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeIterator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.BlockEncodingBacktranslator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IteRemover;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.NnfTransformer;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.blockencoding.encoding.BaseBlockEncoder;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Summary;
import java.util.Collection;
import java.util.HashSet;

public final class RewriteNotEquals
extends BaseBlockEncoder<IcfgLocation> {
    private final IcfgEdgeBuilder mEdgeBuilder;

    public RewriteNotEquals(IcfgEdgeBuilder icfgEdgeBuilder, IUltimateServiceProvider iUltimateServiceProvider, BlockEncodingBacktranslator blockEncodingBacktranslator, ILogger iLogger) {
        super(iLogger, iUltimateServiceProvider, blockEncodingBacktranslator);
        this.mEdgeBuilder = icfgEdgeBuilder;
    }

    @Override
    protected BasicIcfg<IcfgLocation> createResult(BasicIcfg<IcfgLocation> basicIcfg) {
        IcfgEdgeIterator icfgEdgeIterator = new IcfgEdgeIterator(basicIcfg);
        HashSet<IcfgEdge> hashSet = new HashSet<IcfgEdge>();
        ManagedScript managedScript = basicIcfg.getCfgSmtToolkit().getManagedScript();
        while (icfgEdgeIterator.hasNext()) {
            IcfgEdge icfgEdge2 = icfgEdgeIterator.next();
            if (!(icfgEdge2 instanceof IIcfgInternalTransition) || icfgEdge2 instanceof Summary) continue;
            UnmodifiableTransFormula unmodifiableTransFormula = icfgEdge2.getTransformula();
            Term term = new IteRemover(managedScript).transform(unmodifiableTransFormula.getFormula());
            Term term2 = new NnfTransformer(managedScript, this.mServices, NnfTransformer.QuantifierHandling.KEEP).transform(term);
            Term term3 = new RewriteDisequality.RewriteDisequalityTransformer(managedScript.getScript()).transform(term2);
            if (term3 == unmodifiableTransFormula.getFormula()) continue;
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)"Rewrote ");
                this.mLogger.debug((Object)unmodifiableTransFormula.getFormula());
                this.mLogger.debug((Object)term3);
            }
            if (!hashSet.add(icfgEdge2)) continue;
            term = this.constructNewTransFormula(managedScript, unmodifiableTransFormula, term3);
            term2 = this.mEdgeBuilder.constructAndConnectInternalTransition(icfgEdge2, (IcfgLocation)icfgEdge2.getSource(), (IcfgLocation)icfgEdge2.getTarget(), (UnmodifiableTransFormula)term);
            this.rememberEdgeMapping((IIcfgTransition<?>)term2, (IIcfgTransition<?>)icfgEdge2);
        }
        hashSet.stream().forEach(icfgEdge -> {
            icfgEdge.disconnectSource();
            icfgEdge.disconnectTarget();
        });
        this.mRemovedEdges = hashSet.size();
        return basicIcfg;
    }

    private UnmodifiableTransFormula constructNewTransFormula(ManagedScript managedScript, UnmodifiableTransFormula unmodifiableTransFormula, Term term) {
        TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder(unmodifiableTransFormula.getInVars(), unmodifiableTransFormula.getOutVars(), unmodifiableTransFormula.getNonTheoryConsts().isEmpty(), unmodifiableTransFormula.getNonTheoryConsts(), unmodifiableTransFormula.getBranchEncoders().isEmpty(), (Collection)unmodifiableTransFormula.getBranchEncoders(), unmodifiableTransFormula.getAuxVars().isEmpty());
        transFormulaBuilder.setFormula(term);
        transFormulaBuilder.addAuxVarsButRenameToFreshCopies(unmodifiableTransFormula.getAuxVars(), managedScript);
        transFormulaBuilder.setInfeasibility(unmodifiableTransFormula.isInfeasible());
        return transFormulaBuilder.finishConstruction(managedScript);
    }

    @Override
    public boolean isGraphStructureChanged() {
        return this.mRemovedEdges > 0;
    }
}

