/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.HasUnreachableStates;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.AbstractMinimizeNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationCheckResultStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class MinimizeDfaTable<LETTER, STATE>
extends AbstractMinimizeNwa<LETTER, STATE> {
    private final INestedWordAutomaton<LETTER, STATE> mOperand;
    private final boolean mIsDeterministic;

    public MinimizeDfaTable(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) throws AutomataOperationCanceledException {
        super(automataLibraryServices, iMinimizationStateFactory);
        this.mOperand = iNestedWordAutomaton;
        assert (!new HasUnreachableStates<LETTER, STATE>(this.mServices, iNestedWordAutomaton).getResult().booleanValue()) : "No unreachable states allowed";
        this.printStartMessage();
        this.mIsDeterministic = this.isDeterministic();
        this.startMessageDebug();
        ArrayList<STATE> arrayList = new ArrayList<STATE>(this.mOperand.getStates());
        boolean[][] blArray = this.initializeTable(arrayList);
        this.calculateTable(arrayList, blArray);
        if (this.mLogger.isDebugEnabled()) {
            this.printTable(arrayList, blArray);
        }
        this.generateResultAutomaton(arrayList, blArray);
        this.exitMessageDebug();
        this.printExitMessage();
    }

    @Override
    protected INestedWordAutomaton<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    @Override
    protected Pair<Boolean, String> checkResultHelper(IMinimizationCheckResultStateFactory<STATE> iMinimizationCheckResultStateFactory) throws AutomataLibraryException {
        return this.checkLanguageEquivalence(iMinimizationCheckResultStateFactory);
    }

    private void calculateTable(ArrayList<STATE> arrayList, boolean[][] blArray) throws AutomataOperationCanceledException {
        boolean bl = true;
        while (bl) {
            bl = false;
            int n = 0;
            while (n < arrayList.size()) {
                int n2 = 0;
                while (n2 < n) {
                    if (!blArray[n][n2]) {
                        for (Object LETTER : this.mOperand.getVpAlphabet().getInternalAlphabet()) {
                            ArrayList<STATE> arrayList2 = this.getSuccessors(arrayList, LETTER, n);
                            ArrayList<STATE> arrayList3 = this.getSuccessors(arrayList, LETTER, n2);
                            if (arrayList2.isEmpty() ^ arrayList3.isEmpty()) {
                                MinimizeDfaTable.mark(blArray, n, n2);
                                bl = true;
                                break;
                            }
                            if (!(this.markTable(arrayList2, arrayList3, blArray, n, n2, arrayList) | this.markTable(arrayList3, arrayList2, blArray, n, n2, arrayList))) continue;
                            MinimizeDfaTable.mark(blArray, n, n2);
                            bl = true;
                            break;
                        }
                    }
                    ++n2;
                }
                if (this.isCancellationRequested()) {
                    throw new AutomataOperationCanceledException(this.getClass());
                }
                ++n;
            }
        }
    }

    private static void mark(boolean[][] blArray, int n, int n2) {
        blArray[n][n2] = true;
        blArray[n2][n] = true;
    }

    private ArrayList<STATE> getSuccessors(ArrayList<STATE> arrayList, LETTER LETTER, int n) {
        ArrayList<STATE> arrayList2 = new ArrayList<STATE>();
        for (OutgoingInternalTransition<LETTER, STATE> outgoingInternalTransition : this.mOperand.internalSuccessors(arrayList.get(n), LETTER)) {
            arrayList2.add(outgoingInternalTransition.getSucc());
        }
        return arrayList2;
    }

    private boolean[][] initializeTable(ArrayList<STATE> arrayList) {
        boolean[][] blArray = new boolean[arrayList.size()][arrayList.size()];
        int n = 0;
        while (n < arrayList.size()) {
            int n2 = 0;
            while (n2 < n) {
                if (!blArray[n][n2] && this.mOperand.isFinal(arrayList.get(n)) != this.mOperand.isFinal(arrayList.get(n2))) {
                    MinimizeDfaTable.mark(blArray, n, n2);
                }
                ++n2;
            }
            ++n;
        }
        return blArray;
    }

    private void generateResultAutomaton(ArrayList<STATE> arrayList, boolean[][] blArray) {
        boolean[] blArray2 = new boolean[arrayList.size()];
        HashSet<STATE> hashSet = new HashSet<STATE>();
        HashMap hashMap = new HashMap();
        this.startResultConstruction();
        int n = 0;
        while (n < arrayList.size()) {
            if (!blArray2[n]) {
                hashSet.clear();
                boolean bl = false;
                boolean bl2 = false;
                int n2 = 0;
                while (n2 < arrayList.size()) {
                    if (!blArray[n][n2]) {
                        hashSet.add(arrayList.get(n2));
                        blArray2[n2] = true;
                        if (!bl) {
                            bl = this.mOperand.isFinal(arrayList.get(n2));
                        }
                        if (!bl2) {
                            bl2 = this.mOperand.isInitial(arrayList.get(n2));
                        }
                    }
                    ++n2;
                }
                Iterator<Object> iterator = this.mStateFactory.merge(hashSet);
                for (Object object2 : hashSet) {
                    hashMap.put(object2, iterator);
                }
                this.addState(bl2, bl, iterator);
                blArray2[n] = true;
            }
            ++n;
        }
        for (STATE STATE : this.mOperand.getStates()) {
            for (Object object : this.mOperand.getVpAlphabet().getInternalAlphabet()) {
                for (OutgoingInternalTransition outgoingInternalTransition : this.mOperand.internalSuccessors(STATE, object)) {
                    Object v = hashMap.get(STATE);
                    Object v2 = hashMap.get(outgoingInternalTransition.getSucc());
                    this.addInternalTransition(v, object, v2);
                }
            }
        }
        this.finishResultConstruction(null, false);
    }

    private void printTable(ArrayList<STATE> arrayList, boolean[][] blArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" \t");
        for (STATE STATE : arrayList) {
            stringBuilder.append(String.valueOf(STATE) + "\t");
        }
        this.mLogger.debug((Object)stringBuilder.toString());
        stringBuilder = new StringBuilder();
        int n = 0;
        while (n < arrayList.size()) {
            stringBuilder.append(String.valueOf(arrayList.get(n)) + "\t");
            int n2 = 0;
            while (n2 < arrayList.size()) {
                stringBuilder.append(blArray[n][n2] ? "X\t" : " \t");
                ++n2;
            }
            this.mLogger.debug((Object)stringBuilder.toString());
            stringBuilder = new StringBuilder();
            ++n;
        }
    }

    private void printTransitions(INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) {
        for (STATE STATE : iNestedWordAutomaton.getStates()) {
            for (Object LETTER : iNestedWordAutomaton.getVpAlphabet().getInternalAlphabet()) {
                for (OutgoingInternalTransition outgoingInternalTransition : iNestedWordAutomaton.internalSuccessors(STATE, LETTER)) {
                    StringBuilder stringBuilder = new StringBuilder(STATE.toString());
                    stringBuilder.append(" ").append(LETTER).append(" ").append(outgoingInternalTransition.getSucc());
                    this.mLogger.debug((Object)stringBuilder);
                }
            }
        }
    }

    private boolean markTable(ArrayList<STATE> arrayList, ArrayList<STATE> arrayList2, boolean[][] blArray, int n, int n2, ArrayList<STATE> arrayList3) {
        int n3 = 0;
        while (n3 < arrayList.size()) {
            if (!this.containsUnmarkedPair(arrayList2, blArray, arrayList3, arrayList, n3)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    private boolean containsUnmarkedPair(ArrayList<STATE> arrayList, boolean[][] blArray, ArrayList<STATE> arrayList2, ArrayList<STATE> arrayList3, int n) {
        int n2 = 0;
        while (n2 < arrayList.size()) {
            if (!blArray[arrayList2.indexOf(arrayList3.get(n))][arrayList2.indexOf(arrayList.get(n2))]) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void startMessageDebug() {
        StringBuilder stringBuilder = new StringBuilder("Start ");
        stringBuilder.append(this.getOperationName()).append(" Operand ").append(this.mOperand.sizeInformation());
        this.mLogger.info((Object)stringBuilder.toString());
        if (this.mLogger.isDebugEnabled()) {
            this.printTransitions(this.mOperand);
        }
        if (!this.mIsDeterministic) {
            this.mLogger.info((Object)"Given automaton is not deterministic!");
            this.mLogger.info((Object)"Automaton will not be minimized, but only reduced.");
        }
        this.mLogger.info((Object)"Starting to minimize...");
    }

    private void exitMessageDebug() {
        if (this.mLogger.isDebugEnabled()) {
            this.printTransitions((INestedWordAutomaton<LETTER, STATE>)this.getResult());
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Finished ").append(this.getOperationName()).append(" Result ").append(this.getResult().sizeInformation());
        this.mLogger.info((Object)stringBuilder.toString());
    }
}

