/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.fair;

import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.AGameGraph;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.ASimulation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.GameGraphChanges;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.GameGraphSuccessorProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.SimulationOrMinimizationType;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.fair.FairGameGraph;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.fair.FairGameGraphChanges;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.CountingMeasure;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.MultipleDataOption;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.SimulationPerformance;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.TimeMeasure;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.DuplicatorVertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.SpoilerVertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.Vertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Quad;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import de.uni_freiburg.informatik.ultimate.util.scc.DefaultStronglyConnectedComponentFactory;
import de.uni_freiburg.informatik.ultimate.util.scc.SccComputation;
import de.uni_freiburg.informatik.ultimate.util.scc.StronglyConnectedComponent;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class FairSimulation<LETTER, STATE>
extends ASimulation<LETTER, STATE> {
    private final boolean mDebugSimulation = false;
    private int mAmountOfSCCs;
    private boolean mAttemptingChanges;
    private GameGraphChanges<LETTER, STATE> mCurrentChanges;
    private final FairGameGraph<LETTER, STATE> mGame;
    private int mGlobalInfinity;
    private final ILogger mLogger = this.getLogger();
    private Set<SpoilerVertex<LETTER, STATE>> mNotSimulatingNonTrivialVertices;
    private HashSet<Vertex<LETTER, STATE>> mPokedFromNeighborSCC;
    private final Map<STATE, Set<STATE>> mPossibleEquivalenceClasses;
    private boolean mSimulationWasAborted;

    public FairSimulation(IProgressAwareTimer iProgressAwareTimer, ILogger iLogger, boolean bl, IStateFactory<STATE> iStateFactory, Collection<Set<STATE>> collection, FairGameGraph<LETTER, STATE> fairGameGraph) throws AutomataOperationCanceledException {
        super(iProgressAwareTimer, iLogger, bl, iStateFactory, SimulationOrMinimizationType.FAIR);
        this.mPossibleEquivalenceClasses = this.processEquivalenceClasses(collection);
        this.mPokedFromNeighborSCC = null;
        this.mNotSimulatingNonTrivialVertices = new HashSet<SpoilerVertex<LETTER, STATE>>();
        this.mCurrentChanges = null;
        this.mGame = fairGameGraph;
        this.mGame.setSimulationPerformance(super.getSimulationPerformance());
        this.mAttemptingChanges = false;
        this.mSimulationWasAborted = false;
        this.mAmountOfSCCs = 0;
    }

    public FairSimulation(IProgressAwareTimer iProgressAwareTimer, ILogger iLogger, boolean bl, IStateFactory<STATE> iStateFactory, FairGameGraph<LETTER, STATE> fairGameGraph) throws AutomataOperationCanceledException {
        this(iProgressAwareTimer, iLogger, bl, iStateFactory, Collections.emptyList(), fairGameGraph);
    }

    @Override
    public void doSimulation() throws AutomataOperationCanceledException {
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Fair Game Graph has " + this.mGame.getSize() + " vertices."));
        }
        this.mGlobalInfinity = this.mGame.getGlobalInfinity();
        SimulationPerformance simulationPerformance = super.getSimulationPerformance();
        simulationPerformance.startTimeMeasure(TimeMeasure.OVERALL);
        simulationPerformance.startTimeMeasure(TimeMeasure.SIMULATION_ONLY);
        this.mLogger.debug((Object)"Starting first simulation...");
        this.doSingleSimulation(null);
        this.mLogger.debug((Object)"Ending first simulation.");
        if (!this.isUsingSCCs()) {
            simulationPerformance.addTimeMeasureValue(TimeMeasure.BUILD_SCC, -1L);
            simulationPerformance.setCountingMeasure(CountingMeasure.SCCS, -1);
        }
        boolean bl = false;
        if (this.isUsingSCCs()) {
            this.setUseSCCs(false);
            bl = true;
            simulationPerformance.setCountingMeasure(CountingMeasure.SCCS, this.mAmountOfSCCs);
        }
        simulationPerformance.setCountingMeasure(CountingMeasure.GLOBAL_INFINITY, this.mGlobalInfinity);
        this.doFollowingSimulation(simulationPerformance);
        if (bl) {
            this.setUseSCCs(true);
        }
        this.simulationHook();
        simulationPerformance.stopTimeMeasure(TimeMeasure.SIMULATION_ONLY);
        this.mLogger.debug((Object)"Generating the result automaton...");
        this.setResult(this.mGame.generateAutomatonFromGraph());
        long l = simulationPerformance.stopTimeMeasure(TimeMeasure.OVERALL);
        long l2 = simulationPerformance.getTimeMeasureResult(TimeMeasure.BUILD_GRAPH, MultipleDataOption.ADDITIVE);
        if (l2 != -1L) {
            l += l2;
            simulationPerformance.addTimeMeasureValue(TimeMeasure.OVERALL, l2);
        }
        this.retrieveGeneralAutomataPerformance();
        this.mLogger.info((Object)((this.isUsingSCCs() ? "SCC version" : "nonSCC version") + " took " + l + " milliseconds and " + simulationPerformance.getCountingMeasureResult(CountingMeasure.SIMULATION_STEPS) + " simulation steps."));
    }

    @Override
    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        String string = System.lineSeparator();
        stringBuilder.append("FairSimulationResults fsr = (");
        stringBuilder.append(string + "\tuseSCCs = " + this.isUsingSCCs());
        stringBuilder.append(string + "\tglobalInfinity = " + this.mGlobalInfinity);
        stringBuilder.append(string + "\tstepCounter = " + this.getSimulationPerformance().getCountingMeasureResult(CountingMeasure.SIMULATION_STEPS));
        stringBuilder.append(string + "\tbuechi size before = " + this.mGame.getAutomatonSize() + " states");
        if (this.getResult() != null) {
            stringBuilder.append(string + "\tbuechi size after = " + this.getResult().size() + " states");
        }
        stringBuilder.append(string + "\tprogress measure = {");
        for (SpoilerVertex vertex : this.mGame.getSpoilerVertices()) {
            n = this.mGlobalInfinity;
            if (this.isUsingSCCs()) {
                for (StronglyConnectedComponent stronglyConnectedComponent : this.getSccComp().getSCCs()) {
                    if (!stronglyConnectedComponent.getNodes().contains(vertex)) continue;
                    n = this.calculateInfinityOfSCC(stronglyConnectedComponent);
                }
            }
            stringBuilder.append(string + "\t\t<(" + String.valueOf(vertex.getQ0()) + ", " + String.valueOf(vertex.getQ1()) + "), pm:" + vertex.getPM(null, this.mGlobalInfinity) + " of " + n + ">");
        }
        for (DuplicatorVertex duplicatorVertex : this.mGame.getDuplicatorVertices()) {
            n = this.mGlobalInfinity;
            if (this.isUsingSCCs()) {
                for (StronglyConnectedComponent stronglyConnectedComponent : this.getSccComp().getSCCs()) {
                    if (!stronglyConnectedComponent.getNodes().contains(duplicatorVertex)) continue;
                    n = this.calculateInfinityOfSCC(stronglyConnectedComponent);
                }
            }
            stringBuilder.append(string + "\t\t<(" + String.valueOf(duplicatorVertex.getQ0()) + ", " + String.valueOf(duplicatorVertex.getQ1()) + ", " + String.valueOf(duplicatorVertex.getLetter()) + "), pm:" + duplicatorVertex.getPM(null, this.mGlobalInfinity) + " of " + n + ">");
        }
        stringBuilder.append(string + "\t},");
        stringBuilder.append(string + "\tbest neighbor measure = {");
        for (SpoilerVertex spoilerVertex : this.mGame.getSpoilerVertices()) {
            stringBuilder.append(string + "\t\t<(" + String.valueOf(spoilerVertex.getQ0()) + ", " + String.valueOf(spoilerVertex.getQ1()) + "), bnm:" + spoilerVertex.getBEff() + ">");
        }
        for (DuplicatorVertex duplicatorVertex : this.mGame.getDuplicatorVertices()) {
            stringBuilder.append(string + "\t\t<(" + String.valueOf(duplicatorVertex.getQ0()) + ", " + String.valueOf(duplicatorVertex.getQ1()) + ", " + String.valueOf(duplicatorVertex.getLetter()) + "), bnm:" + duplicatorVertex.getBEff() + ">");
        }
        stringBuilder.append(string + "\t},");
        stringBuilder.append(string + "\tneighbor counter = {");
        for (SpoilerVertex spoilerVertex : this.mGame.getSpoilerVertices()) {
            stringBuilder.append(string + "\t\t<(" + String.valueOf(spoilerVertex.getQ0()) + ", " + String.valueOf(spoilerVertex.getQ1()) + "), nc:" + spoilerVertex.getC() + ">");
        }
        for (DuplicatorVertex duplicatorVertex : this.mGame.getDuplicatorVertices()) {
            stringBuilder.append(string + "\t\t<(" + String.valueOf(duplicatorVertex.getQ0()) + ", " + String.valueOf(duplicatorVertex.getQ1()) + ", " + String.valueOf(duplicatorVertex.getLetter()) + "), nc:" + duplicatorVertex.getC() + ">");
        }
        stringBuilder.append(string + "\t},");
        stringBuilder.append(string + ");");
        return stringBuilder.toString();
    }

    private boolean doSingleSimulation(GameGraphChanges<LETTER, STATE> gameGraphChanges) throws AutomataOperationCanceledException {
        if (this.isUsingSCCs()) {
            this.mPokedFromNeighborSCC = new HashSet();
            this.getSimulationPerformance().startTimeMeasure(TimeMeasure.BUILD_SCC);
            DefaultStronglyConnectedComponentFactory defaultStronglyConnectedComponentFactory = new DefaultStronglyConnectedComponentFactory();
            GameGraphSuccessorProvider<LETTER, STATE> gameGraphSuccessorProvider = new GameGraphSuccessorProvider<LETTER, STATE>(this.mGame);
            this.setSccComp(new SccComputation(this.mLogger, gameGraphSuccessorProvider, (SccComputation.IStronglyConnectedComponentFactory)defaultStronglyConnectedComponentFactory, this.mGame.getSize(), this.mGame.getVertices()));
            Iterator iterator = new LinkedList(this.getSccComp().getSCCs()).iterator();
            this.getSimulationPerformance().stopTimeMeasure(TimeMeasure.BUILD_SCC);
            while (iterator.hasNext()) {
                StronglyConnectedComponent stronglyConnectedComponent = (StronglyConnectedComponent)iterator.next();
                iterator.remove();
                int n = this.calculateInfinityOfSCC(stronglyConnectedComponent);
                this.mCurrentChanges = gameGraphChanges;
                this.efficientLiftingAlgorithm(n, stronglyConnectedComponent.getNodes());
                if (gameGraphChanges == null) {
                    ++this.mAmountOfSCCs;
                }
                if (!this.mSimulationWasAborted) continue;
                return false;
            }
        } else {
            this.mCurrentChanges = gameGraphChanges;
            this.efficientLiftingAlgorithm(this.mGlobalInfinity, null);
            if (this.mSimulationWasAborted) {
                return false;
            }
        }
        return true;
    }

    private void initSimulation(int n, Set<Vertex<LETTER, STATE>> set) {
        this.mSimulationWasAborted = false;
        this.createWorkingList();
        if (this.isUsingSCCs()) {
            for (Vertex<LETTER, STATE> vertex : set) {
                this.initWorkingListAndCWithVertex(vertex, n, set);
            }
        } else {
            for (SpoilerVertex vertex : this.mGame.getSpoilerVertices()) {
                this.initWorkingListAndCWithVertex(vertex, n, set);
            }
            for (DuplicatorVertex duplicatorVertex : this.mGame.getDuplicatorVertices()) {
                this.initWorkingListAndCWithVertex(duplicatorVertex, n, set);
            }
        }
    }

    private Set<SpoilerVertex<LETTER, STATE>> mergeCandidates() {
        HashSet<SpoilerVertex<LETTER, STATE>> hashSet = new HashSet<SpoilerVertex<LETTER, STATE>>();
        Set set = this.mGame.getSpoilerVertices();
        HashSet hashSet2 = new HashSet();
        for (SpoilerVertex spoilerVertex : set) {
            boolean bl;
            if (spoilerVertex.getPM(null, this.mGlobalInfinity) >= this.mGlobalInfinity || spoilerVertex.getQ0().equals(spoilerVertex.getQ1()) || !(bl = hashSet2.add(spoilerVertex)) || !hashSet2.contains(this.mGame.getSpoilerVertex(spoilerVertex.getQ1(), spoilerVertex.getQ0(), false))) continue;
            hashSet.add(spoilerVertex);
        }
        return hashSet;
    }

    private Map<STATE, Set<STATE>> processEquivalenceClasses(Collection<Set<STATE>> collection) {
        Map<Object, Set<Object>> map = collection.isEmpty() ? Collections.emptyMap() : new HashMap();
        for (Set<STATE> set : collection) {
            for (STATE STATE : set) {
                map.put(STATE, set);
            }
        }
        return map;
    }

    private HashSet<Quad<STATE, LETTER, STATE, STATE>> transitionCandidates(Set<SpoilerVertex<LETTER, STATE>> set) {
        HashSet<Quad<STATE, LETTER, STATE, STATE>> hashSet = new HashSet<Quad<STATE, LETTER, STATE, STATE>>();
        Set set2 = this.mGame.getSpoilerVertices();
        for (SpoilerVertex spoilerVertex : set2) {
            if (spoilerVertex.getPM(null, this.mGlobalInfinity) >= this.mGlobalInfinity || set.contains(spoilerVertex) || spoilerVertex.getQ0().equals(spoilerVertex.getQ1())) continue;
            Object STATE = spoilerVertex.getQ1();
            Object STATE2 = spoilerVertex.getQ0();
            for (IncomingInternalTransition incomingInternalTransition : this.mGame.getAutomaton().internalPredecessors(STATE)) {
                Object STATE3;
                Object LETTER;
                Object STATE4 = incomingInternalTransition.getPred();
                Triple triple = new Triple(STATE4, LETTER = incomingInternalTransition.getLetter(), STATE3 = STATE2);
                if (!this.mGame.hasBuechiTransition(triple)) continue;
                hashSet.add(new Quad(STATE4, LETTER, STATE3, STATE));
            }
        }
        return hashSet;
    }

    private FairGameGraphChanges<LETTER, STATE> validateChange(FairGameGraphChanges<LETTER, STATE> fairGameGraphChanges) throws AutomataOperationCanceledException {
        boolean bl = true;
        if (fairGameGraphChanges != null) {
            bl = this.doSingleSimulation(fairGameGraphChanges);
        }
        if (bl) {
            fairGameGraphChanges = null;
        }
        return fairGameGraphChanges;
    }

    protected FairGameGraphChanges<LETTER, STATE> attemptMerge(STATE STATE, STATE STATE2) throws AutomataOperationCanceledException {
        Object object;
        if (!this.mPossibleEquivalenceClasses.isEmpty() && (object = this.mPossibleEquivalenceClasses.get(STATE)) != null && !object.contains(STATE2)) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("\tAttempted merge for " + String.valueOf(STATE) + " and " + String.valueOf(STATE2) + " is clearly not possible since they are in different equivalence classes."));
            }
            return new FairGameGraphChanges();
        }
        if (this.mGame.areInSameEquivalenceClasses(STATE, STATE2)) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("\tAttempted merge for " + String.valueOf(STATE) + " and " + String.valueOf(STATE2) + " is clearly possible since they already are in the same equivalence class."));
            }
            return null;
        }
        object = this.mGame.equalizeBuechiStates(STATE, STATE2);
        return this.validateChange((FairGameGraphChanges<LETTER, STATE>)object);
    }

    protected FairGameGraphChanges<LETTER, STATE> attemptTransitionRemoval(STATE STATE, LETTER LETTER, STATE STATE2, STATE STATE3) throws AutomataOperationCanceledException {
        FairGameGraphChanges<LETTER, STATE> fairGameGraphChanges = this.mGame.removeBuechiTransition(STATE, LETTER, STATE2);
        return this.validateChange(fairGameGraphChanges);
    }

    protected void doFollowingSimulation(SimulationPerformance simulationPerformance) throws AutomataOperationCanceledException {
        SpoilerVertex spoilerVertex;
        FairGameGraphChanges<LETTER, Object> fairGameGraphChanges;
        Object object;
        Object object2;
        SpoilerVertex<LETTER, STATE> spoilerVertex22;
        this.mAttemptingChanges = true;
        Set<SpoilerVertex<LETTER, STATE>> set = this.mergeCandidates();
        HashSet<SpoilerVertex<LETTER, STATE>> hashSet = new HashSet<SpoilerVertex<LETTER, STATE>>();
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Size of merge candidates: " + set.size()));
        }
        for (SpoilerVertex<LETTER, STATE> spoilerVertex22 : set) {
            object2 = spoilerVertex22.getQ0();
            fairGameGraphChanges = this.attemptMerge(object2, object = spoilerVertex22.getQ1());
            if (fairGameGraphChanges != null) {
                if (this.mLogger.isDebugEnabled()) {
                    this.mLogger.debug((Object)("Attempted merge for " + String.valueOf(object2) + " and " + String.valueOf(object) + " was not successful, undoing..."));
                }
                this.mGame.undoChanges(fairGameGraphChanges);
                simulationPerformance.increaseCountingMeasure(CountingMeasure.FAILED_MERGE_ATTEMPTS);
            } else {
                if (this.mLogger.isDebugEnabled()) {
                    this.mLogger.debug((Object)("Attempted merge for " + String.valueOf(object2) + " and " + String.valueOf(object) + " was successful."));
                }
                this.mGame.markMergeable(object2, object);
                hashSet.add(spoilerVertex22);
                spoilerVertex = this.mGame.getSpoilerVertex(object, object2, false);
                if (spoilerVertex != null) {
                    hashSet.add(spoilerVertex);
                }
            }
            if (this.getProgressTimer() == null || this.getProgressTimer().continueProcessing()) continue;
            this.mLogger.debug((Object)"Stopped in doSimulation/attempting merges");
            throw new AutomataOperationCanceledException(this.getClass());
        }
        spoilerVertex22 = this.transitionCandidates(hashSet);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Size of transition candidates: " + ((HashSet)((Object)spoilerVertex22)).size()));
        }
        object2 = ((HashSet)((Object)spoilerVertex22)).iterator();
        while (object2.hasNext()) {
            Object object3;
            Quad quad = (Quad)object2.next();
            object = quad.getFirst();
            FairGameGraphChanges<Object, Object> fairGameGraphChanges2 = this.attemptTransitionRemoval(object, fairGameGraphChanges = quad.getSecond(), spoilerVertex = quad.getThird(), object3 = quad.getFourth());
            if (fairGameGraphChanges2 != null) {
                if (this.mLogger.isDebugEnabled()) {
                    this.mLogger.debug((Object)("Attempted transition removal for " + String.valueOf(object) + " -" + String.valueOf(fairGameGraphChanges) + "-> " + String.valueOf(spoilerVertex) + " was not successful, undoing..."));
                }
                this.mGame.undoChanges(fairGameGraphChanges2);
                simulationPerformance.increaseCountingMeasure(CountingMeasure.FAILED_TRANSREMOVE_ATTEMPTS);
            } else {
                if (this.mLogger.isDebugEnabled()) {
                    this.mLogger.debug((Object)("Attempted transition removal for " + String.valueOf(object) + " -" + String.valueOf(fairGameGraphChanges) + "-> " + String.valueOf(spoilerVertex) + " was successful."));
                }
                this.mGame.markRemoveableTransition(object, fairGameGraphChanges, spoilerVertex);
            }
            if (this.getProgressTimer() == null || this.getProgressTimer().continueProcessing()) continue;
            this.mLogger.debug((Object)"Stopped in doSimulation/attempting transition removal");
            throw new AutomataOperationCanceledException(this.getClass());
        }
    }

    @Override
    protected void efficientLiftingAlgorithm(int n, Set<Vertex<LETTER, STATE>> set) throws AutomataOperationCanceledException {
        SimulationPerformance simulationPerformance = super.getSimulationPerformance();
        this.initSimulation(n, set);
        while (!this.getWorkingList().isEmpty()) {
            boolean bl;
            simulationPerformance.increaseCountingMeasure(CountingMeasure.SIMULATION_STEPS);
            Vertex<LETTER, STATE> vertex = this.pollVertexFromWorkingList();
            Set<Vertex<LETTER, STATE>> set2 = set;
            if (this.isUsingSCCs() && this.mPokedFromNeighborSCC.contains(vertex)) {
                set2 = null;
            }
            int n2 = vertex.getPM(set, this.mGlobalInfinity);
            int n3 = vertex.getBEff();
            vertex.setBEff(this.calcBestNghbMeasure(vertex, n, set2));
            FairSimulation.saveBEffChange(vertex, n3, this.mCurrentChanges);
            int n4 = vertex.getC();
            vertex.setC(this.calcNghbCounter(vertex, n, set2));
            FairSimulation.saveCChange(vertex, n4, this.mCurrentChanges);
            int n5 = this.increaseVector(this.mGame.getPriority(vertex), vertex.getBEff(), n);
            vertex.setPM(n5);
            FairSimulation.savePmChange(vertex, n2, this.mCurrentChanges);
            if (n5 >= this.mGlobalInfinity) {
                boolean bl2 = bl = vertex.getQ0() == null || vertex.getQ1() == null;
                if (vertex.isSpoilerVertex() && !bl && !vertex.getQ0().equals(vertex.getQ1())) {
                    boolean bl3 = this.mNotSimulatingNonTrivialVertices.add((SpoilerVertex)vertex);
                    if (this.mAttemptingChanges && bl3) {
                        this.mNotSimulatingNonTrivialVertices.remove(vertex);
                        this.mSimulationWasAborted = true;
                        return;
                    }
                }
            }
            bl = vertex.getPM(set, this.mGlobalInfinity) == this.mGlobalInfinity && this.mGame.hasPushOverPredecessors(vertex);
            Set set3 = this.mGame.getPredecessors(vertex);
            if ((set3 == null || set3.isEmpty()) && !bl) continue;
            Set set4 = set3;
            if (bl) {
                set4 = set4 != null ? new HashSet(set4) : new HashSet();
                set4.addAll(this.mGame.getPushOverPredecessors(vertex));
            }
            for (Vertex vertex2 : set4) {
                int n6;
                if (vertex2.isInWL()) continue;
                boolean bl4 = false;
                if (this.isUsingSCCs() && !set.contains(vertex2)) {
                    n6 = n5 >= n && n2 < n ? 1 : 0;
                    boolean bl5 = bl4 = n6 != 0 && !this.mPokedFromNeighborSCC.contains(vertex2);
                    if (!bl4) continue;
                }
                if (this.decreaseVector(this.mGame.getPriority(vertex2), vertex.getPM(set, this.mGlobalInfinity), n) <= vertex2.getBEff()) continue;
                if (vertex2.isDuplicatorVertex() && (this.decreaseVector(this.mGame.getPriority(vertex2), n2, n) == vertex2.getBEff() || bl4 && vertex2.getBEff() == 0)) {
                    if (bl4 && vertex2.getC() == 0) {
                        n6 = vertex2.getC();
                        vertex2.setC(this.mGame.getSuccessors(vertex2).size());
                        FairSimulation.saveCChange(vertex2, n6, this.mCurrentChanges);
                    }
                    if (vertex2.getC() == 1) {
                        if (bl4) {
                            this.mPokedFromNeighborSCC.add(vertex2);
                            continue;
                        }
                        this.addVertexToWorkingList(vertex2);
                        continue;
                    }
                    if (vertex2.getC() <= 1) continue;
                    n6 = vertex2.getC();
                    vertex2.setC(vertex2.getC() - 1);
                    FairSimulation.saveCChange(vertex2, n6, this.mCurrentChanges);
                    continue;
                }
                if (!vertex2.isSpoilerVertex()) continue;
                if (bl4) {
                    this.mPokedFromNeighborSCC.add(vertex2);
                    continue;
                }
                this.addVertexToWorkingList(vertex2);
            }
            if (this.isUsingSCCs() && this.mPokedFromNeighborSCC.contains(vertex)) {
                this.mPokedFromNeighborSCC.remove(vertex);
            }
            if (this.getProgressTimer() == null || this.getProgressTimer().continueProcessing()) continue;
            this.mLogger.debug((Object)"Stopped in efficientLiftingAlgorithm");
            throw new AutomataOperationCanceledException(this.getClass());
        }
    }

    @Override
    protected AGameGraph<LETTER, STATE> getGameGraph() {
        return this.mGame;
    }

    @Override
    protected void initWorkingListAndCWithVertex(Vertex<LETTER, STATE> vertex, int n, Set<Vertex<LETTER, STATE>> set) {
        boolean bl;
        boolean bl2 = !this.mGame.hasSuccessors(vertex);
        boolean bl3 = this.mGame.getPriority(vertex) == 1;
        boolean bl4 = this.isUsingSCCs() && this.mPokedFromNeighborSCC.contains(vertex);
        boolean bl5 = this.mAttemptingChanges && this.mCurrentChanges != null && this.mCurrentChanges.isAddedVertex(vertex) && this.mGame.getPriority(vertex) != 0;
        boolean bl6 = bl = this.mAttemptingChanges && this.mCurrentChanges != null && this.mCurrentChanges.isVertexInvolvedInEdgeChanges(vertex);
        if (bl2 || bl3 || bl4 || bl5 || bl) {
            this.addVertexToWorkingList(vertex);
        } else {
            vertex.setInWL(false);
        }
        if (this.isUsingSCCs()) {
            Set<Vertex<LETTER, STATE>> set2 = set;
            if (this.mPokedFromNeighborSCC.contains(vertex)) {
                set2 = null;
            }
            int n2 = vertex.getC();
            vertex.setC(this.calcNghbCounter(vertex, n, set2));
            FairSimulation.saveCChange(vertex, n2, this.mCurrentChanges);
        } else if (!bl2) {
            boolean bl7;
            boolean bl8 = !this.mAttemptingChanges;
            boolean bl9 = bl7 = vertex.getC() == 0;
            if (bl8 || bl7) {
                int n3 = vertex.getC();
                vertex.setC(this.mGame.getSuccessors(vertex).size());
                FairSimulation.saveCChange(vertex, n3, this.mCurrentChanges);
            }
        }
    }

    private static <LETTER, STATE> void saveBEffChange(Vertex<LETTER, STATE> vertex, int n, GameGraphChanges<LETTER, STATE> gameGraphChanges) {
        if (gameGraphChanges != null && n != vertex.getBEff() && !gameGraphChanges.hasBEffEntry(vertex)) {
            gameGraphChanges.rememberBEffVertex(vertex, n);
        }
    }

    private static <LETTER, STATE> void saveCChange(Vertex<LETTER, STATE> vertex, int n, GameGraphChanges<LETTER, STATE> gameGraphChanges) {
        if (gameGraphChanges != null && n != vertex.getC() && !gameGraphChanges.hasCEntry(vertex)) {
            gameGraphChanges.rememberCVertex(vertex, n);
        }
    }

    private static <LETTER, STATE> void savePmChange(Vertex<LETTER, STATE> vertex, int n, GameGraphChanges<LETTER, STATE> gameGraphChanges) {
        if (gameGraphChanges != null && n != vertex.getPM(null, 0) && !gameGraphChanges.hasPmEntry(vertex)) {
            gameGraphChanges.rememberPmVertex(vertex, n);
        }
    }
}

