/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.rabin;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.rabin.IRabinAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.rabin.RabinAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.rabin.RabinUnion;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IBlackWhiteStateFactory;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class RabinAutomataUtils {
    public static <LETTER, STATE> RabinAutomaton<LETTER, STATE> computeReachableStates(IRabinAutomaton<LETTER, STATE> iRabinAutomaton) {
        return RabinAutomataUtils.computeReachableIgnoredStates(iRabinAutomaton, Set.of());
    }

    public static <LETTER, STATE> RabinAutomaton<LETTER, STATE> computeReachableIgnoredStates(IRabinAutomaton<LETTER, STATE> iRabinAutomaton, Set<STATE> set) {
        Set set2 = DataStructureUtils.difference(iRabinAutomaton.getInitialStates(), set);
        HashSet hashSet = new HashSet();
        NestedMap2 nestedMap2 = new NestedMap2();
        HashSet hashSet2 = new HashSet();
        HashSet hashSet3 = new HashSet();
        ArrayDeque<STATE> arrayDeque = new ArrayDeque<STATE>(set2);
        while (!arrayDeque.isEmpty()) {
            Object e = arrayDeque.pop();
            hashSet.add(e);
            if (iRabinAutomaton.isFinite(e)) {
                hashSet2.add(e);
            } else if (iRabinAutomaton.isAccepting(e)) {
                hashSet3.add(e);
            }
            for (OutgoingInternalTransition<LETTER, STATE> outgoingInternalTransition : iRabinAutomaton.getSuccessors(e)) {
                STATE STATE = outgoingInternalTransition.getSucc();
                if (set.contains(STATE)) continue;
                LETTER LETTER = outgoingInternalTransition.getLetter();
                HashSet<STATE> hashSet4 = (HashSet<STATE>)nestedMap2.get(e, LETTER);
                if (hashSet4 == null) {
                    hashSet4 = new HashSet<STATE>();
                    nestedMap2.put(e, LETTER, hashSet4);
                }
                hashSet4.add(STATE);
                if (hashSet.contains(STATE)) continue;
                arrayDeque.add(STATE);
            }
        }
        return new RabinAutomaton(iRabinAutomaton.getAlphabet(), hashSet, set2, hashSet3, hashSet2, nestedMap2);
    }

    public static <LETTER, STATE> IRabinAutomaton<LETTER, STATE> disjunctiveAutomaton(Set<LETTER> set, Set<STATE> set2, Set<STATE> set3, Iterable<Pair<Set<STATE>, Set<STATE>>> iterable, NestedMap2<STATE, LETTER, Set<STATE>> nestedMap2, IBlackWhiteStateFactory<STATE> iBlackWhiteStateFactory) {
        Iterator<Pair<Set<STATE>, Set<STATE>>> iterator = iterable.iterator();
        Pair<Set<STATE>, Set<STATE>> pair = iterator.next();
        IRabinAutomaton<LETTER, STATE> iRabinAutomaton = new RabinAutomaton<LETTER, STATE>(set, set2, set3, (Set)pair.getFirst(), (Set)pair.getSecond(), nestedMap2);
        while (iterator.hasNext()) {
            pair = iterator.next();
            iRabinAutomaton = new RabinUnion<LETTER, STATE>(iRabinAutomaton, new RabinAutomaton<LETTER, STATE>(set, set2, set3, (Set)pair.getFirst(), (Set)pair.getSecond(), nestedMap2), iBlackWhiteStateFactory);
        }
        return iRabinAutomaton;
    }
}

