/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.tree.operations.difference;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.GeneralOperation;
import de.uni_freiburg.informatik.ultimate.automata.IOperation;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IIntersectionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IMergeStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.ISinkStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.tree.IRankedLetter;
import de.uni_freiburg.informatik.ultimate.automata.tree.ITreeAutomatonBU;
import de.uni_freiburg.informatik.ultimate.automata.tree.operations.Complement;
import de.uni_freiburg.informatik.ultimate.automata.tree.operations.Intersect;
import java.util.HashSet;

public final class Difference<LETTER extends IRankedLetter, STATE>
extends GeneralOperation<LETTER, STATE, IStateFactory<STATE>>
implements IOperation<LETTER, STATE, IStateFactory<STATE>> {
    private final ITreeAutomatonBU<LETTER, STATE> mFirstOperand;
    private final ITreeAutomatonBU<LETTER, STATE> mResult;
    private final ITreeAutomatonBU<LETTER, STATE> mSecondOperand;

    public <SF extends IMergeStateFactory<STATE> & ISinkStateFactory<STATE>> Difference(AutomataLibraryServices automataLibraryServices, SF SF, ITreeAutomatonBU<LETTER, STATE> iTreeAutomatonBU, ITreeAutomatonBU<LETTER, STATE> iTreeAutomatonBU2) throws AutomataOperationCanceledException {
        super(automataLibraryServices);
        this.mFirstOperand = iTreeAutomatonBU;
        this.mSecondOperand = iTreeAutomatonBU2;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        this.mResult = this.computeDifference(SF);
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    @Override
    public ITreeAutomatonBU<LETTER, STATE> getResult() {
        return this.mResult;
    }

    private <SF extends IMergeStateFactory<STATE> & ISinkStateFactory<STATE>> ITreeAutomatonBU<LETTER, STATE> computeDifference(SF SF) throws AutomataOperationCanceledException {
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"Starting to compute complement(second).");
        }
        HashSet hashSet = new HashSet(this.mFirstOperand.getAlphabet());
        hashSet.addAll(this.mSecondOperand.getAlphabet());
        Object object = new Complement<LETTER, STATE>(this.mServices, SF, this.mSecondOperand, hashSet).getResult();
        if (this.mServices.getProgressAwareTimer() != null && this.isCancellationRequested()) {
            this.mLogger.debug((Object)"Stopped after computing complement(second).");
            throw new AutomataOperationCanceledException(this.getClass());
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"Starting to compute intersect(first, secondComplemented).");
        }
        return new Intersect<LETTER, STATE>(this.mServices, (IIntersectionStateFactory)SF, this.mFirstOperand, object).getResult();
    }

    @Override
    public boolean checkResult(IStateFactory<STATE> iStateFactory) throws AutomataLibraryException {
        return true;
    }
}

