/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Alpha;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Node;
import javax.media.j3d.PathInterpolator;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.vecmath.Quat4f;

public class RotationPathInterpolator
extends PathInterpolator {
    private Transform3D rotation = new Transform3D();
    private Quat4f tQuat = new Quat4f();
    private Quat4f[] quats;
    private float prevInterpolationValue = Float.NaN;
    private float prevAlphaValue = Float.NaN;
    private WakeupCriterion passiveWakeupCriterion = new WakeupOnElapsedFrames(0, true);

    RotationPathInterpolator() {
    }

    public RotationPathInterpolator(Alpha alpha, TransformGroup transformGroup, Transform3D transform3D, float[] fArray, Quat4f[] quat4fArray) {
        super(alpha, transformGroup, transform3D, fArray);
        if (fArray.length != quat4fArray.length) {
            throw new IllegalArgumentException(J3dI18N.getString("RotationPathInterpolator0"));
        }
        this.setPathArrays(quat4fArray);
    }

    public void setQuat(int n, Quat4f quat4f) {
        this.quats[n].set(quat4f);
    }

    public void getQuat(int n, Quat4f quat4f) {
        quat4f.set(this.quats[n]);
    }

    public void setPathArrays(float[] fArray, Quat4f[] quat4fArray) {
        if (fArray.length != quat4fArray.length) {
            throw new IllegalArgumentException(J3dI18N.getString("RotationPathInterpolator0"));
        }
        this.setKnots(fArray);
        this.setPathArrays(quat4fArray);
    }

    private void setPathArrays(Quat4f[] quat4fArray) {
        this.quats = new Quat4f[quat4fArray.length];
        int n = 0;
        while (n < quat4fArray.length) {
            this.quats[n] = new Quat4f();
            this.quats[n].set(quat4fArray[n]);
            ++n;
        }
    }

    public void getQuats(Quat4f[] quat4fArray) {
        int n = 0;
        while (n < this.quats.length) {
            quat4fArray[n].set(this.quats[n]);
            ++n;
        }
    }

    public void setAxisOfRotation(Transform3D transform3D) {
        this.setTransformAxis(transform3D);
    }

    public Transform3D getAxisOfRotation() {
        return this.getTransformAxis();
    }

    public void computeTransform(float f, Transform3D transform3D) {
        this.computePathInterpolation(f);
        if (this.currentKnotIndex == 0 && this.currentInterpolationValue == 0.0f) {
            this.tQuat.x = this.quats[0].x;
            this.tQuat.y = this.quats[0].y;
            this.tQuat.z = this.quats[0].z;
            this.tQuat.w = this.quats[0].w;
        } else {
            double d = this.quats[this.currentKnotIndex].x * this.quats[this.currentKnotIndex + 1].x + this.quats[this.currentKnotIndex].y * this.quats[this.currentKnotIndex + 1].y + this.quats[this.currentKnotIndex].z * this.quats[this.currentKnotIndex + 1].z + this.quats[this.currentKnotIndex].w * this.quats[this.currentKnotIndex + 1].w;
            if (d < 0.0) {
                this.tQuat.x = this.quats[this.currentKnotIndex].x + (-this.quats[this.currentKnotIndex + 1].x - this.quats[this.currentKnotIndex].x) * this.currentInterpolationValue;
                this.tQuat.y = this.quats[this.currentKnotIndex].y + (-this.quats[this.currentKnotIndex + 1].y - this.quats[this.currentKnotIndex].y) * this.currentInterpolationValue;
                this.tQuat.z = this.quats[this.currentKnotIndex].z + (-this.quats[this.currentKnotIndex + 1].z - this.quats[this.currentKnotIndex].z) * this.currentInterpolationValue;
                this.tQuat.w = this.quats[this.currentKnotIndex].w + (-this.quats[this.currentKnotIndex + 1].w - this.quats[this.currentKnotIndex].w) * this.currentInterpolationValue;
            } else {
                this.tQuat.x = this.quats[this.currentKnotIndex].x + (this.quats[this.currentKnotIndex + 1].x - this.quats[this.currentKnotIndex].x) * this.currentInterpolationValue;
                this.tQuat.y = this.quats[this.currentKnotIndex].y + (this.quats[this.currentKnotIndex + 1].y - this.quats[this.currentKnotIndex].y) * this.currentInterpolationValue;
                this.tQuat.z = this.quats[this.currentKnotIndex].z + (this.quats[this.currentKnotIndex + 1].z - this.quats[this.currentKnotIndex].z) * this.currentInterpolationValue;
                this.tQuat.w = this.quats[this.currentKnotIndex].w + (this.quats[this.currentKnotIndex + 1].w - this.quats[this.currentKnotIndex].w) * this.currentInterpolationValue;
            }
        }
        this.tQuat.normalize();
        this.rotation.set(this.tQuat);
        transform3D.mul(this.axis, this.rotation);
        transform3D.mul(transform3D, this.axisInverse);
    }

    public Node cloneNode(boolean bl) {
        RotationPathInterpolator rotationPathInterpolator = new RotationPathInterpolator();
        rotationPathInterpolator.duplicateNode(this, bl);
        return rotationPathInterpolator;
    }

    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        RotationPathInterpolator rotationPathInterpolator = (RotationPathInterpolator)node;
        int n = rotationPathInterpolator.getArrayLengths();
        this.quats = new Quat4f[n];
        Quat4f quat4f = new Quat4f();
        int n2 = 0;
        while (n2 < n) {
            this.quats[n2] = new Quat4f();
            rotationPathInterpolator.getQuat(n2, quat4f);
            this.setQuat(n2, quat4f);
            ++n2;
        }
    }
}

