/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.relation;

import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedIterator;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.TransformIterator;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;

public class NestedMap2<K1, K2, V> {
    private final Map<K1, Map<K2, V>> mK1ToK2ToV = new HashMap<K1, Map<K2, V>>();

    public NestedMap2() {
    }

    public NestedMap2(NestedMap2<K1, K2, V> nestedMap2) {
        for (K1 K1 : nestedMap2.keySet()) {
            this.mK1ToK2ToV.put(K1, new HashMap<K2, V>(nestedMap2.get(K1)));
        }
    }

    public Stream<V> values() {
        return this.mK1ToK2ToV.values().stream().map(Map::values).flatMap(Collection::stream);
    }

    public V put(K1 K1, K2 K2, V v) {
        Map map = this.mK1ToK2ToV.computeIfAbsent(K1, object -> new HashMap());
        return map.put(K2, v);
    }

    public V get(K1 K1, K2 K2) {
        Map<K2, V> map = this.mK1ToK2ToV.get(K1);
        if (map == null) {
            return null;
        }
        return map.get(K2);
    }

    public Map<K2, V> get(K1 K1) {
        return this.mK1ToK2ToV.get(K1);
    }

    public boolean containsKey(Object object) {
        return this.mK1ToK2ToV.containsKey(object);
    }

    public boolean containsKey(K1 K1, K2 K2) {
        Map<K2, V> map = this.mK1ToK2ToV.get(K1);
        if (map == null) {
            return false;
        }
        return map.containsKey(K2);
    }

    public Set<K1> keySet() {
        return this.mK1ToK2ToV.keySet();
    }

    public Iterable<Pair<K1, K2>> keys2() {
        return () -> new Iterator<Pair<K1, K2>>(){
            private Iterator<Map.Entry<K1, Map<K2, V>>> mIterator1;
            private Map.Entry<K1, Map<K2, V>> mIterator1Object;
            private Iterator<K2> mIterator2;
            {
                this.mIterator1 = NestedMap2.this.mK1ToK2ToV.entrySet().iterator();
                if (this.mIterator1.hasNext()) {
                    this.mIterator1Object = this.mIterator1.next();
                    this.mIterator2 = this.mIterator1Object.getValue().keySet().iterator();
                }
            }

            @Override
            public boolean hasNext() {
                if (this.mIterator1Object == null) {
                    return false;
                }
                return this.mIterator2.hasNext();
            }

            @Override
            public Pair<K1, K2> next() {
                if (this.mIterator1Object == null) {
                    throw new NoSuchElementException();
                }
                if (!this.mIterator2.hasNext()) {
                    if (!this.mIterator1.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.mIterator1Object = this.mIterator1.next();
                    if (!$assertionsDisabled && this.mIterator1Object.getValue().size() <= 0) {
                        throw new AssertionError((Object)"must contain at least one value");
                    }
                    this.mIterator2 = this.mIterator1Object.getValue().keySet().iterator();
                }
                return new Pair(this.mIterator1Object.getKey(), this.mIterator2.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("not yet implemented");
            }
        };
    }

    public Iterable<Triple<K1, K2, V>> entrySet() {
        Iterator iterator = this.mK1ToK2ToV.entrySet().iterator();
        Function<Map.Entry, Iterator> function = entry -> ((Map)entry.getValue()).entrySet().iterator();
        Function<Map.Entry, Function> function2 = entry -> entry2 -> new Triple(entry.getKey(), entry2.getKey(), entry2.getValue());
        return () -> new NestedIterator(iterator, function, function2);
    }

    public Iterable<Triple<K1, K2, V>> entries(K1 K1) {
        Map map = this.mK1ToK2ToV.get(K1);
        if (map == null) {
            return Collections.emptySet();
        }
        Function<Map.Entry, Triple> function = entry -> new Triple(K1, entry.getKey(), entry.getValue());
        return () -> new TransformIterator(map.entrySet().iterator(), function);
    }

    public void addAll(NestedMap2<K1, K2, V> nestedMap2) {
        for (Triple<K1, K2, V> triple : nestedMap2.entrySet()) {
            this.put(triple.getFirst(), triple.getSecond(), triple.getThird());
        }
    }

    public Map<K2, V> remove(K1 K1) {
        return this.mK1ToK2ToV.remove(K1);
    }

    public V remove(K1 K1, K2 K2) {
        Map<K2, V> map = this.mK1ToK2ToV.get(K1);
        if (map == null) {
            return null;
        }
        return map.remove(K2);
    }

    public void removeK2(K2 K2) {
        for (K1 K1 : this.mK1ToK2ToV.keySet()) {
            this.mK1ToK2ToV.get(K1).remove(K2);
        }
    }

    public void replaceK2(K2 K2, K2 K22, boolean bl) {
        if (bl) {
            throw new UnsupportedOperationException("implement this?");
        }
        for (K1 K1 : this.mK1ToK2ToV.keySet()) {
            Map<K2, V> map = this.mK1ToK2ToV.get(K1);
            V v = map.get(K2);
            if (v == null) continue;
            if (map.containsKey(K22)) {
                throw new IllegalStateException();
            }
            map.put(K22, v);
            map.remove(K2);
        }
    }

    public V computeIfAbsent(K1 K1, K2 K2, Function<K1, Function<? super K2, ? extends V>> function) {
        Map map = this.mK1ToK2ToV.computeIfAbsent(K1, object -> new HashMap());
        Function<? super K2, ? extends V> function2 = function.apply(K1);
        return map.computeIfAbsent(K2, function2);
    }

    public void clear() {
        this.mK1ToK2ToV.clear();
    }

    public int size() {
        int n = 0;
        for (Map.Entry<K1, Map<K2, V>> entry : this.mK1ToK2ToV.entrySet()) {
            n += entry.getValue().size();
        }
        return n;
    }

    public boolean isEmpty() {
        return this.mK1ToK2ToV.isEmpty();
    }

    public String toString() {
        return this.mK1ToK2ToV.toString();
    }

    public int hashCode() {
        return this.mK1ToK2ToV.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        NestedMap2 nestedMap2 = (NestedMap2)object;
        return this.mK1ToK2ToV.equals(nestedMap2.mK1ToK2ToV);
    }
}

