/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie;

import de.uni_freiburg.informatik.ultimate.boogie.ast.ASTType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayLHS;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayStoreExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssertStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssignmentStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AtomicStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Axiom;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BitVectorAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BitvecLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Body;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ConstDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.EnsuresSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ForkStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.FunctionApplication;
import de.uni_freiburg.informatik.ultimate.boogie.ast.FunctionDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.HavocStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IfStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IfThenElseExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.JoinStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LoopInvariantSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ModifiesSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.NamedAttribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.NamedType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.QuantifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.RealLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.RequiresSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Specification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StringLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructConstructor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructLHS;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Trigger;
import de.uni_freiburg.informatik.ultimate.boogie.ast.TypeDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.boogie.ast.WhileStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.WildcardExpression;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import java.util.Arrays;

public abstract class BoogieTransformer {
    protected Declaration processDeclaration(Declaration declaration) {
        Attribute[] attributeArray = declaration.getAttributes();
        Attribute[] attributeArray2 = this.processAttributes(attributeArray);
        Declaration declaration2 = null;
        if (declaration instanceof TypeDeclaration) {
            ASTType aSTType;
            TypeDeclaration typeDeclaration = (TypeDeclaration)declaration;
            ASTType aSTType2 = typeDeclaration.getSynonym();
            ASTType aSTType3 = aSTType = aSTType2 != null ? this.processType(aSTType2) : null;
            if (attributeArray2 != attributeArray || aSTType != aSTType2) {
                declaration2 = new TypeDeclaration(typeDeclaration.getLocation(), attributeArray2, typeDeclaration.isFinite(), typeDeclaration.getIdentifier(), typeDeclaration.getTypeParams(), aSTType);
            }
        } else if (declaration instanceof ConstDeclaration) {
            ConstDeclaration constDeclaration = (ConstDeclaration)declaration;
            VarList varList = constDeclaration.getVarList();
            VarList varList2 = this.processVarList(varList);
            if (attributeArray2 != attributeArray || varList2 != varList) {
                declaration2 = new ConstDeclaration(constDeclaration.getLocation(), attributeArray2, constDeclaration.isUnique(), varList2, constDeclaration.getParentInfo(), constDeclaration.isComplete());
            }
        } else if (declaration instanceof FunctionDeclaration) {
            Expression expression;
            FunctionDeclaration functionDeclaration = (FunctionDeclaration)declaration;
            VarList[] varListArray = functionDeclaration.getInParams();
            VarList[] varListArray2 = this.processVarLists(varListArray);
            VarList varList = functionDeclaration.getOutParam();
            VarList varList3 = this.processVarList(varList);
            Expression expression2 = functionDeclaration.getBody();
            Expression expression3 = expression = expression2 != null ? this.processExpression(expression2) : null;
            if (varListArray2 != varListArray || varList3 != varList || expression != expression2 || attributeArray2 != attributeArray) {
                declaration2 = new FunctionDeclaration(functionDeclaration.getLocation(), attributeArray2, functionDeclaration.getIdentifier(), functionDeclaration.getTypeParams(), varListArray2, varList3, expression);
            }
        } else if (declaration instanceof Axiom) {
            Expression expression;
            Expression expression4 = ((Axiom)declaration).getFormula();
            if (expression4 != (expression = this.processExpression(expression4)) || attributeArray != attributeArray2) {
                declaration2 = new Axiom(declaration.getLocation(), attributeArray2, expression);
            }
        } else if (declaration instanceof Procedure) {
            Body body;
            Procedure procedure = (Procedure)declaration;
            VarList[] varListArray = procedure.getInParams();
            VarList[] varListArray3 = this.processVarLists(varListArray);
            VarList[] varListArray4 = procedure.getOutParams();
            VarList[] varListArray5 = this.processVarLists(varListArray4);
            Specification[] specificationArray = procedure.getSpecification();
            Specification[] specificationArray2 = specificationArray != null ? this.processSpecifications(specificationArray) : null;
            Body body2 = procedure.getBody();
            Body body3 = body = body2 != null ? this.processBody(body2) : null;
            if (attributeArray2 != attributeArray || body != body2 || specificationArray2 != specificationArray || varListArray3 != varListArray || varListArray5 != varListArray4) {
                declaration2 = new Procedure(procedure.getLocation(), attributeArray2, procedure.getIdentifier(), procedure.getTypeParams(), varListArray3, varListArray5, specificationArray2, body);
            }
        } else if (declaration instanceof VariableDeclaration) {
            VarList[] varListArray = ((VariableDeclaration)declaration).getVariables();
            VarList[] varListArray6 = this.processVarLists(varListArray);
            if (attributeArray != attributeArray2 || varListArray != varListArray6) {
                declaration2 = new VariableDeclaration(declaration.getLocation(), attributeArray2, varListArray6);
            }
        }
        if (declaration2 == null) {
            return declaration;
        }
        ModelUtils.copyAnnotations((IElement)declaration, declaration2);
        return declaration2;
    }

    protected ASTType[] processTypes(ASTType[] aSTTypeArray) {
        boolean bl = false;
        ASTType[] aSTTypeArray2 = new ASTType[aSTTypeArray.length];
        int n = 0;
        while (n < aSTTypeArray.length) {
            aSTTypeArray2[n] = this.processType(aSTTypeArray[n]);
            if (aSTTypeArray2[n] != aSTTypeArray[n]) {
                bl = true;
            }
            ++n;
        }
        return bl ? aSTTypeArray2 : aSTTypeArray;
    }

    protected ASTType processType(ASTType aSTType) {
        NamedType namedType;
        ASTType[] aSTTypeArray;
        ASTType[] aSTTypeArray2;
        ASTType aSTType2 = null;
        if (aSTType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)aSTType;
            ASTType[] aSTTypeArray3 = arrayType.getIndexTypes();
            ASTType aSTType3 = arrayType.getValueType();
            ASTType[] aSTTypeArray4 = this.processTypes(aSTTypeArray3);
            ASTType aSTType4 = this.processType(aSTType3);
            if (aSTTypeArray4 != aSTTypeArray3 || aSTType4 != aSTType3) {
                aSTType2 = new ArrayType(arrayType.getLocation(), arrayType.getBoogieType(), arrayType.getTypeParams(), aSTTypeArray4, aSTType4);
            }
        } else if (aSTType instanceof NamedType && (aSTTypeArray2 = this.processTypes(aSTTypeArray = (namedType = (NamedType)aSTType).getTypeArgs())) != aSTTypeArray) {
            aSTType2 = new NamedType(namedType.getLocation(), namedType.getBoogieType(), namedType.getName(), aSTTypeArray2);
        }
        if (aSTType2 == null) {
            return aSTType;
        }
        ModelUtils.copyAnnotations((IElement)aSTType, aSTType2);
        return aSTType2;
    }

    protected VarList[] processVarLists(VarList[] varListArray) {
        boolean bl = false;
        VarList[] varListArray2 = new VarList[varListArray.length];
        int n = 0;
        while (n < varListArray.length) {
            varListArray2[n] = this.processVarList(varListArray[n]);
            if (varListArray2[n] != varListArray[n]) {
                bl = true;
            }
            ++n;
        }
        return bl ? varListArray2 : varListArray;
    }

    protected VarList processVarList(VarList varList) {
        Expression expression;
        ASTType aSTType = varList.getType();
        ASTType aSTType2 = this.processType(aSTType);
        Expression expression2 = varList.getWhereClause();
        Expression expression3 = expression = expression2 != null ? this.processExpression(expression2) : null;
        if (aSTType2 != aSTType || expression != expression2) {
            VarList varList2 = new VarList(varList.getLocation(), varList.getIdentifiers(), aSTType2, expression);
            ModelUtils.copyAnnotations((IElement)varList, (IElement)varList2);
            return varList2;
        }
        return varList;
    }

    protected Body processBody(Body body) {
        VariableDeclaration[] variableDeclarationArray = body.getLocalVars();
        VariableDeclaration[] variableDeclarationArray2 = this.processLocalVariableDeclarations(variableDeclarationArray);
        Statement[] statementArray = body.getBlock();
        Statement[] statementArray2 = this.processStatements(statementArray);
        if (variableDeclarationArray2 != variableDeclarationArray || statementArray2 != statementArray) {
            Body body2 = new Body(body.getLocation(), variableDeclarationArray2, statementArray2);
            ModelUtils.copyAnnotations((IElement)body, (IElement)body2);
            return body2;
        }
        return body;
    }

    protected VariableDeclaration processLocalVariableDeclaration(VariableDeclaration variableDeclaration) {
        VarList[] varListArray;
        Attribute[] attributeArray = variableDeclaration.getAttributes();
        Attribute[] attributeArray2 = this.processAttributes(attributeArray);
        VarList[] varListArray2 = variableDeclaration.getVariables();
        if (varListArray2 != (varListArray = this.processVarLists(varListArray2)) || attributeArray != attributeArray2) {
            VariableDeclaration variableDeclaration2 = new VariableDeclaration(variableDeclaration.getLocation(), attributeArray2, varListArray);
            ModelUtils.copyAnnotations((IElement)variableDeclaration, (IElement)variableDeclaration2);
            return variableDeclaration2;
        }
        return variableDeclaration;
    }

    protected VariableDeclaration[] processLocalVariableDeclarations(VariableDeclaration[] variableDeclarationArray) {
        boolean bl = false;
        VariableDeclaration[] variableDeclarationArray2 = new VariableDeclaration[variableDeclarationArray.length];
        int n = 0;
        while (n < variableDeclarationArray.length) {
            variableDeclarationArray2[n] = this.processLocalVariableDeclaration(variableDeclarationArray[n]);
            if (variableDeclarationArray2[n] != variableDeclarationArray[n]) {
                bl = true;
            }
            ++n;
        }
        return bl ? variableDeclarationArray2 : variableDeclarationArray;
    }

    protected Statement[] processStatements(Statement[] statementArray) {
        boolean bl = false;
        Statement[] statementArray2 = new Statement[statementArray.length];
        int n = 0;
        while (n < statementArray.length) {
            statementArray2[n] = this.processStatement(statementArray[n]);
            if (statementArray2[n] != statementArray[n]) {
                bl = true;
            }
            ++n;
        }
        return bl ? statementArray2 : statementArray;
    }

    protected Statement processStatement(Statement statement) {
        AtomicStatement atomicStatement;
        Statement[] statementArray;
        Statement[] statementArray2;
        Statement statement2 = null;
        if (statement instanceof AssertStatement) {
            AssertStatement assertStatement = (AssertStatement)statement;
            Expression expression = assertStatement.getFormula();
            Expression expression2 = this.processExpression(expression);
            Attribute[] attributeArray = this.processAttributes(assertStatement.getAttributes());
            if (expression != expression2 || assertStatement.getAttributes() != attributeArray) {
                statement2 = new AssertStatement(statement.getLocation(), (NamedAttribute[])attributeArray, expression2);
            }
        } else if (statement instanceof AssignmentStatement) {
            AssignmentStatement assignmentStatement = (AssignmentStatement)statement;
            LeftHandSide[] leftHandSideArray = assignmentStatement.getLhs();
            LeftHandSide[] leftHandSideArray2 = this.processLeftHandSides(leftHandSideArray);
            Expression[] expressionArray = assignmentStatement.getRhs();
            Expression[] expressionArray2 = this.processExpressions(expressionArray);
            if (leftHandSideArray != leftHandSideArray2 || expressionArray != expressionArray2) {
                statement2 = new AssignmentStatement(statement.getLocation(), leftHandSideArray2, expressionArray2);
            }
        } else if (statement instanceof AssumeStatement) {
            AssumeStatement assumeStatement = (AssumeStatement)statement;
            Expression expression = assumeStatement.getFormula();
            Expression expression3 = this.processExpression(expression);
            Attribute[] attributeArray = this.processAttributes(assumeStatement.getAttributes());
            if (expression != expression3 || assumeStatement.getAttributes() != attributeArray) {
                statement2 = new AssumeStatement(statement.getLocation(), (NamedAttribute[])attributeArray, expression3);
            }
        } else if (statement instanceof HavocStatement) {
            VariableLHS[] variableLHSArray;
            HavocStatement havocStatement = (HavocStatement)statement;
            VariableLHS[] variableLHSArray2 = havocStatement.getIdentifiers();
            if (variableLHSArray2 != (variableLHSArray = this.processVariableLHSs(variableLHSArray2))) {
                statement2 = new HavocStatement(havocStatement.getLocation(), variableLHSArray);
            }
        } else if (statement instanceof CallStatement) {
            CallStatement callStatement = (CallStatement)statement;
            Expression[] expressionArray = callStatement.getArguments();
            Expression[] expressionArray3 = this.processExpressions(expressionArray);
            VariableLHS[] variableLHSArray = callStatement.getLhs();
            VariableLHS[] variableLHSArray3 = this.processVariableLHSs(variableLHSArray);
            Attribute[] attributeArray = this.processAttributes(callStatement.getAttributes());
            if (expressionArray != expressionArray3 || variableLHSArray != variableLHSArray3 || attributeArray != callStatement.getAttributes()) {
                statement2 = new CallStatement(callStatement.getLocation(), (NamedAttribute[])attributeArray, callStatement.isForall(), variableLHSArray3, callStatement.getMethodName(), expressionArray3);
            }
        } else if (statement instanceof IfStatement) {
            IfStatement ifStatement = (IfStatement)statement;
            Expression expression = ifStatement.getCondition();
            Expression expression4 = this.processExpression(expression);
            Statement[] statementArray3 = ifStatement.getThenPart();
            Statement[] statementArray4 = this.processStatements(statementArray3);
            Statement[] statementArray5 = ifStatement.getElsePart();
            Statement[] statementArray6 = this.processStatements(statementArray5);
            if (expression4 != expression || statementArray4 != statementArray3 || statementArray6 != statementArray5) {
                statement2 = new IfStatement(ifStatement.getLocation(), expression4, statementArray4, statementArray6);
            }
        } else if (statement instanceof WhileStatement) {
            WhileStatement whileStatement = (WhileStatement)statement;
            Expression expression = whileStatement.getCondition();
            Expression expression5 = this.processExpression(expression);
            LoopInvariantSpecification[] loopInvariantSpecificationArray = whileStatement.getInvariants();
            LoopInvariantSpecification[] loopInvariantSpecificationArray2 = this.processLoopSpecifications(loopInvariantSpecificationArray);
            Statement[] statementArray7 = whileStatement.getBody();
            Statement[] statementArray8 = this.processStatements(statementArray7);
            if (expression5 != expression || loopInvariantSpecificationArray2 != loopInvariantSpecificationArray || statementArray8 != statementArray7) {
                statement2 = new WhileStatement(whileStatement.getLocation(), expression5, loopInvariantSpecificationArray2, statementArray8);
            }
        } else if (statement instanceof ForkStatement) {
            ForkStatement forkStatement = (ForkStatement)statement;
            Expression[] expressionArray = forkStatement.getThreadID();
            String string = forkStatement.getProcedureName();
            Expression[] expressionArray4 = forkStatement.getArguments();
            Expression[] expressionArray5 = this.processExpressions(expressionArray);
            Expression[] expressionArray6 = this.processExpressions(expressionArray4);
            if (expressionArray5 != expressionArray || expressionArray6 != expressionArray4) {
                statement2 = new ForkStatement(forkStatement.getLoc(), expressionArray5, string, expressionArray6);
            }
        } else if (statement instanceof JoinStatement) {
            JoinStatement joinStatement = (JoinStatement)statement;
            Expression[] expressionArray = joinStatement.getThreadID();
            VariableLHS[] variableLHSArray = joinStatement.getLhs();
            Expression[] expressionArray7 = this.processExpressions(expressionArray);
            VariableLHS[] variableLHSArray4 = this.processVariableLHSs(variableLHSArray);
            if (expressionArray7 != expressionArray || variableLHSArray4 != variableLHSArray) {
                statement2 = new JoinStatement(joinStatement.getLoc(), expressionArray7, variableLHSArray4);
            }
        } else if (statement instanceof AtomicStatement && (statementArray2 = this.processStatements(statementArray = (atomicStatement = (AtomicStatement)statement).getBody())) != statementArray) {
            statement2 = new AtomicStatement(atomicStatement.getLocation(), statementArray2);
        }
        if (statement2 == null) {
            return statement;
        }
        ModelUtils.copyAnnotations((IElement)statement, statement2);
        return statement2;
    }

    protected LoopInvariantSpecification[] processLoopSpecifications(LoopInvariantSpecification[] loopInvariantSpecificationArray) {
        boolean bl = false;
        LoopInvariantSpecification[] loopInvariantSpecificationArray2 = new LoopInvariantSpecification[loopInvariantSpecificationArray.length];
        int n = 0;
        while (n < loopInvariantSpecificationArray2.length) {
            Expression expression;
            Expression expression2 = loopInvariantSpecificationArray[n].getFormula();
            if (expression2 != (expression = this.processExpression(expression2))) {
                bl = true;
                loopInvariantSpecificationArray2[n] = new LoopInvariantSpecification(loopInvariantSpecificationArray[n].getLocation(), loopInvariantSpecificationArray[n].isFree(), expression);
                ModelUtils.copyAnnotations((IElement)loopInvariantSpecificationArray[n], (IElement)loopInvariantSpecificationArray2[n]);
            } else {
                loopInvariantSpecificationArray2[n] = loopInvariantSpecificationArray[n];
            }
            ++n;
        }
        return bl ? loopInvariantSpecificationArray2 : loopInvariantSpecificationArray;
    }

    protected LeftHandSide processLeftHandSide(LeftHandSide leftHandSide) {
        StructLHS structLHS;
        LeftHandSide leftHandSide2;
        LeftHandSide leftHandSide3;
        if (leftHandSide instanceof ArrayLHS) {
            ArrayLHS arrayLHS = (ArrayLHS)leftHandSide;
            LeftHandSide leftHandSide4 = arrayLHS.getArray();
            LeftHandSide leftHandSide5 = this.processLeftHandSide(leftHandSide4);
            Expression[] expressionArray = arrayLHS.getIndices();
            Expression[] expressionArray2 = this.processExpressions(expressionArray);
            if (leftHandSide4 != leftHandSide5 || expressionArray != expressionArray2) {
                ArrayLHS arrayLHS2 = new ArrayLHS(leftHandSide.getLocation(), arrayLHS.getType(), leftHandSide5, expressionArray2);
                ModelUtils.copyAnnotations((IElement)leftHandSide, (IElement)arrayLHS2);
                return arrayLHS2;
            }
        } else if (leftHandSide instanceof StructLHS && (leftHandSide3 = this.processLeftHandSide(leftHandSide2 = (structLHS = (StructLHS)leftHandSide).getStruct())) != leftHandSide2) {
            return new StructLHS(leftHandSide.getLocation(), structLHS.getType(), leftHandSide3, structLHS.getField());
        }
        return leftHandSide;
    }

    protected LeftHandSide[] processLeftHandSides(LeftHandSide[] leftHandSideArray) {
        boolean bl = false;
        LeftHandSide[] leftHandSideArray2 = new LeftHandSide[leftHandSideArray.length];
        int n = 0;
        while (n < leftHandSideArray2.length) {
            leftHandSideArray2[n] = this.processLeftHandSide(leftHandSideArray[n]);
            if (leftHandSideArray2[n] != leftHandSideArray[n]) {
                bl = true;
            }
            ++n;
        }
        return bl ? leftHandSideArray2 : leftHandSideArray;
    }

    protected VariableLHS[] processVariableLHSs(VariableLHS[] variableLHSArray) {
        LeftHandSide[] leftHandSideArray = this.processLeftHandSides(variableLHSArray);
        if (leftHandSideArray == variableLHSArray) {
            return variableLHSArray;
        }
        VariableLHS[] variableLHSArray2 = new VariableLHS[leftHandSideArray.length];
        System.arraycopy(leftHandSideArray, 0, variableLHSArray2, 0, leftHandSideArray.length);
        return variableLHSArray2;
    }

    protected Specification processSpecification(Specification specification) {
        VariableLHS[] variableLHSArray;
        ModifiesSpecification modifiesSpecification;
        VariableLHS[] variableLHSArray2;
        Specification specification2 = null;
        if (specification instanceof EnsuresSpecification) {
            Expression expression;
            EnsuresSpecification ensuresSpecification = (EnsuresSpecification)specification;
            Expression expression2 = ensuresSpecification.getFormula();
            if (expression2 != (expression = this.processExpression(expression2))) {
                specification2 = new EnsuresSpecification(specification.getLocation(), specification.isFree(), expression);
            }
        } else if (specification instanceof RequiresSpecification) {
            Expression expression;
            RequiresSpecification requiresSpecification = (RequiresSpecification)specification;
            Expression expression3 = requiresSpecification.getFormula();
            if (expression3 != (expression = this.processExpression(expression3))) {
                specification2 = new RequiresSpecification(specification.getLocation(), specification.isFree(), expression);
            }
        } else if (specification instanceof ModifiesSpecification && (variableLHSArray2 = (modifiesSpecification = (ModifiesSpecification)specification).getIdentifiers()) != (variableLHSArray = this.processVariableLHSs(variableLHSArray2))) {
            specification2 = new ModifiesSpecification(specification.getLocation(), specification.isFree(), variableLHSArray);
        }
        if (specification2 == null) {
            return specification;
        }
        ModelUtils.copyAnnotations((IElement)specification, specification2);
        return specification2;
    }

    protected Specification[] processSpecifications(Specification[] specificationArray) {
        boolean bl = false;
        Specification[] specificationArray2 = new Specification[specificationArray.length];
        int n = 0;
        while (n < specificationArray2.length) {
            specificationArray2[n] = this.processSpecification(specificationArray[n]);
            if (specificationArray2[n] != specificationArray[n]) {
                bl = true;
            }
            ++n;
        }
        return bl ? specificationArray2 : specificationArray;
    }

    protected <T extends Attribute> T processAttribute(T t) {
        NamedAttribute namedAttribute;
        Expression[] expressionArray;
        Expression[] expressionArray2;
        NamedAttribute namedAttribute2 = null;
        if (t instanceof Trigger) {
            Trigger trigger = (Trigger)t;
            Expression[] expressionArray3 = trigger.getTriggers();
            Expression[] expressionArray4 = this.processExpressions(expressionArray3);
            if (expressionArray4 != expressionArray3) {
                return (T)((Object)new Trigger(t.getLocation(), expressionArray4));
            }
        } else if (t instanceof NamedAttribute && (expressionArray2 = this.processExpressions(expressionArray = (namedAttribute = (NamedAttribute)t).getValues())) != expressionArray) {
            namedAttribute2 = new NamedAttribute(t.getLocation(), ((NamedAttribute)t).getName(), expressionArray2);
        }
        if (namedAttribute2 == null) {
            return t;
        }
        ModelUtils.copyAnnotations(t, namedAttribute2);
        return (T)((Object)namedAttribute2);
    }

    protected <T extends Attribute> T[] processAttributes(T[] TArray) {
        if (TArray == null) {
            return TArray;
        }
        boolean bl = false;
        Attribute[] attributeArray = (Attribute[])Arrays.copyOf(TArray, TArray.length);
        int n = 0;
        while (n < TArray.length) {
            attributeArray[n] = this.processAttribute(TArray[n]);
            if (attributeArray[n] != TArray[n]) {
                bl = true;
            }
            ++n;
        }
        return bl ? attributeArray : TArray;
    }

    protected Expression[] processExpressions(Expression[] expressionArray) {
        Expression[] expressionArray2 = new Expression[expressionArray.length];
        boolean bl = false;
        int n = 0;
        while (n < expressionArray.length) {
            expressionArray2[n] = this.processExpression(expressionArray[n]);
            if (expressionArray2[n] != expressionArray[n]) {
                bl = true;
            }
            ++n;
        }
        return bl ? expressionArray2 : expressionArray;
    }

    protected Expression processExpression(Expression expression) {
        Expression expression2 = null;
        if (expression instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            Expression expression3 = this.processExpression(binaryExpression.getLeft());
            Expression expression4 = this.processExpression(binaryExpression.getRight());
            if (expression3 != binaryExpression.getLeft() || expression4 != binaryExpression.getRight()) {
                expression2 = new BinaryExpression(expression.getLocation(), binaryExpression.getType(), binaryExpression.getOperator(), expression3, expression4);
            }
        } else if (expression instanceof UnaryExpression) {
            UnaryExpression unaryExpression = (UnaryExpression)expression;
            Expression expression5 = this.processExpression(unaryExpression.getExpr());
            if (expression5 != unaryExpression.getExpr()) {
                expression2 = new UnaryExpression(expression.getLocation(), unaryExpression.getType(), unaryExpression.getOperator(), expression5);
            }
        } else if (expression instanceof ArrayAccessExpression) {
            ArrayAccessExpression arrayAccessExpression = (ArrayAccessExpression)expression;
            Expression expression6 = this.processExpression(arrayAccessExpression.getArray());
            Expression[] expressionArray = arrayAccessExpression.getIndices();
            Expression[] expressionArray2 = this.processExpressions(expressionArray);
            if (expression6 != arrayAccessExpression.getArray() || expressionArray != expressionArray2) {
                expression2 = new ArrayAccessExpression(arrayAccessExpression.getLocation(), arrayAccessExpression.getType(), expression6, expressionArray2);
            }
        } else if (expression instanceof ArrayStoreExpression) {
            ArrayStoreExpression arrayStoreExpression = (ArrayStoreExpression)expression;
            Expression expression7 = this.processExpression(arrayStoreExpression.getArray());
            Expression expression8 = this.processExpression(arrayStoreExpression.getValue());
            Expression[] expressionArray = arrayStoreExpression.getIndices();
            Expression[] expressionArray3 = this.processExpressions(expressionArray);
            if (expression7 != arrayStoreExpression.getArray() || expressionArray != expressionArray3 || expression8 != arrayStoreExpression.getValue()) {
                expression2 = new ArrayStoreExpression(arrayStoreExpression.getLocation(), arrayStoreExpression.getType(), expression7, expressionArray3, expression8);
            }
        } else if (expression instanceof BitVectorAccessExpression) {
            BitVectorAccessExpression bitVectorAccessExpression = (BitVectorAccessExpression)expression;
            Expression expression9 = this.processExpression(bitVectorAccessExpression.getBitvec());
            if (expression9 != bitVectorAccessExpression.getBitvec()) {
                expression2 = new BitVectorAccessExpression(bitVectorAccessExpression.getLocation(), bitVectorAccessExpression.getType(), expression9, bitVectorAccessExpression.getEnd(), bitVectorAccessExpression.getStart());
            }
        } else if (expression instanceof FunctionApplication) {
            FunctionApplication functionApplication = (FunctionApplication)expression;
            String string = functionApplication.getIdentifier();
            Expression[] expressionArray = this.processExpressions(functionApplication.getArguments());
            if (expressionArray != functionApplication.getArguments()) {
                expression2 = new FunctionApplication(functionApplication.getLocation(), functionApplication.getType(), string, expressionArray);
            }
        } else if (expression instanceof IfThenElseExpression) {
            IfThenElseExpression ifThenElseExpression = (IfThenElseExpression)expression;
            Expression expression10 = this.processExpression(ifThenElseExpression.getCondition());
            Expression expression11 = this.processExpression(ifThenElseExpression.getThenPart());
            Expression expression12 = this.processExpression(ifThenElseExpression.getElsePart());
            if (expression10 != ifThenElseExpression.getCondition() || expression11 != ifThenElseExpression.getThenPart() || expression12 != ifThenElseExpression.getElsePart()) {
                expression2 = new IfThenElseExpression(ifThenElseExpression.getLocation(), expression11.getType(), expression10, expression11, expression12);
            }
        } else if (expression instanceof QuantifierExpression) {
            QuantifierExpression quantifierExpression = (QuantifierExpression)expression;
            Attribute[] attributeArray = quantifierExpression.getAttributes();
            Attribute[] attributeArray2 = this.processAttributes(attributeArray);
            VarList[] varListArray = quantifierExpression.getParameters();
            VarList[] varListArray2 = this.processVarLists(varListArray);
            Expression expression13 = this.processExpression(quantifierExpression.getSubformula());
            if (expression13 != quantifierExpression.getSubformula() || attributeArray != attributeArray2 || varListArray != varListArray2) {
                expression2 = new QuantifierExpression(quantifierExpression.getLocation(), quantifierExpression.getType(), quantifierExpression.isUniversal(), quantifierExpression.getTypeParams(), varListArray2, attributeArray2, expression13);
            }
        } else if (expression instanceof StructConstructor) {
            StructConstructor structConstructor = (StructConstructor)expression;
            Expression[] expressionArray = this.processExpressions(structConstructor.getFieldValues());
            if (expressionArray != structConstructor.getFieldValues()) {
                expression2 = new StructConstructor(structConstructor.getLocation(), structConstructor.getType(), structConstructor.getFieldIdentifiers(), expressionArray);
            }
        } else if (expression instanceof StructAccessExpression) {
            StructAccessExpression structAccessExpression = (StructAccessExpression)expression;
            Expression expression14 = this.processExpression(structAccessExpression.getStruct());
            if (expression14 != structAccessExpression.getStruct()) {
                expression2 = new StructAccessExpression(structAccessExpression.getLocation(), structAccessExpression.getType(), expression14, structAccessExpression.getField());
            }
        } else if (!(expression instanceof BooleanLiteral || expression instanceof IntegerLiteral || expression instanceof BitvecLiteral || expression instanceof StringLiteral || expression instanceof IdentifierExpression || expression instanceof WildcardExpression || expression instanceof RealLiteral)) {
            if (expression == null) {
                throw new IllegalArgumentException("expression may not be null");
            }
            throw new UnsupportedOperationException("unknown expression " + ((Object)((Object)expression)).getClass().getName());
        }
        if (expression2 == null || expression2 == expression) {
            return expression;
        }
        ModelUtils.copyAnnotations((IElement)expression, expression2);
        return expression2;
    }
}

