/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.rcfg.visitors;

import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayStoreExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssertStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssignmentStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AtomicStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BitVectorAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BitvecLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BreakStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ForkStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.FunctionApplication;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GotoStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.HavocStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IfStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IfThenElseExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.JoinStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Label;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.QuantifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.RealLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ReturnStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StringLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructConstructor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.boogie.ast.WhileStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.WildcardExpression;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.rcfg.annotations.UseDefSequence;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.rcfg.visitors.SimpleRCFGVisitor;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.rcfg.visitors.UseDefSet;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Call;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.GotoEdge;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.ParallelComposition;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Return;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.RootEdge;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.SequentialComposition;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.StatementSequence;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Summary;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public class UseDefVisitor
extends SimpleRCFGVisitor {
    public UseDefVisitor(ILogger iLogger) {
        super(iLogger);
    }

    @Override
    public void pre(IcfgEdge icfgEdge) {
        super.pre(icfgEdge);
        UseDefSequence useDefSequence = new UseDefSequence();
        if (icfgEdge instanceof StatementSequence) {
            for (Statement statement : ((StatementSequence)icfgEdge).getStatements()) {
                useDefSequence.Sequence.add(this.processStatement(statement));
            }
        } else if (icfgEdge instanceof Call) {
            useDefSequence.Sequence.add(this.processStatement((Statement)((Call)icfgEdge).getCallStatement()));
        } else {
            if (icfgEdge instanceof GotoEdge) {
                this.mLogger.info((Object)("Ignoring GotoEdge edge " + String.valueOf(icfgEdge)));
                return;
            }
            if (icfgEdge instanceof ParallelComposition) {
                this.mLogger.info((Object)("Ignoring ParallelComposition edge " + String.valueOf(icfgEdge)));
                return;
            }
            if (icfgEdge instanceof Return) {
                this.mLogger.info((Object)("Ignoring Return edge " + String.valueOf(icfgEdge)));
                return;
            }
            if (icfgEdge instanceof SequentialComposition) {
                this.mLogger.info((Object)("Ignoring SequentialComposition edge " + String.valueOf(icfgEdge)));
                return;
            }
            if (icfgEdge instanceof Summary) {
                this.mLogger.info((Object)("Ignoring summary edge " + String.valueOf(icfgEdge)));
                return;
            }
            if (icfgEdge instanceof RootEdge) {
                this.mLogger.info((Object)("Ignoring root edge " + String.valueOf(icfgEdge)));
                return;
            }
            this.mLogger.debug((Object)("Unknown edge type: " + icfgEdge.getClass().getCanonicalName() + " " + String.valueOf(icfgEdge)));
            return;
        }
        useDefSequence.addAnnotation((IElement)icfgEdge);
    }

    private UseDefSet processStatement(Statement statement) {
        UseDefSet useDefSet = new UseDefSet();
        Statement statement2 = statement;
        Objects.requireNonNull(statement2);
        Statement statement3 = statement2;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AssignmentStatement.class, AssumeStatement.class, CallStatement.class, HavocStatement.class, IfStatement.class, WhileStatement.class, BreakStatement.class, GotoStatement.class, Label.class, ReturnStatement.class, ForkStatement.class, JoinStatement.class, AssertStatement.class, AtomicStatement.class}, (Object)statement3, 0)) {
            case 0: {
                LeftHandSide leftHandSide;
                AssignmentStatement assignmentStatement = (AssignmentStatement)statement3;
                LeftHandSide[] leftHandSideArray = assignmentStatement.getLhs();
                int n = leftHandSideArray.length;
                int n2 = 0;
                while (n2 < n) {
                    leftHandSide = leftHandSideArray[n2];
                    useDefSet = useDefSet.merge(this.processLeftHandSide(leftHandSide));
                    ++n2;
                }
                leftHandSideArray = assignmentStatement.getRhs();
                n = leftHandSideArray.length;
                n2 = 0;
                while (n2 < n) {
                    leftHandSide = leftHandSideArray[n2];
                    useDefSet = useDefSet.merge(this.processExpression((Expression)leftHandSide));
                    ++n2;
                }
                return useDefSet;
            }
            case 1: {
                AssumeStatement assumeStatement = (AssumeStatement)statement3;
                return this.processExpression(assumeStatement.getFormula());
            }
            case 2: {
                VariableLHS variableLHS;
                CallStatement callStatement = (CallStatement)statement3;
                VariableLHS[] variableLHSArray = callStatement.getLhs();
                int n = variableLHSArray.length;
                int n3 = 0;
                while (n3 < n) {
                    variableLHS = variableLHSArray[n3];
                    useDefSet.Def.add(variableLHS.toString());
                    ++n3;
                }
                variableLHSArray = callStatement.getArguments();
                n = variableLHSArray.length;
                n3 = 0;
                while (n3 < n) {
                    variableLHS = variableLHSArray[n3];
                    useDefSet = useDefSet.merge(this.processExpression((Expression)variableLHS));
                    ++n3;
                }
                return useDefSet;
            }
            case 3: {
                HavocStatement havocStatement = (HavocStatement)statement3;
                VariableLHS[] variableLHSArray = havocStatement.getIdentifiers();
                int n = variableLHSArray.length;
                int n4 = 0;
                while (n4 < n) {
                    VariableLHS variableLHS = variableLHSArray[n4];
                    useDefSet.Def.add(variableLHS.toString());
                    ++n4;
                }
                return useDefSet;
            }
            case 4: {
                Statement statement4;
                IfStatement ifStatement = (IfStatement)statement3;
                this.mLogger.debug((Object)"IfStatement in edge?");
                useDefSet = this.processExpression(ifStatement.getCondition());
                Statement[] statementArray = ifStatement.getThenPart();
                int n = statementArray.length;
                int n5 = 0;
                while (n5 < n) {
                    statement4 = statementArray[n5];
                    useDefSet = useDefSet.merge(this.processStatement(statement4));
                    ++n5;
                }
                statementArray = ifStatement.getElsePart();
                n = statementArray.length;
                n5 = 0;
                while (n5 < n) {
                    statement4 = statementArray[n5];
                    useDefSet = useDefSet.merge(this.processStatement(statement4));
                    ++n5;
                }
                return useDefSet;
            }
            case 5: {
                WhileStatement whileStatement = (WhileStatement)statement3;
                this.mLogger.debug((Object)"WhileStatement in edge?");
                useDefSet = this.processExpression(whileStatement.getCondition());
                Statement[] statementArray = whileStatement.getBody();
                int n = statementArray.length;
                int n6 = 0;
                while (n6 < n) {
                    Statement statement5 = statementArray[n6];
                    useDefSet = useDefSet.merge(this.processStatement(statement5));
                    ++n6;
                }
                return useDefSet;
            }
            case 6: {
                BreakStatement breakStatement = (BreakStatement)statement3;
                return useDefSet;
            }
            case 7: {
                GotoStatement gotoStatement = (GotoStatement)statement3;
                return useDefSet;
            }
            case 8: {
                Label label = (Label)statement3;
                return useDefSet;
            }
            case 9: {
                ReturnStatement returnStatement = (ReturnStatement)statement3;
                return useDefSet;
            }
            case 10: {
                ForkStatement forkStatement = (ForkStatement)statement3;
                this.mLogger.debug((Object)("Unsupported statement type: " + statement.getClass().getCanonicalName() + " " + String.valueOf(statement)));
                return useDefSet;
            }
            case 11: {
                JoinStatement joinStatement = (JoinStatement)statement3;
                this.mLogger.debug((Object)("Unsupported statement type: " + statement.getClass().getCanonicalName() + " " + String.valueOf(statement)));
                return useDefSet;
            }
            case 12: {
                AssertStatement assertStatement = (AssertStatement)statement3;
                this.mLogger.debug((Object)("Unsupported statement type: " + statement.getClass().getCanonicalName() + " " + String.valueOf(statement)));
                return useDefSet;
            }
            case 13: {
                AtomicStatement atomicStatement = (AtomicStatement)statement3;
                this.mLogger.debug((Object)("Unsupported statement type: " + statement.getClass().getCanonicalName() + " " + String.valueOf(statement)));
                return useDefSet;
            }
        }
        throw new MatchException(null, null);
    }

    private UseDefSet processExpression(Expression expression) {
        UseDefSet useDefSet = new UseDefSet();
        Expression expression2 = expression;
        Objects.requireNonNull(expression2);
        Expression expression3 = expression2;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ArrayAccessExpression.class, BinaryExpression.class, FunctionApplication.class, IdentifierExpression.class, IfThenElseExpression.class, UnaryExpression.class, BitvecLiteral.class, BooleanLiteral.class, IntegerLiteral.class, RealLiteral.class, StringLiteral.class, WildcardExpression.class, QuantifierExpression.class, StructAccessExpression.class, ArrayStoreExpression.class, StructConstructor.class, BitVectorAccessExpression.class}, (Object)expression3, 0)) {
            case 0: {
                ArrayAccessExpression arrayAccessExpression = (ArrayAccessExpression)expression3;
                useDefSet = useDefSet.merge(this.processExpression(arrayAccessExpression.getArray()));
                Expression[] expressionArray = arrayAccessExpression.getIndices();
                int n = expressionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Expression expression4 = expressionArray[n2];
                    useDefSet = useDefSet.merge(this.processExpression(expression4));
                    ++n2;
                }
                return useDefSet;
            }
            case 1: {
                BinaryExpression binaryExpression = (BinaryExpression)expression3;
                return this.processExpression(binaryExpression.getLeft()).merge(this.processExpression(binaryExpression.getRight()));
            }
            case 2: {
                FunctionApplication functionApplication = (FunctionApplication)expression3;
                Expression[] expressionArray = functionApplication.getArguments();
                int n = expressionArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Expression expression5 = expressionArray[n3];
                    useDefSet = useDefSet.merge(this.processExpression(expression5));
                    ++n3;
                }
                return useDefSet;
            }
            case 3: {
                IdentifierExpression identifierExpression = (IdentifierExpression)expression3;
                useDefSet.Use.add(identifierExpression.getIdentifier());
                return useDefSet;
            }
            case 4: {
                IfThenElseExpression ifThenElseExpression = (IfThenElseExpression)expression3;
                useDefSet = useDefSet.merge(this.processExpression(ifThenElseExpression.getCondition()));
                useDefSet = useDefSet.merge(this.processExpression(ifThenElseExpression.getThenPart()));
                useDefSet = useDefSet.merge(this.processExpression(ifThenElseExpression.getElsePart()));
                return useDefSet;
            }
            case 5: {
                UnaryExpression unaryExpression = (UnaryExpression)expression3;
                return this.processExpression(unaryExpression.getExpr());
            }
            case 6: {
                BitvecLiteral bitvecLiteral = (BitvecLiteral)expression3;
                return useDefSet;
            }
            case 7: {
                BooleanLiteral booleanLiteral = (BooleanLiteral)expression3;
                return useDefSet;
            }
            case 8: {
                IntegerLiteral integerLiteral = (IntegerLiteral)expression3;
                return useDefSet;
            }
            case 9: {
                RealLiteral realLiteral = (RealLiteral)expression3;
                return useDefSet;
            }
            case 10: {
                StringLiteral stringLiteral = (StringLiteral)expression3;
                return useDefSet;
            }
            case 11: {
                WildcardExpression wildcardExpression = (WildcardExpression)expression3;
                return useDefSet;
            }
            case 12: {
                QuantifierExpression quantifierExpression = (QuantifierExpression)expression3;
                this.mLogger.warn((Object)"Ignoring quantifier expression");
                return useDefSet;
            }
            case 13: {
                StructAccessExpression structAccessExpression = (StructAccessExpression)expression3;
                this.mLogger.debug((Object)("Unsupported expression type: " + expression.getClass().getCanonicalName() + " " + String.valueOf(expression)));
                return useDefSet;
            }
            case 14: {
                ArrayStoreExpression arrayStoreExpression = (ArrayStoreExpression)expression3;
                this.mLogger.debug((Object)("Unsupported expression type: " + expression.getClass().getCanonicalName() + " " + String.valueOf(expression)));
                return useDefSet;
            }
            case 15: {
                StructConstructor structConstructor = (StructConstructor)expression3;
                this.mLogger.debug((Object)("Unsupported expression type: " + expression.getClass().getCanonicalName() + " " + String.valueOf(expression)));
                return useDefSet;
            }
            case 16: {
                BitVectorAccessExpression bitVectorAccessExpression = (BitVectorAccessExpression)expression3;
                this.mLogger.debug((Object)("Unsupported expression type: " + expression.getClass().getCanonicalName() + " " + String.valueOf(expression)));
                return useDefSet;
            }
        }
        throw new MatchException(null, null);
    }

    private UseDefSet processLeftHandSide(LeftHandSide leftHandSide) {
        UseDefSet useDefSet = new UseDefSet();
        if (leftHandSide instanceof VariableLHS) {
            VariableLHS variableLHS = (VariableLHS)leftHandSide;
            useDefSet.Def.add(variableLHS.getIdentifier());
            return useDefSet;
        }
        this.mLogger.debug((Object)("Unknown LeftHandSide type: " + leftHandSide.getClass().getCanonicalName() + " " + String.valueOf(leftHandSide)));
        return useDefSet;
    }

    public boolean performedChanges() {
        return false;
    }

    @Override
    public boolean abortCurrentBranch() {
        return false;
    }

    @Override
    public boolean abortAll() {
        return false;
    }
}

