/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.LocArrayInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.MemlocArrayManager;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.EdgeInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.StoreInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.SubtreePosition;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.transformers.PositionAwareSubstitution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SubTermFinder;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSort;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ArrayEqualityLocUpdateInfo {
    private final Map<SubtreePosition, StoreInfo> mRelPositionToInnerStoreInfo = new HashMap<SubtreePosition, StoreInfo>();
    private boolean mFinalized;
    private final EdgeInfo mEdge;
    private final MemlocArrayManager mLocArrayManager;
    private Term mFormulaWithLocUpdates;
    private final Map<IProgramVar, TermVariable> mExtraInVars = new HashMap<IProgramVar, TermVariable>();
    private final Map<IProgramVar, TermVariable> mExtraOutVars = new HashMap<IProgramVar, TermVariable>();
    private final Collection<TermVariable> mExtraAuxVars = new HashSet<TermVariable>();
    private final Collection<IProgramConst> mExtraConstants = new HashSet<IProgramConst>();
    private final ApplicationTerm mEquality;
    private final ManagedScript mMgdScript;
    private final Set<IProgramVar> mDefinitelyUnconstrainedVariables;

    public ArrayEqualityLocUpdateInfo(ManagedScript managedScript, ApplicationTerm applicationTerm, EdgeInfo edgeInfo, MemlocArrayManager memlocArrayManager, Set<IProgramVar> set) {
        this.mMgdScript = managedScript;
        this.mEdge = edgeInfo;
        this.mLocArrayManager = memlocArrayManager;
        this.mEquality = applicationTerm;
        this.mDefinitelyUnconstrainedVariables = set;
    }

    public void addEnclosedStoreInfo(StoreInfo storeInfo, SubtreePosition subtreePosition) {
        if (this.mFinalized) {
            throw new AssertionError();
        }
        this.mRelPositionToInnerStoreInfo.put(subtreePosition, storeInfo);
    }

    private void computeResult() {
        assert (!this.mFinalized);
        Set<Term> set = ArrayEqualityLocUpdateInfo.extractBaseArrayTerms(this.mEquality);
        Set set2 = set.stream().filter(term -> this.mLocArrayManager.isArrayTermSubjectToSeparation(this.mEdge, (Term)term)).collect(Collectors.toSet());
        int n = this.computeDimensionality();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(this.mEquality);
        int n2 = 1;
        while (n2 <= n) {
            Object object;
            Term term32;
            int n3 = n2;
            HashMap<Term, Term> hashMap = new HashMap<Term, Term>();
            for (Term term32 : set2) {
                object = this.mLocArrayManager.getOrConstructLocArray(this.mEdge, term32, n3);
                hashMap.put(term32, ((LocArrayInfo)object).getTerm());
                if (this.mEdge.getInVars().containsValue(term32) && (!this.isDefinitelyUnconstrained(term32) || this.mEdge.getOutVar(term32) != this.mEdge.getInVar(term32))) {
                    this.mExtraInVars.put((IProgramVar)((LocArrayInfo)object).getPvoc(), (TermVariable)((LocArrayInfo)object).getTerm());
                }
                if (this.mEdge.getOutVars().containsValue(term32)) {
                    this.mExtraOutVars.put((IProgramVar)((LocArrayInfo)object).getPvoc(), (TermVariable)((LocArrayInfo)object).getTerm());
                }
                if (this.mEdge.getAuxVars().contains(term32)) {
                    this.mExtraAuxVars.add((TermVariable)((LocArrayInfo)object).getTerm());
                }
                if (!this.mEdge.getNonTheoryConsts().stream().map(iProgramConst -> iProgramConst.getTerm()).anyMatch(term2 -> term2.equals(term32))) continue;
                this.mExtraConstants.add((IProgramConst)((LocArrayInfo)object).getPvoc());
            }
            List list = this.mRelPositionToInnerStoreInfo.values().stream().filter(storeInfo -> storeInfo.getDimension() == n3).collect(Collectors.toList());
            object = new HashMap();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                StoreInfo storeInfo2 = (StoreInfo)iterator.next();
                object.put(storeInfo2.getPositionOfStoredValueRelativeToEquality(), storeInfo2.getLocLiteral().getTerm());
                this.mExtraConstants.add(storeInfo2.getLocLiteral());
            }
            term32 = new PositionAwareSubstitution(this.mMgdScript, (Map<? extends SubtreePosition, ? extends Term>)object, hashMap).transform((Term)this.mEquality);
            arrayList.add(term32);
            ++n2;
        }
        this.mFormulaWithLocUpdates = SmtUtils.and((Script)this.mMgdScript.getScript(), arrayList);
        this.mFinalized = true;
    }

    private boolean isDefinitelyUnconstrained(Term term) {
        IProgramVar iProgramVar;
        return term instanceof TermVariable && this.mDefinitelyUnconstrainedVariables.contains(iProgramVar = this.mEdge.getInVar(term));
    }

    public int computeDimensionality() {
        int n = new MultiDimensionalSort(this.mEquality.getParameters()[0].getSort()).getDimension();
        assert (this.mRelPositionToInnerStoreInfo.get(new SubtreePosition().append(0)) == null || n == this.mRelPositionToInnerStoreInfo.get(new SubtreePosition().append(0)).getArrayGroup().getDimensionality());
        assert (this.mRelPositionToInnerStoreInfo.get(new SubtreePosition().append(1)) == null || n == this.mRelPositionToInnerStoreInfo.get(new SubtreePosition().append(1)).getArrayGroup().getDimensionality());
        return n;
    }

    private static Set<Term> extractBaseArrayTerms(ApplicationTerm applicationTerm) {
        Predicate<Term> predicate = term -> SmtUtils.isBasicArrayTerm((Term)term);
        return SubTermFinder.find((Term)applicationTerm, predicate, (boolean)false);
    }

    public Term getFormulaWithLocUpdates() {
        if (!this.mFinalized) {
            this.computeResult();
        }
        return this.mFormulaWithLocUpdates;
    }

    public Map<? extends IProgramVar, ? extends TermVariable> getExtraInVars() {
        if (!this.mFinalized) {
            this.computeResult();
        }
        return this.mExtraInVars;
    }

    public Map<? extends IProgramVar, ? extends TermVariable> getExtraOutVars() {
        if (!this.mFinalized) {
            this.computeResult();
        }
        return this.mExtraOutVars;
    }

    public Collection<? extends TermVariable> getExtraAuxVars() {
        if (!this.mFinalized) {
            this.computeResult();
        }
        return this.mExtraAuxVars;
    }

    public Collection<? extends IProgramConst> getExtraConstants() {
        if (!this.mFinalized) {
            this.computeResult();
        }
        return this.mExtraConstants;
    }

    public String toString() {
        return "ArrayEqualityLocUpdateInfo [mEquality=" + String.valueOf(this.mEquality) + "]";
    }
}

