/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol;

import de.uni_freiburg.informatik.ultimate.smtinterpol.ChannelUtil;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Formatter;
import java.util.Locale;

public class DefaultLogger
implements LogProxy {
    private static final Object LOCK = new Object();
    private static final String[] LEVELS = new String[]{"FATAL", "ERROR", "WARN", "INFO", "DEBUG", "TRACE"};
    private PrintWriter mWriter = new PrintWriter(System.err);
    private Formatter mFormat = new Formatter(this.mWriter, Locale.ROOT);
    private String mDest = "stderr";
    private int mLevel = 4;

    @Override
    public void setLoglevel(int n) {
        this.mLevel = n;
    }

    @Override
    public int getLoglevel() {
        return this.mLevel;
    }

    private final boolean isEnabled(int n) {
        return n <= this.mLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void log(int n, Object object) {
        Object object2 = LOCK;
        synchronized (object2) {
            this.mWriter.print(LEVELS[n - 1]);
            this.mWriter.print(" - ");
            this.mWriter.println(object);
            this.mWriter.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void log(int n, String string, Object[] objectArray) {
        Object object = LOCK;
        synchronized (object) {
            this.mWriter.print(LEVELS[n - 1]);
            this.mWriter.print(" - ");
            this.mFormat.format(string, objectArray);
            this.mWriter.println();
            this.mWriter.flush();
        }
    }

    @Override
    public boolean isFatalEnabled() {
        return this.isEnabled(1);
    }

    @Override
    public void fatal(String string, Object ... objectArray) {
        if (this.isFatalEnabled()) {
            this.log(1, string, objectArray);
        }
    }

    @Override
    public void fatal(Object object) {
        if (this.isFatalEnabled()) {
            this.log(1, object);
        }
    }

    @Override
    public void outOfMemory(String string) {
        if (this.isFatalEnabled()) {
            this.log(1, string);
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isEnabled(2);
    }

    @Override
    public void error(String string, Object ... objectArray) {
        if (this.isErrorEnabled()) {
            this.log(2, string, objectArray);
        }
    }

    @Override
    public void error(Object object) {
        if (this.isErrorEnabled()) {
            this.log(2, object);
        }
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isEnabled(3);
    }

    @Override
    public void warn(String string, Object ... objectArray) {
        if (this.isWarnEnabled()) {
            this.log(3, string, objectArray);
        }
    }

    @Override
    public void warn(Object object) {
        if (this.isWarnEnabled()) {
            this.log(3, object);
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isEnabled(4);
    }

    @Override
    public void info(String string, Object ... objectArray) {
        if (this.isInfoEnabled()) {
            this.log(4, string, objectArray);
        }
    }

    @Override
    public void info(Object object) {
        if (this.isInfoEnabled()) {
            this.log(4, object);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isEnabled(5);
    }

    @Override
    public void debug(String string, Object ... objectArray) {
        if (this.isDebugEnabled()) {
            this.log(5, string, objectArray);
        }
    }

    @Override
    public void debug(Object object) {
        if (this.isDebugEnabled()) {
            this.log(5, object);
        }
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isEnabled(6);
    }

    @Override
    public void trace(String string, Object ... objectArray) {
        if (this.isTraceEnabled()) {
            this.log(6, string, objectArray);
        }
    }

    @Override
    public void trace(Object object) {
        if (this.isTraceEnabled()) {
            this.log(6, object);
        }
    }

    @Override
    public boolean canChangeDestination() {
        return true;
    }

    @Override
    public void changeDestination(String string) throws IOException {
        this.mWriter = ChannelUtil.createChannel(string);
        this.mFormat = new Formatter(this.mWriter, Locale.ROOT);
        this.mDest = string;
    }

    @Override
    public String getDestination() {
        return this.mDest;
    }
}

