/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.InterpolatorAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitesimalNumber;

public class InterpolatorAtomInfo {
    private boolean mIsCCEquality = false;
    private boolean mIsLAEquality = false;
    private boolean mIsBoundConstraint = false;
    private ApplicationTerm mCCEquality;
    private InterpolatorAffineTerm mAffineTerm = null;
    private boolean mIsInt = false;

    public InterpolatorAtomInfo(Term term) {
        this.computeAtomInfo(term);
    }

    public void computeAtomInfo(Term term) {
        if (term instanceof ApplicationTerm && ((ApplicationTerm)term).getFunction().isIntern()) {
            boolean bl;
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            assert (!applicationTerm.getFunction().getName().equals("not"));
            String string = applicationTerm.getFunction().getName();
            boolean bl2 = bl = string == "=";
            if (bl && !InterpolatorAtomInfo.isZero(applicationTerm.getParameters()[1])) {
                this.mIsCCEquality = true;
                this.mCCEquality = applicationTerm;
            } else if (bl || string == "<=" || string == "<") {
                this.computeLAInformation(applicationTerm);
            }
        }
    }

    private static boolean isZero(Term term) {
        return term instanceof ConstantTerm && ((ConstantTerm)term).getValue() == Rational.ZERO;
    }

    private void computeLAInformation(ApplicationTerm applicationTerm) {
        boolean bl = false;
        switch (applicationTerm.getFunction().getName()) {
            case "<=": {
                this.mIsBoundConstraint = true;
                break;
            }
            case "<": {
                this.mIsBoundConstraint = true;
                bl = true;
                break;
            }
            case "=": {
                this.mIsLAEquality = true;
                break;
            }
            default: {
                throw new AssertionError((Object)"Malformed LA term.");
            }
        }
        Term[] termArray = applicationTerm.getParameters();
        assert (termArray[1] == Rational.ZERO.toTerm(termArray[1].getSort()));
        this.mIsInt = termArray[1].getSort().getName().equals("Int");
        this.mAffineTerm = new InterpolatorAffineTerm(new SMTAffineTerm(termArray[0]));
        assert (this.mAffineTerm.getConstant().mEps == 0);
        if (bl) {
            this.mAffineTerm.add(this.getEpsilon());
        }
    }

    public boolean isCCEquality() {
        return this.mIsCCEquality;
    }

    public boolean isLAEquality() {
        return this.mIsLAEquality;
    }

    public boolean isBoundConstraint() {
        return this.mIsBoundConstraint;
    }

    public ApplicationTerm getEquality() {
        return this.mCCEquality;
    }

    public InterpolatorAffineTerm getAffineTerm() {
        return this.mAffineTerm;
    }

    public InfinitesimalNumber getEpsilon() {
        return this.isInt() ? InfinitesimalNumber.ONE : InfinitesimalNumber.EPSILON;
    }

    public boolean isInt() {
        return this.mIsInt;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AtomInfo(");
        if (this.isCCEquality()) {
            stringBuilder.append("CC:").append(this.getEquality());
        } else if (this.isLAEquality()) {
            stringBuilder.append("LA:").append(this.getAffineTerm()).append(" == 0");
            if (!this.isInt()) {
                stringBuilder.append(".0");
            }
        } else if (this.isBoundConstraint()) {
            stringBuilder.append("LA:").append(this.getAffineTerm()).append(" <= 0");
            if (!this.isInt()) {
                stringBuilder.append(".0");
            }
        } else {
            stringBuilder.append("NOINFO");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

