/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Clausifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.util.Pair;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantifierTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.CompareCode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.EMatching;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.FindCode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.GetArgCode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.ICode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.ReverseCode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.YieldCode;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PatternCompiler {
    private final QuantifierTheory mQuantTheory;
    private final EMatching mEMatching;
    private final QuantLiteral mQuantAtom;
    private final Term[] mPatterns;
    private int mNextFreeRegIndex;
    private final Map<Term, TermInfo> mTermInfos;

    public PatternCompiler(QuantifierTheory quantifierTheory, QuantLiteral quantLiteral, Term[] termArray) {
        this.mQuantTheory = quantifierTheory;
        this.mEMatching = quantifierTheory.getEMatching();
        assert (quantLiteral.getAtom() == quantLiteral);
        this.mQuantAtom = quantLiteral;
        this.mPatterns = termArray;
        this.mNextFreeRegIndex = 1;
        this.mTermInfos = new HashMap<Term, TermInfo>();
    }

    public Pair<ICode, CCTerm[]> compile() {
        this.collectTermInfos(this.mPatterns);
        ICode iCode = this.generateCode();
        CCTerm[] cCTermArray = new CCTerm[this.getNextFreeRegIndex()];
        for (TermInfo termInfo : this.mTermInfos.values()) {
            if (termInfo.mGroundTerm == null) continue;
            cCTermArray[termInfo.mRegIndex] = termInfo.mGroundTerm;
        }
        return new Pair<ICode, CCTerm[]>(iCode, cCTermArray);
    }

    private void collectTermInfos(Term[] termArray) {
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray2[n2];
            this.collectTermInfos(term);
            ++n2;
        }
    }

    private void collectTermInfos(Term term) {
        if (this.mTermInfos.containsKey(term)) {
            TermInfo termInfo = this.mTermInfos.get(term);
            ++termInfo.mNumOccur;
            return;
        }
        TermInfo termInfo = new TermInfo(this.getNextFreeRegIndex());
        if (term.getFreeVars().length == 0) {
            Clausifier clausifier = this.mEMatching.getQuantTheory().getClausifier();
            termInfo.mGroundTerm = clausifier.createCCTerm(term, this.mQuantAtom.getClause().getSource());
        } else if (!(term instanceof TermVariable)) {
            assert (term instanceof ApplicationTerm);
            Term[] termArray = ((ApplicationTerm)term).getParameters();
            int n = -1;
            int n2 = 0;
            while (n2 < termArray.length) {
                if (this.mTermInfos.containsKey(termArray[n2])) {
                    n = n2;
                    break;
                }
                if (termArray[n2].getFreeVars().length == 0) {
                    n = n2;
                    break;
                }
                if (this.hasProcessedOrGroundOrNonVarSubterms(termArray[n2]) && n == -1) {
                    n = n2;
                }
                ++n2;
            }
            termInfo.mStartArgIndex = n;
            BitSet bitSet = new BitSet(termArray.length);
            if (n >= 0) {
                this.collectTermInfos(termArray[n]);
                bitSet.set(n);
            }
            while (bitSet.cardinality() != termArray.length) {
                int n3 = bitSet.nextClearBit(0);
                while (n3 < termArray.length) {
                    if (!this.mTermInfos.containsKey(termArray[n3]) && termArray[n3] instanceof TermVariable) {
                        this.collectTermInfos(termArray[n3]);
                        termInfo.mArgumentOrder.add(n3);
                        bitSet.set(n3);
                    }
                    n3 = bitSet.nextClearBit(n3 + 1);
                }
                n3 = bitSet.nextClearBit(0);
                while (n3 < termArray.length) {
                    if (this.mTermInfos.containsKey(termArray[n3]) || termArray[n3].getFreeVars().length == 0) {
                        this.collectTermInfos(termArray[n3]);
                        termInfo.mArgumentOrder.add(n3);
                        bitSet.set(n3);
                    }
                    n3 = bitSet.nextClearBit(n3 + 1);
                }
                n3 = bitSet.nextClearBit(0);
                if (n3 >= termArray.length) continue;
                assert (!this.mTermInfos.containsKey(termArray[n3]) && !(termArray[n3] instanceof TermVariable) && termArray[n3].getFreeVars().length != 0);
                this.collectTermInfos(termArray[n3]);
                termInfo.mArgumentOrder.add(n3);
                bitSet.set(n3);
            }
            assert (termInfo.mArgumentOrder.size() + (termInfo.mStartArgIndex >= 0 ? 1 : 0) == termArray.length);
        }
        this.mTermInfos.put(term, termInfo);
    }

    protected ICode generateCode() {
        Object object;
        HashMap<TermVariable, Integer> hashMap = new HashMap<TermVariable, Integer>();
        HashMap<Term, Integer> hashMap2 = new HashMap<Term, Integer>();
        Object object2 = this.mQuantAtom.getTerm().getFreeVars();
        int n = ((TermVariable[])object2).length;
        int n2 = 0;
        while (n2 < n) {
            object = object2[n2];
            assert (this.mEMatching.isPartiallyUsingEmatching(this.mQuantAtom) || this.mTermInfos.containsKey(object));
            if (this.mTermInfos.containsKey(object)) {
                hashMap.put((TermVariable)object, this.mTermInfos.get((Object)object).mRegIndex);
                hashMap2.put((Term)object, this.mTermInfos.get((Object)object).mRegIndex);
            }
            ++n2;
        }
        object2 = this.mPatterns;
        n = this.mPatterns.length;
        n2 = 0;
        while (n2 < n) {
            object = object2[n2];
            hashMap2.put((Term)object, this.mTermInfos.get((Object)object).mRegIndex);
            ++n2;
        }
        object = new YieldCode(this.mEMatching, this.mQuantAtom, this.mQuantAtom.getClause().getVars(), hashMap, hashMap2);
        n2 = this.mPatterns.length - 1;
        while (n2 >= 0) {
            Term term = this.mPatterns[n2];
            object2 = this.mTermInfos.get(term);
            ++object2.mNumSeen;
            object = this.generateCode(term, (ICode)object);
            --n2;
        }
        return object;
    }

    private ICode generateCode(Term term, ICode iCode) {
        Object object;
        TermInfo termInfo;
        int n;
        TermInfo termInfo2 = this.mTermInfos.get(term);
        if (termInfo2.mNumSeen < termInfo2.mNumOccur || term instanceof TermVariable || term.getFreeVars().length == 0) {
            return iCode;
        }
        FunctionSymbol functionSymbol = ((ApplicationTerm)term).getFunction();
        Term[] termArray = ((ApplicationTerm)term).getParameters();
        ICode iCode2 = iCode;
        if (termArray.length > 0) {
            n = termInfo2.mArgumentOrder.size() - 1;
            while (n >= 0) {
                int n2 = termInfo2.mArgumentOrder.get(n);
                termInfo = termArray[n2];
                object = this.mTermInfos.get(termInfo);
                ++((TermInfo)object).mNumSeen;
                if (termInfo instanceof TermVariable && ((TermInfo)object).mNumSeen == ((TermInfo)object).mNumOccur) {
                    iCode2 = new GetArgCode(this.mEMatching, termInfo2.mRegIndex, functionSymbol, n2, ((TermInfo)object).mRegIndex, iCode2);
                } else {
                    iCode2 = new CompareCode(this.mEMatching, ((TermInfo)object).mRegIndex, 0, iCode2);
                    iCode2 = new GetArgCode(this.mEMatching, termInfo2.mRegIndex, functionSymbol, n2, 0, iCode2);
                    iCode2 = this.generateCode((Term)termInfo, iCode2);
                }
                --n;
            }
        }
        if (termInfo2.mStartArgIndex >= 0) {
            n = termInfo2.mStartArgIndex;
            Term term2 = termArray[n];
            termInfo = this.mTermInfos.get(term2);
            ++termInfo.mNumSeen;
            object = new ReverseCode(this.mEMatching, termInfo.mRegIndex, functionSymbol, termInfo2.mStartArgIndex, termInfo2.mRegIndex, iCode2);
            return this.generateCode(term2, (ICode)object);
        }
        return new FindCode(this.mEMatching, this.mQuantTheory.getCClosure(), functionSymbol, termInfo2.mRegIndex, iCode2);
    }

    private int getNextFreeRegIndex() {
        return this.mNextFreeRegIndex++;
    }

    private boolean hasProcessedOrGroundOrNonVarSubterms(Term term) {
        if (term instanceof ApplicationTerm) {
            Term[] termArray = ((ApplicationTerm)term).getParameters();
            int n = 0;
            while (n < termArray.length) {
                if (this.mTermInfos.containsKey(termArray[n]) || termArray[n].getFreeVars().length == 0 || !(termArray[n] instanceof TermVariable)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    class TermInfo {
        CCTerm mGroundTerm;
        int mNumOccur = 1;
        int mNumSeen = 0;
        final int mRegIndex;
        int mStartArgIndex;
        List<Integer> mArgumentOrder;

        TermInfo(int n) {
            this.mRegIndex = n;
            this.mStartArgIndex = -1;
            this.mArgumentOrder = new ArrayList<Integer>();
        }

        public String toString() {
            return "{occ:" + this.mNumOccur + ",seen:" + this.mNumSeen + ",regIndex:" + this.mRegIndex + ",startArgIndex:" + this.mStartArgIndex + "}";
        }
    }
}

