/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.empty;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public final class EmptyDomainState
implements IAbstractState<EmptyDomainState> {
    private static int sId;
    private final ImmutableSet<IProgramVarOrConst> mVarDecls;
    private final int mId;
    private final boolean mIsBottom;

    protected EmptyDomainState() {
        this((ImmutableSet<IProgramVarOrConst>)ImmutableSet.empty());
    }

    protected EmptyDomainState(boolean bl) {
        this((ImmutableSet<IProgramVarOrConst>)ImmutableSet.empty(), bl);
    }

    protected EmptyDomainState(ImmutableSet<IProgramVarOrConst> immutableSet) {
        this(immutableSet, false);
    }

    protected EmptyDomainState(ImmutableSet<IProgramVarOrConst> immutableSet, boolean bl) {
        this.mVarDecls = immutableSet;
        this.mId = ++sId;
        this.mIsBottom = bl;
    }

    public EmptyDomainState addVariable(IProgramVarOrConst iProgramVarOrConst) {
        assert (iProgramVarOrConst != null);
        HashSet<IProgramVarOrConst> hashSet = new HashSet<IProgramVarOrConst>((Collection<IProgramVarOrConst>)this.mVarDecls);
        if (!hashSet.add(iProgramVarOrConst)) {
            throw new UnsupportedOperationException("Variable names have to be disjoint");
        }
        return new EmptyDomainState((ImmutableSet<IProgramVarOrConst>)ImmutableSet.of(hashSet));
    }

    public EmptyDomainState removeVariable(IProgramVarOrConst iProgramVarOrConst) {
        assert (iProgramVarOrConst != null);
        HashSet<IProgramVarOrConst> hashSet = new HashSet<IProgramVarOrConst>((Collection<IProgramVarOrConst>)this.mVarDecls);
        boolean bl = hashSet.remove(iProgramVarOrConst);
        assert (bl);
        return new EmptyDomainState((ImmutableSet<IProgramVarOrConst>)ImmutableSet.of(hashSet));
    }

    public EmptyDomainState addVariables(Collection<IProgramVarOrConst> collection) {
        assert (collection != null);
        assert (!collection.isEmpty());
        HashSet<IProgramVarOrConst> hashSet = new HashSet<IProgramVarOrConst>((Collection<IProgramVarOrConst>)this.mVarDecls);
        for (IProgramVarOrConst iProgramVarOrConst : collection) {
            if (hashSet.add(iProgramVarOrConst)) continue;
            throw new UnsupportedOperationException("Variable names have to be disjoint");
        }
        return new EmptyDomainState((ImmutableSet<IProgramVarOrConst>)ImmutableSet.of(hashSet));
    }

    public EmptyDomainState removeVariables(Collection<IProgramVarOrConst> collection) {
        assert (collection != null);
        assert (!collection.isEmpty());
        HashSet<IProgramVarOrConst> hashSet = new HashSet<IProgramVarOrConst>((Collection<IProgramVarOrConst>)this.mVarDecls);
        for (IProgramVarOrConst iProgramVarOrConst : collection) {
            hashSet.remove(iProgramVarOrConst);
        }
        return new EmptyDomainState((ImmutableSet<IProgramVarOrConst>)ImmutableSet.of(hashSet));
    }

    public boolean isEmpty() {
        return this.mVarDecls.isEmpty();
    }

    public boolean isBottom() {
        return this.mIsBottom;
    }

    public String toLogString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (IProgramVarOrConst iProgramVarOrConst : this.mVarDecls) {
            stringBuilder.append(iProgramVarOrConst).append("; ");
        }
        return stringBuilder.toString();
    }

    public boolean isEqualTo(EmptyDomainState emptyDomainState) {
        if (emptyDomainState == null) {
            return false;
        }
        if (emptyDomainState.equals(this)) {
            return true;
        }
        if (emptyDomainState.mVarDecls.size() != this.mVarDecls.size()) {
            return false;
        }
        for (IProgramVarOrConst iProgramVarOrConst : this.mVarDecls) {
            if (emptyDomainState.mVarDecls.contains((Object)iProgramVarOrConst)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.toLogString();
    }

    public int hashCode() {
        return this.mId;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EmptyDomainState emptyDomainState = (EmptyDomainState)object;
        return this.mId == emptyDomainState.mId;
    }

    boolean hasSameVariables(EmptyDomainState emptyDomainState) {
        return this.isEqualTo(emptyDomainState);
    }

    public ImmutableSet<IProgramVarOrConst> getVariables() {
        return this.mVarDecls;
    }

    public boolean containsVariable(IProgramVarOrConst iProgramVarOrConst) {
        return this.mVarDecls.contains((Object)iProgramVarOrConst);
    }

    public Term getTerm(Script script) {
        return script.term("true", new Term[0]);
    }

    public EmptyDomainState patch(EmptyDomainState emptyDomainState) {
        if (emptyDomainState.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return emptyDomainState;
        }
        HashSet<IProgramVarOrConst> hashSet = new HashSet<IProgramVarOrConst>();
        hashSet.addAll((Collection<IProgramVarOrConst>)this.mVarDecls);
        hashSet.addAll((Collection<IProgramVarOrConst>)emptyDomainState.mVarDecls);
        if (hashSet.size() == this.mVarDecls.size()) {
            return this;
        }
        return new EmptyDomainState((ImmutableSet<IProgramVarOrConst>)ImmutableSet.of(hashSet));
    }

    public IAbstractState.SubsetResult isSubsetOf(EmptyDomainState emptyDomainState) {
        assert (this.hasSameVariables(emptyDomainState));
        return this.isEqualTo(emptyDomainState) ? IAbstractState.SubsetResult.EQUAL : IAbstractState.SubsetResult.NONE;
    }

    public EmptyDomainState intersect(EmptyDomainState emptyDomainState) {
        if (!this.hasSameVariables(emptyDomainState)) {
            throw new UnsupportedOperationException("Cannot widen or merge two states with different variables");
        }
        return this;
    }

    public EmptyDomainState union(EmptyDomainState emptyDomainState) {
        return this.intersect(emptyDomainState);
    }

    public EmptyDomainState compact() {
        return this;
    }

    public EmptyDomainState renameVariables(Map<IProgramVarOrConst, IProgramVarOrConst> map) {
        if (map == null || map.isEmpty()) {
            return this;
        }
        boolean bl = false;
        HashSet<IProgramVarOrConst> hashSet = new HashSet<IProgramVarOrConst>((Collection<IProgramVarOrConst>)this.mVarDecls);
        for (Map.Entry<IProgramVarOrConst, IProgramVarOrConst> entry : map.entrySet()) {
            IProgramVarOrConst iProgramVarOrConst = entry.getKey();
            IProgramVarOrConst iProgramVarOrConst2 = entry.getValue();
            if (iProgramVarOrConst2 == null) {
                throw new IllegalArgumentException("Cannot rename " + String.valueOf(iProgramVarOrConst) + " to null");
            }
            if (iProgramVarOrConst == iProgramVarOrConst2 || !hashSet.remove(iProgramVarOrConst)) continue;
            bl = true;
            hashSet.add(iProgramVarOrConst2);
        }
        if (bl) {
            return new EmptyDomainState((ImmutableSet<IProgramVarOrConst>)ImmutableSet.of(hashSet));
        }
        return this;
    }
}

