/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.LambdaTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class TermTransformer
extends NonRecursive {
    private final ArrayList<HashMap<Term, Term>> mCache = new ArrayList();
    private final ScopedHashMap<TermVariable, Integer> mScopeMap = new ScopedHashMap();
    private final ArrayDeque<Term> mConverted = new ArrayDeque();
    private final ArrayDeque<Object[]> mConvertedArrays = new ArrayDeque();

    protected final void pushTerms(Term[] termArray) {
        int n = termArray.length - 1;
        while (n >= 0) {
            this.pushTerm(termArray[n]);
            --n;
        }
    }

    protected final void pushTerm(Term term) {
        this.enqueueWalker(new Convert(term));
    }

    protected final void setResult(Term term) {
        this.mConverted.addLast(term);
    }

    private int findScope(TermVariable[] termVariableArray) {
        int n = 0;
        TermVariable[] termVariableArray2 = termVariableArray;
        int n2 = termVariableArray.length;
        int n3 = 0;
        while (n3 < n2) {
            TermVariable termVariable = termVariableArray2[n3];
            Integer n4 = (Integer)this.mScopeMap.get((Object)termVariable);
            if (n4 != null && n4 > n) {
                n = n4;
            }
            ++n3;
        }
        return n;
    }

    private void cacheConvert(Term term) {
        int n = this.findScope(term.getFreeVars());
        Term term2 = this.mCache.get(n).get(term);
        if (term2 == null) {
            this.enqueueWalker(new AddCache(term));
            this.convert(term);
        } else {
            this.setResult(term2);
        }
    }

    protected void beginScope(TermVariable[] termVariableArray) {
        Integer n = this.mCache.size();
        this.mCache.add(new HashMap());
        this.mScopeMap.beginScope();
        TermVariable[] termVariableArray2 = termVariableArray;
        int n2 = termVariableArray.length;
        int n3 = 0;
        while (n3 < n2) {
            TermVariable termVariable = termVariableArray2[n3];
            this.mScopeMap.put((Object)termVariable, (Object)n);
            ++n3;
        }
    }

    protected void endScope() {
        int n = this.mCache.size() - 1;
        this.mCache.remove(n);
        this.mScopeMap.endScope();
    }

    protected void convert(Term term) {
        if (term instanceof ConstantTerm || term instanceof TermVariable) {
            this.mConverted.addLast(term);
        } else if (term instanceof ApplicationTerm) {
            this.enqueueWalker(new BuildApplicationTerm((ApplicationTerm)term));
            this.pushTerms(((ApplicationTerm)term).getParameters());
        } else if (term instanceof LetTerm) {
            this.enqueueWalker(new StartLetTerm((LetTerm)term));
            this.pushTerms(((LetTerm)term).getValues());
        } else if (term instanceof QuantifiedFormula) {
            QuantifiedFormula quantifiedFormula = (QuantifiedFormula)term;
            this.enqueueWalker(new BuildQuantifier(quantifiedFormula));
            this.pushTerm(quantifiedFormula.getSubformula());
            this.beginScope(quantifiedFormula.getVariables());
        } else if (term instanceof LambdaTerm) {
            LambdaTerm lambdaTerm = (LambdaTerm)term;
            this.enqueueWalker(new BuildLambda(lambdaTerm));
            this.pushTerm(lambdaTerm.getSubterm());
            this.beginScope(lambdaTerm.getVariables());
        } else {
            if (term instanceof AnnotatedTerm) {
                Annotation annotation;
                AnnotatedTerm annotatedTerm = (AnnotatedTerm)term;
                this.enqueueWalker(new BuildAnnotation(annotatedTerm));
                ArrayDeque<Object> arrayDeque = new ArrayDeque<Object>();
                Annotation[] annotationArray = annotatedTerm.getAnnotations();
                int n = annotationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    annotation = annotationArray[n2];
                    if (annotation.getValue() != null) {
                        arrayDeque.add(annotation.getValue());
                    }
                    ++n2;
                }
                while (!arrayDeque.isEmpty()) {
                    annotation = arrayDeque.removeLast();
                    if (annotation instanceof Term) {
                        this.pushTerm((Term)((Object)annotation));
                        continue;
                    }
                    if (!(annotation instanceof Object[])) continue;
                    this.enqueueWalker(new BuildObjectArray((Object[])annotation));
                    Object[] objectArray = (Object[])annotation;
                    int n3 = objectArray.length;
                    n = 0;
                    while (n < n3) {
                        Object object = objectArray[n];
                        arrayDeque.add(object);
                        ++n;
                    }
                }
                this.pushTerm(annotatedTerm.getSubterm());
                return;
            }
            if (term instanceof MatchTerm) {
                MatchTerm matchTerm = (MatchTerm)term;
                this.enqueueWalker(new WalkMatchTerm(matchTerm));
                this.pushTerm(matchTerm.getDataTerm());
            } else {
                throw new AssertionError((Object)("Unknown Term: " + term.toStringDirect()));
            }
        }
    }

    public void convertApplicationTerm(ApplicationTerm applicationTerm, Term[] termArray) {
        Term term = applicationTerm;
        if (termArray != applicationTerm.getParameters()) {
            FunctionSymbol functionSymbol = applicationTerm.getFunction();
            Theory theory = functionSymbol.getTheory();
            term = theory.term(functionSymbol, termArray);
        }
        this.setResult(term);
    }

    public void preConvertLet(LetTerm letTerm, Term[] termArray) {
        this.beginScope(letTerm.getVariables());
        this.enqueueWalker(new BuildLetTerm(letTerm, termArray));
        this.pushTerm(letTerm.getSubTerm());
    }

    public void postConvertLet(LetTerm letTerm, Term[] termArray, Term term) {
        Term term2 = letTerm;
        if (letTerm.getValues() != termArray || letTerm.getSubTerm() != term) {
            term2 = letTerm.getTheory().let(letTerm.getVariables(), termArray, term);
        }
        this.setResult(term2);
    }

    public void postConvertLambda(LambdaTerm lambdaTerm, Term term) {
        Term term2 = lambdaTerm;
        if (term != lambdaTerm.getSubterm()) {
            Theory theory = lambdaTerm.getTheory();
            TermVariable[] termVariableArray = lambdaTerm.getVariables();
            term2 = theory.lambda(termVariableArray, term);
        }
        this.setResult(term2);
    }

    public void postConvertQuantifier(QuantifiedFormula quantifiedFormula, Term term) {
        Term term2 = quantifiedFormula;
        if (term != quantifiedFormula.getSubformula()) {
            Theory theory = quantifiedFormula.getTheory();
            TermVariable[] termVariableArray = quantifiedFormula.getVariables();
            term2 = quantifiedFormula.getQuantifier() == 0 ? theory.exists(termVariableArray, term) : theory.forall(termVariableArray, term);
        }
        this.setResult(term2);
    }

    public void postConvertAnnotation(AnnotatedTerm annotatedTerm, Annotation[] annotationArray, Term term) {
        Annotation[] annotationArray2 = annotatedTerm.getAnnotations();
        Term term2 = annotatedTerm;
        if (term != annotatedTerm.getSubterm() || annotationArray != annotationArray2) {
            term2 = annotatedTerm.getTheory().annotatedTerm(annotationArray, term);
        }
        this.setResult(term2);
    }

    public void preConvertMatchCase(MatchTerm matchTerm, int n) {
        this.beginScope(matchTerm.getVariables()[n]);
        this.pushTerm(matchTerm.getCases()[n]);
    }

    public void postConvertMatch(MatchTerm matchTerm, Term term, Term[] termArray) {
        Term term2 = matchTerm;
        if (term != matchTerm.getDataTerm() || termArray != matchTerm.getCases()) {
            Theory theory = matchTerm.getTheory();
            term2 = theory.match(term, matchTerm.getVariables(), termArray, matchTerm.getConstructors());
        }
        this.setResult(term2);
    }

    public final Term transform(Term term) {
        this.beginScope(new TermVariable[0]);
        this.run(new Convert(term));
        this.endScope();
        return this.mConverted.removeLast();
    }

    protected final Term getConverted() {
        return this.mConverted.removeLast();
    }

    protected final Object[] getConvertedObjectArray() {
        return this.mConvertedArrays.removeLast();
    }

    protected final Term[] getConverted(Term[] termArray) {
        Term[] termArray2 = termArray;
        int n = termArray.length - 1;
        while (n >= 0) {
            Term term = this.getConverted();
            if (term != termArray[n]) {
                if (termArray2 == termArray) {
                    termArray2 = (Term[])termArray.clone();
                }
                termArray2[n] = term;
            }
            --n;
        }
        return termArray2;
    }

    @Override
    public void reset() {
        super.reset();
        this.mConverted.clear();
        this.mCache.clear();
        this.mScopeMap.clear();
    }

    private static class AddCache
    implements NonRecursive.Walker {
        Term mOldTerm;

        public AddCache(Term term) {
            this.mOldTerm = term;
        }

        @Override
        public void walk(NonRecursive nonRecursive) {
            TermTransformer termTransformer = (TermTransformer)nonRecursive;
            int n = termTransformer.findScope(this.mOldTerm.getFreeVars());
            termTransformer.mCache.get(n).put(this.mOldTerm, termTransformer.mConverted.getLast());
        }

        public String toString() {
            return "AddCache[" + this.mOldTerm.toStringDirect() + "]";
        }
    }

    protected static class BuildAnnotation
    implements NonRecursive.Walker {
        private final AnnotatedTerm mAnnotatedTerm;

        public BuildAnnotation(AnnotatedTerm annotatedTerm) {
            this.mAnnotatedTerm = annotatedTerm;
        }

        @Override
        public void walk(NonRecursive nonRecursive) {
            Annotation[] annotationArray;
            TermTransformer termTransformer = (TermTransformer)nonRecursive;
            Annotation[] annotationArray2 = annotationArray = this.mAnnotatedTerm.getAnnotations();
            int n = annotationArray.length - 1;
            while (n >= 0) {
                Object object = annotationArray[n].getValue();
                Object object2 = object instanceof Term ? termTransformer.getConverted() : (object instanceof Object[] ? termTransformer.getConvertedObjectArray() : object);
                if (object2 != object) {
                    if (annotationArray == annotationArray2) {
                        annotationArray2 = (Annotation[])annotationArray.clone();
                    }
                    annotationArray2[n] = new Annotation(annotationArray[n].getKey(), object2);
                }
                --n;
            }
            Term term = termTransformer.getConverted();
            termTransformer.postConvertAnnotation(this.mAnnotatedTerm, annotationArray2, term);
        }

        public String toString() {
            return "annotate";
        }
    }

    protected static class BuildApplicationTerm
    implements NonRecursive.Walker {
        private final ApplicationTerm mAppTerm;

        public BuildApplicationTerm(ApplicationTerm applicationTerm) {
            this.mAppTerm = applicationTerm;
        }

        @Override
        public void walk(NonRecursive nonRecursive) {
            TermTransformer termTransformer = (TermTransformer)nonRecursive;
            Term[] termArray = this.mAppTerm.getParameters();
            Term[] termArray2 = termTransformer.getConverted(termArray);
            termTransformer.convertApplicationTerm(this.mAppTerm, termArray2);
        }

        public String toString() {
            return this.mAppTerm.getFunction().getApplicationString();
        }
    }

    protected static class BuildLambda
    implements NonRecursive.Walker {
        private final LambdaTerm mLambda;

        public BuildLambda(LambdaTerm lambdaTerm) {
            this.mLambda = lambdaTerm;
        }

        @Override
        public void walk(NonRecursive nonRecursive) {
            TermTransformer termTransformer = (TermTransformer)nonRecursive;
            Term term = termTransformer.getConverted();
            termTransformer.postConvertLambda(this.mLambda, term);
            termTransformer.endScope();
        }

        public String toString() {
            return "lambda";
        }
    }

    protected static class BuildLetTerm
    implements NonRecursive.Walker {
        private final LetTerm mLetTerm;
        private final Term[] mNewValues;

        public BuildLetTerm(LetTerm letTerm, Term[] termArray) {
            this.mLetTerm = letTerm;
            this.mNewValues = termArray;
        }

        @Override
        public void walk(NonRecursive nonRecursive) {
            TermTransformer termTransformer = (TermTransformer)nonRecursive;
            Term term = termTransformer.getConverted();
            termTransformer.postConvertLet(this.mLetTerm, this.mNewValues, term);
            termTransformer.endScope();
        }

        public String toString() {
            return "let" + Arrays.toString(this.mLetTerm.getVariables());
        }
    }

    protected static class BuildObjectArray
    implements NonRecursive.Walker {
        private final Object[] mArray;

        public BuildObjectArray(Object[] objectArray) {
            this.mArray = objectArray;
        }

        @Override
        public void walk(NonRecursive nonRecursive) {
            TermTransformer termTransformer = (TermTransformer)nonRecursive;
            Object[] objectArray = this.mArray;
            int n = objectArray.length - 1;
            while (n >= 0) {
                Object object = objectArray[n];
                Object object2 = object instanceof Term ? termTransformer.getConverted() : (object instanceof Object[] ? termTransformer.getConvertedObjectArray() : object);
                if (object2 != object) {
                    if (this.mArray == objectArray) {
                        objectArray = (Object[])this.mArray.clone();
                    }
                    objectArray[n] = object2;
                }
                --n;
            }
            termTransformer.mConvertedArrays.addLast(objectArray);
        }

        public String toString() {
            return "annotate";
        }
    }

    protected static class BuildQuantifier
    implements NonRecursive.Walker {
        private final QuantifiedFormula mQuant;

        public BuildQuantifier(QuantifiedFormula quantifiedFormula) {
            this.mQuant = quantifiedFormula;
        }

        @Override
        public void walk(NonRecursive nonRecursive) {
            TermTransformer termTransformer = (TermTransformer)nonRecursive;
            Term term = termTransformer.getConverted();
            termTransformer.postConvertQuantifier(this.mQuant, term);
            termTransformer.endScope();
        }

        public String toString() {
            return this.mQuant.getQuantifier() == 0 ? "exists" : "forall";
        }
    }

    private static class Convert
    implements NonRecursive.Walker {
        private final Term mTerm;

        public Convert(Term term) {
            this.mTerm = term;
        }

        public String toString() {
            return "Convert " + this.mTerm.toStringDirect();
        }

        @Override
        public void walk(NonRecursive nonRecursive) {
            ((TermTransformer)nonRecursive).cacheConvert(this.mTerm);
        }
    }

    protected static class StartLetTerm
    implements NonRecursive.Walker {
        private final LetTerm mLetTerm;

        public StartLetTerm(LetTerm letTerm) {
            this.mLetTerm = letTerm;
        }

        @Override
        public void walk(NonRecursive nonRecursive) {
            TermTransformer termTransformer = (TermTransformer)nonRecursive;
            Term[] termArray = termTransformer.getConverted(this.mLetTerm.getValues());
            termTransformer.preConvertLet(this.mLetTerm, termArray);
        }

        public String toString() {
            return "let" + Arrays.toString(this.mLetTerm.getVariables());
        }
    }

    protected static class WalkMatchTerm
    implements NonRecursive.Walker {
        private final MatchTerm mMatchTerm;
        private int mCaseNr;

        public WalkMatchTerm(MatchTerm matchTerm) {
            this.mMatchTerm = matchTerm;
            this.mCaseNr = 0;
        }

        @Override
        public void walk(NonRecursive nonRecursive) {
            TermTransformer termTransformer = (TermTransformer)nonRecursive;
            Term[] termArray = this.mMatchTerm.getCases();
            if (this.mCaseNr > 0) {
                termTransformer.endScope();
            }
            if (this.mCaseNr < termArray.length) {
                termTransformer.enqueueWalker(this);
                termTransformer.preConvertMatchCase(this.mMatchTerm, this.mCaseNr);
                ++this.mCaseNr;
            } else {
                Term[] termArray2 = termTransformer.getConverted(termArray);
                Term term = termTransformer.getConverted();
                termTransformer.postConvertMatch(this.mMatchTerm, term, termArray2);
            }
        }

        public String toString() {
            return "annotate";
        }
    }
}

