/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.preprocessor;

import de.uni_freiburg.informatik.ultimate.boogie.BoogieUtils;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssertStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AtomicStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Body;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BreakStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GotoStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IfStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Label;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LoopInvariantSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ReturnStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Unit;
import de.uni_freiburg.informatik.ultimate.boogie.ast.WhileStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.WildcardExpression;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.BoogiePreprocessorBacktranslator;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.boogie.typechecker.TypeCheckException;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.ConditionAnnotation;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.LoopEntryAnnotation;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.LoopExitAnnotation;
import de.uni_freiburg.informatik.ultimate.core.lib.observers.BaseObserver;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Set;
import java.util.Stack;

public class UnstructureCode
extends BaseObserver {
    private static final String sLabelPrefix = "$Ultimate##";
    private LinkedList<Statement> mFlatStatements;
    private int mLabelNr;
    private boolean mReachable;
    Stack<BreakInfo> mBreakStack;
    private final BoogiePreprocessorBacktranslator mTranslator;

    protected UnstructureCode(BoogiePreprocessorBacktranslator boogiePreprocessorBacktranslator) {
        this.mTranslator = boogiePreprocessorBacktranslator;
    }

    public BreakInfo findLabel(String string) {
        ListIterator listIterator = this.mBreakStack.listIterator(this.mBreakStack.size());
        while (listIterator.hasPrevious()) {
            BreakInfo breakInfo = (BreakInfo)listIterator.previous();
            if (!breakInfo.breakLabels.contains(string)) continue;
            return breakInfo;
        }
        throw new TypeCheckException("Break to label " + string + " cannot be resolved.");
    }

    public boolean process(IElement iElement) {
        if (iElement instanceof Unit) {
            Unit unit = (Unit)iElement;
            Declaration[] declarationArray = unit.getDeclarations();
            int n = declarationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Procedure procedure;
                Declaration declaration = declarationArray[n2];
                if (declaration instanceof Procedure && (procedure = (Procedure)declaration).getBody() != null) {
                    this.unstructureBody(procedure);
                }
                ++n2;
            }
            return false;
        }
        return true;
    }

    private void unstructureBody(Procedure procedure) {
        Body body = procedure.getBody();
        this.mFlatStatements = new LinkedList();
        this.mLabelNr = 0;
        this.mReachable = true;
        this.mBreakStack = new Stack();
        this.addLabel(BoogieUtils.constuctAuxiliaryLabel((ILocation)procedure.getLocation(), (String)this.generateLabel()));
        this.unstructureBlock(body.getBlock());
        if (this.mReachable) {
            this.mFlatStatements.add((Statement)new ReturnStatement(procedure.getLocation()));
        }
        body.setBlock(this.mFlatStatements.toArray(new Statement[this.mFlatStatements.size()]));
    }

    private void addLabel(Label label) {
        if (this.mReachable && !this.mFlatStatements.isEmpty() && !(this.mFlatStatements.getLast() instanceof Label)) {
            GotoStatement gotoStatement = new GotoStatement(label.getLocation(), new String[]{label.getName()});
            ModelUtils.copyAnnotations((IElement)label, (IElement)gotoStatement);
            this.mFlatStatements.add((Statement)gotoStatement);
        }
        this.mFlatStatements.add((Statement)label);
    }

    private void unstructureBlock(Statement[] statementArray) {
        BreakInfo breakInfo = new BreakInfo();
        int n = 0;
        while (n < statementArray.length) {
            Statement statement = statementArray[n];
            if (statement instanceof Label) {
                Label label = (Label)statement;
                if (label.getName().startsWith(sLabelPrefix)) {
                    throw new AssertionError((Object)"labels with prefix $Ultimate## are reseved for auxiliary labels and are disallowed in input ");
                }
                breakInfo.breakLabels.add(label.getName());
                this.addLabel(label);
                this.mReachable = true;
            } else {
                boolean bl = false;
                if (breakInfo.destLabel == null && n + 1 < statementArray.length && statementArray[n + 1] instanceof Label) {
                    breakInfo.destLabel = ((Label)statementArray[n + 1]).getName();
                    bl = true;
                }
                this.mBreakStack.push(breakInfo);
                this.unstructureStatement(breakInfo, statement);
                this.mBreakStack.pop();
                if (!bl && breakInfo.destLabel != null) {
                    this.addLabel(BoogieUtils.constuctAuxiliaryLabel((ILocation)statement.getLocation(), (String)breakInfo.destLabel));
                    this.mReachable = true;
                }
                breakInfo.clear();
            }
            ++n;
        }
    }

    private void unstructureStatement(BreakInfo breakInfo, Statement statement) {
        if (statement instanceof GotoStatement) {
            new LoopEntryAnnotation(LoopEntryAnnotation.LoopEntryType.GOTO).annotate((IElement)statement);
            this.mFlatStatements.add(statement);
            this.mReachable = false;
        } else if (statement instanceof ReturnStatement) {
            this.mFlatStatements.add(statement);
            this.mReachable = false;
        } else if (statement instanceof BreakStatement) {
            String string = ((BreakStatement)statement).getLabel();
            if (string == null) {
                string = "*";
            }
            BreakInfo breakInfo2 = this.findLabel(string);
            if (breakInfo2.destLabel == null) {
                breakInfo2.destLabel = this.generateLabel();
            }
            GotoStatement gotoStatement = new GotoStatement(statement.getLocation(), new String[]{breakInfo2.destLabel});
            new LoopExitAnnotation(LoopExitAnnotation.LoopExitType.BREAK).annotate((IElement)gotoStatement);
            this.postCreateStatement((BoogieASTNode)statement, (Statement)gotoStatement, false);
            this.mReachable = false;
        } else if (statement instanceof WhileStatement) {
            LoopInvariantSpecification loopInvariantSpecification;
            String string;
            WhileStatement whileStatement = (WhileStatement)statement;
            String string2 = this.generateLabel();
            String string3 = this.generateLabel();
            if (!(whileStatement.getCondition() instanceof WildcardExpression)) {
                string = this.generateLabel();
            } else {
                if (breakInfo.destLabel == null) {
                    breakInfo.destLabel = this.generateLabel();
                }
                string = breakInfo.destLabel;
            }
            ILocation iLocation = whileStatement.getLocation();
            Label label = new Label(iLocation, string2);
            new LoopEntryAnnotation(LoopEntryAnnotation.LoopEntryType.WHILE).annotate((IElement)label);
            this.addLabel(label);
            LoopInvariantSpecification[] loopInvariantSpecificationArray = whileStatement.getInvariants();
            int n = loopInvariantSpecificationArray.length;
            int n2 = 0;
            while (n2 < n) {
                loopInvariantSpecification = loopInvariantSpecificationArray[n2];
                if (loopInvariantSpecification.isFree()) {
                    this.postCreateStatement((BoogieASTNode)loopInvariantSpecification, (Statement)new AssumeStatement(loopInvariantSpecification.getLocation(), loopInvariantSpecification.getFormula()), true);
                } else {
                    this.postCreateStatement((BoogieASTNode)loopInvariantSpecification, (Statement)new AssertStatement(loopInvariantSpecification.getLocation(), loopInvariantSpecification.getFormula()), true);
                }
                ++n2;
            }
            this.postCreateStatement((BoogieASTNode)statement, (Statement)new GotoStatement(statement.getLocation(), new String[]{string3, string}), false);
            this.postCreateStatement((BoogieASTNode)statement, (Statement)BoogieUtils.constuctAuxiliaryLabel((ILocation)statement.getLocation(), (String)string3), false);
            if (whileStatement.getCondition() instanceof WildcardExpression) {
                loopInvariantSpecification = new AssumeStatement(whileStatement.getLocation(), (Expression)new BooleanLiteral(whileStatement.getCondition().getLocation(), (IBoogieType)BoogieType.TYPE_BOOL, true));
                new LoopEntryAnnotation(LoopEntryAnnotation.LoopEntryType.WHILE).annotate((IElement)loopInvariantSpecification);
                this.postCreateStatementFromCond((BoogieASTNode)statement, (AssumeStatement)loopInvariantSpecification, false, false);
            } else {
                loopInvariantSpecification = new AssumeStatement(whileStatement.getLocation(), whileStatement.getCondition());
                new LoopEntryAnnotation(LoopEntryAnnotation.LoopEntryType.WHILE).annotate((IElement)loopInvariantSpecification);
                this.postCreateStatementFromCond((BoogieASTNode)statement, (AssumeStatement)loopInvariantSpecification, false, false);
            }
            breakInfo.breakLabels.add("*");
            this.unstructureBlock(whileStatement.getBody());
            if (this.mReachable) {
                this.postCreateStatement((BoogieASTNode)statement, (Statement)new GotoStatement(statement.getLocation(), new String[]{string2}), false);
            }
            this.mReachable = false;
            if (!(whileStatement.getCondition() instanceof WildcardExpression)) {
                this.postCreateStatement((BoogieASTNode)statement, (Statement)BoogieUtils.constuctAuxiliaryLabel((ILocation)statement.getLocation(), (String)string), false);
                loopInvariantSpecification = new AssumeStatement(whileStatement.getLocation(), (Expression)new UnaryExpression(whileStatement.getCondition().getLocation(), (IBoogieType)BoogieType.TYPE_BOOL, UnaryExpression.Operator.LOGICNEG, whileStatement.getCondition()));
                new LoopExitAnnotation(LoopExitAnnotation.LoopExitType.WHILE).annotate((IElement)loopInvariantSpecification);
                this.postCreateStatementFromCond((BoogieASTNode)statement, (AssumeStatement)loopInvariantSpecification, true, false);
                this.mReachable = true;
            }
        } else if (statement instanceof AtomicStatement) {
            LinkedList<Statement> linkedList = this.mFlatStatements;
            this.mFlatStatements = new LinkedList();
            this.unstructureBlock(((AtomicStatement)statement).getBody());
            AtomicStatement atomicStatement = new AtomicStatement(statement.getLoc(), this.mFlatStatements.toArray(new Statement[this.mFlatStatements.size()]));
            ModelUtils.copyAnnotations((IElement)statement, (IElement)atomicStatement);
            linkedList.add((Statement)atomicStatement);
            this.mFlatStatements = linkedList;
        } else if (statement instanceof IfStatement) {
            IfStatement ifStatement = (IfStatement)statement;
            String string = this.generateLabel();
            String string4 = this.generateLabel();
            this.postCreateStatement((BoogieASTNode)statement, (Statement)new GotoStatement(ifStatement.getLocation(), new String[]{string, string4}), true);
            this.postCreateStatement((BoogieASTNode)statement, (Statement)BoogieUtils.constuctAuxiliaryLabel((ILocation)statement.getLocation(), (String)string), true);
            if (!(ifStatement.getCondition() instanceof WildcardExpression)) {
                this.postCreateStatementFromCond((BoogieASTNode)statement, new AssumeStatement(ifStatement.getLocation(), ifStatement.getCondition()), false, true);
            }
            this.unstructureBlock(ifStatement.getThenPart());
            if (this.mReachable) {
                if (breakInfo.destLabel == null) {
                    breakInfo.destLabel = this.generateLabel();
                }
                this.postCreateStatement((BoogieASTNode)statement, (Statement)new GotoStatement(statement.getLocation(), new String[]{breakInfo.destLabel}), true);
            }
            this.mReachable = true;
            this.postCreateStatement((BoogieASTNode)statement, (Statement)BoogieUtils.constuctAuxiliaryLabel((ILocation)statement.getLocation(), (String)string4), true);
            if (!(ifStatement.getCondition() instanceof WildcardExpression)) {
                this.postCreateStatementFromCond((BoogieASTNode)statement, new AssumeStatement(ifStatement.getLocation(), (Expression)new UnaryExpression(ifStatement.getCondition().getLocation(), (IBoogieType)BoogieType.TYPE_BOOL, UnaryExpression.Operator.LOGICNEG, ifStatement.getCondition())), true, true);
            }
            this.unstructureBlock(ifStatement.getElsePart());
        } else {
            this.mFlatStatements.add(statement);
        }
    }

    private void postCreateStatement(BoogieASTNode boogieASTNode, Statement statement, boolean bl) {
        if (bl) {
            ModelUtils.copyAnnotations((IElement)boogieASTNode, (IElement)statement);
        } else {
            ModelUtils.copyAnnotationsExcept((IElement)boogieASTNode, (IElement)statement, (Class[])new Class[]{LoopEntryAnnotation.class, LoopExitAnnotation.class});
        }
        this.mFlatStatements.add(statement);
        this.mTranslator.addMapping(boogieASTNode, (BoogieASTNode)statement);
    }

    private void postCreateStatementFromCond(BoogieASTNode boogieASTNode, AssumeStatement assumeStatement, boolean bl, boolean bl2) {
        this.postCreateStatement(boogieASTNode, (Statement)assumeStatement, bl2);
        new ConditionAnnotation(bl).annotate((IElement)assumeStatement);
    }

    private String generateLabel() {
        return sLabelPrefix + this.mLabelNr++;
    }

    private static final class BreakInfo {
        Set<String> breakLabels = new HashSet<String>();
        String destLabel;

        private BreakInfo() {
        }

        void clear() {
            this.breakLabels.clear();
            this.destLabel = null;
        }
    }
}

