/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker;

import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.GeometricNonTerminationArgument;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.InfiniteFixpointRepetition;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.InfiniteFixpointRepetitionWithExecution;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.NonTerminationArgument;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.SimpleCsvProvider;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class NonterminationArgumentStatistics
implements ICsvProviderProvider<String> {
    private final String mNtar;
    private final boolean mLambdaZero;
    private final boolean mGEVZero;
    private final int mNumberOfGevs;

    public NonterminationArgumentStatistics(NonTerminationArgument nonTerminationArgument) {
        if (nonTerminationArgument instanceof GeometricNonTerminationArgument) {
            GeometricNonTerminationArgument geometricNonTerminationArgument = (GeometricNonTerminationArgument)nonTerminationArgument;
            this.mNumberOfGevs = this.computeNumberOfGevs(((GeometricNonTerminationArgument)nonTerminationArgument).getGEVs());
            boolean bl = true;
            boolean bl2 = true;
            List<Rational> list = geometricNonTerminationArgument.getLambdas();
            int n = 0;
            while (n < geometricNonTerminationArgument.getNumberOfGEVs()) {
                bl &= geometricNonTerminationArgument.getLambdas().get(n).numerator().equals(BigInteger.ZERO);
                bl2 &= this.isZero(geometricNonTerminationArgument.getGEVs().get(n));
                ++n;
            }
            this.mLambdaZero = bl;
            this.mGEVZero = bl2;
            this.mNtar = (this.isFixpoint() ? "Fixpoint " : "Unbounded Execution ") + this.mNumberOfGevs + "GEVs Lambdas: " + String.valueOf(list) + " Mus: " + String.valueOf(geometricNonTerminationArgument.getNus());
        } else if (nonTerminationArgument instanceof InfiniteFixpointRepetition || nonTerminationArgument instanceof InfiniteFixpointRepetitionWithExecution) {
            this.mNtar = "Fixpoint";
            this.mLambdaZero = true;
            this.mGEVZero = true;
            this.mNumberOfGevs = 0;
        } else {
            throw new IllegalArgumentException("unknown NonTerminationArgument");
        }
    }

    private int computeNumberOfGevs(List<Map<IProgramVar, Rational>> list) {
        return (int)list.stream().filter(map -> map.entrySet().stream().anyMatch(entry -> !((Rational)entry.getValue()).equals((Object)Rational.ZERO))).count();
    }

    private boolean isFixpoint() {
        return this.mLambdaZero || this.mGEVZero;
    }

    private boolean isZero(Map<IProgramVar, Rational> map) {
        for (Map.Entry<IProgramVar, Rational> entry : map.entrySet()) {
            if (entry.getValue().numerator().equals(BigInteger.ZERO)) continue;
            return false;
        }
        return true;
    }

    public ICsvProvider<String> createCsvProvider() {
        return new SimpleCsvProvider(Arrays.asList("nta"));
    }

    public String toString() {
        return this.mNtar;
    }
}

